/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.cloudwatchevents.CloudWatchEventsClient;
import software.amazon.awssdk.services.cloudwatchevents.model.ActivateEventSourceRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.ActivateEventSourceResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.CloudWatchEventsException;
import software.amazon.awssdk.services.cloudwatchevents.model.ConcurrentModificationException;
import software.amazon.awssdk.services.cloudwatchevents.model.CreateEventBusRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.CreateEventBusResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.CreatePartnerEventSourceRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.CreatePartnerEventSourceResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.DeactivateEventSourceRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.DeactivateEventSourceResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.DeleteEventBusRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.DeleteEventBusResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.DeletePartnerEventSourceRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.DeletePartnerEventSourceResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.DeleteRuleRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.DeleteRuleResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.DescribeEventBusRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.DescribeEventBusResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.DescribeEventSourceRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.DescribeEventSourceResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.DescribePartnerEventSourceRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.DescribePartnerEventSourceResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.DescribeRuleRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.DescribeRuleResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.DisableRuleRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.DisableRuleResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.EnableRuleRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.EnableRuleResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.InternalException;
import software.amazon.awssdk.services.cloudwatchevents.model.InvalidEventPatternException;
import software.amazon.awssdk.services.cloudwatchevents.model.InvalidStateException;
import software.amazon.awssdk.services.cloudwatchevents.model.LimitExceededException;
import software.amazon.awssdk.services.cloudwatchevents.model.ListEventBusesRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.ListEventBusesResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.ListEventSourcesRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.ListEventSourcesResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.ListPartnerEventSourceAccountsRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.ListPartnerEventSourceAccountsResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.ListPartnerEventSourcesRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.ListPartnerEventSourcesResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.ListRuleNamesByTargetRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.ListRuleNamesByTargetResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.ListRulesRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.ListRulesResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.ListTargetsByRuleRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.ListTargetsByRuleResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.ManagedRuleException;
import software.amazon.awssdk.services.cloudwatchevents.model.OperationDisabledException;
import software.amazon.awssdk.services.cloudwatchevents.model.PolicyLengthExceededException;
import software.amazon.awssdk.services.cloudwatchevents.model.PutEventsRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.PutEventsResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.PutPartnerEventsRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.PutPartnerEventsResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.PutPermissionRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.PutPermissionResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.PutRuleRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.PutRuleResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.PutTargetsRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.PutTargetsResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.RemovePermissionRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.RemovePermissionResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.RemoveTargetsRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.RemoveTargetsResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.cloudwatchevents.model.ResourceNotFoundException;
import software.amazon.awssdk.services.cloudwatchevents.model.TagResourceRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.TagResourceResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.TestEventPatternRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.TestEventPatternResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.UntagResourceRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.UntagResourceResponse;
import software.amazon.awssdk.services.cloudwatchevents.transform.ActivateEventSourceRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.CreateEventBusRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.CreatePartnerEventSourceRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.DeactivateEventSourceRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.DeleteEventBusRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.DeletePartnerEventSourceRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.DeleteRuleRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.DescribeEventBusRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.DescribeEventSourceRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.DescribePartnerEventSourceRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.DescribeRuleRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.DisableRuleRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.EnableRuleRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.ListEventBusesRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.ListEventSourcesRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.ListPartnerEventSourceAccountsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.ListPartnerEventSourcesRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.ListRuleNamesByTargetRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.ListRulesRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.ListTargetsByRuleRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.PutEventsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.PutPartnerEventsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.PutPermissionRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.PutRuleRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.PutTargetsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.RemovePermissionRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.RemoveTargetsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.TestEventPatternRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.UntagResourceRequestMarshaller;

@SdkInternalApi
final class DefaultCloudWatchEventsClient
implements CloudWatchEventsClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCloudWatchEventsClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "events";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActivateEventSourceResponse activateEventSource(ActivateEventSourceRequest activateEventSourceRequest) throws ResourceNotFoundException, ConcurrentModificationException, InvalidStateException, InternalException, OperationDisabledException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ActivateEventSourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ActivateEventSource");
            ActivateEventSourceResponse activateEventSourceResponse = (ActivateEventSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ActivateEventSource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)activateEventSourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ActivateEventSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return activateEventSourceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(this.clientConfiguration, activateEventSourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateEventBusResponse createEventBus(CreateEventBusRequest createEventBusRequest) throws ResourceAlreadyExistsException, ResourceNotFoundException, InvalidStateException, InternalException, ConcurrentModificationException, LimitExceededException, OperationDisabledException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateEventBusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateEventBus");
            CreateEventBusResponse createEventBusResponse = (CreateEventBusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEventBus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createEventBusRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateEventBusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createEventBusResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(this.clientConfiguration, createEventBusRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePartnerEventSourceResponse createPartnerEventSource(CreatePartnerEventSourceRequest createPartnerEventSourceRequest) throws ResourceAlreadyExistsException, InternalException, ConcurrentModificationException, LimitExceededException, OperationDisabledException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePartnerEventSourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePartnerEventSource");
            CreatePartnerEventSourceResponse createPartnerEventSourceResponse = (CreatePartnerEventSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePartnerEventSource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createPartnerEventSourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreatePartnerEventSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createPartnerEventSourceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(this.clientConfiguration, createPartnerEventSourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeactivateEventSourceResponse deactivateEventSource(DeactivateEventSourceRequest deactivateEventSourceRequest) throws ResourceNotFoundException, ConcurrentModificationException, InvalidStateException, InternalException, OperationDisabledException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeactivateEventSourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeactivateEventSource");
            DeactivateEventSourceResponse deactivateEventSourceResponse = (DeactivateEventSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeactivateEventSource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deactivateEventSourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeactivateEventSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deactivateEventSourceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(this.clientConfiguration, deactivateEventSourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteEventBusResponse deleteEventBus(DeleteEventBusRequest deleteEventBusRequest) throws InternalException, ConcurrentModificationException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEventBusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEventBus");
            DeleteEventBusResponse deleteEventBusResponse = (DeleteEventBusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEventBus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteEventBusRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteEventBusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteEventBusResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(this.clientConfiguration, deleteEventBusRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePartnerEventSourceResponse deletePartnerEventSource(DeletePartnerEventSourceRequest deletePartnerEventSourceRequest) throws InternalException, ConcurrentModificationException, OperationDisabledException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePartnerEventSourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePartnerEventSource");
            DeletePartnerEventSourceResponse deletePartnerEventSourceResponse = (DeletePartnerEventSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePartnerEventSource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deletePartnerEventSourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeletePartnerEventSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deletePartnerEventSourceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(this.clientConfiguration, deletePartnerEventSourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteRuleResponse deleteRule(DeleteRuleRequest deleteRuleRequest) throws ConcurrentModificationException, ManagedRuleException, InternalException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRuleResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRule");
            DeleteRuleResponse deleteRuleResponse = (DeleteRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRule").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteRuleRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteRuleResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(this.clientConfiguration, deleteRuleRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEventBusResponse describeEventBus(DescribeEventBusRequest describeEventBusRequest) throws ResourceNotFoundException, InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEventBusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEventBus");
            DescribeEventBusResponse describeEventBusResponse = (DescribeEventBusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEventBus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEventBusRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEventBusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeEventBusResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(this.clientConfiguration, describeEventBusRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEventSourceResponse describeEventSource(DescribeEventSourceRequest describeEventSourceRequest) throws ResourceNotFoundException, InternalException, OperationDisabledException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEventSourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEventSource");
            DescribeEventSourceResponse describeEventSourceResponse = (DescribeEventSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEventSource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEventSourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEventSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeEventSourceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(this.clientConfiguration, describeEventSourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribePartnerEventSourceResponse describePartnerEventSource(DescribePartnerEventSourceRequest describePartnerEventSourceRequest) throws ResourceNotFoundException, InternalException, OperationDisabledException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribePartnerEventSourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribePartnerEventSource");
            DescribePartnerEventSourceResponse describePartnerEventSourceResponse = (DescribePartnerEventSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePartnerEventSource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describePartnerEventSourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribePartnerEventSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describePartnerEventSourceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(this.clientConfiguration, describePartnerEventSourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeRuleResponse describeRule(DescribeRuleRequest describeRuleRequest) throws ResourceNotFoundException, InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRuleResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRule");
            DescribeRuleResponse describeRuleResponse = (DescribeRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRule").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeRuleRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeRuleResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(this.clientConfiguration, describeRuleRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableRuleResponse disableRule(DisableRuleRequest disableRuleRequest) throws ResourceNotFoundException, ConcurrentModificationException, ManagedRuleException, InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableRuleResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableRule");
            DisableRuleResponse disableRuleResponse = (DisableRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableRule").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disableRuleRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DisableRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disableRuleResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(this.clientConfiguration, disableRuleRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableRuleResponse enableRule(EnableRuleRequest enableRuleRequest) throws ResourceNotFoundException, ConcurrentModificationException, ManagedRuleException, InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableRuleResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableRule");
            EnableRuleResponse enableRuleResponse = (EnableRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableRule").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)enableRuleRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new EnableRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return enableRuleResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(this.clientConfiguration, enableRuleRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListEventBusesResponse listEventBuses(ListEventBusesRequest listEventBusesRequest) throws InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEventBusesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEventBuses");
            ListEventBusesResponse listEventBusesResponse = (ListEventBusesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEventBuses").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listEventBusesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListEventBusesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listEventBusesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(this.clientConfiguration, listEventBusesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListEventSourcesResponse listEventSources(ListEventSourcesRequest listEventSourcesRequest) throws InternalException, OperationDisabledException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEventSourcesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEventSources");
            ListEventSourcesResponse listEventSourcesResponse = (ListEventSourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEventSources").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listEventSourcesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListEventSourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listEventSourcesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(this.clientConfiguration, listEventSourcesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPartnerEventSourceAccountsResponse listPartnerEventSourceAccounts(ListPartnerEventSourceAccountsRequest listPartnerEventSourceAccountsRequest) throws ResourceNotFoundException, InternalException, OperationDisabledException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPartnerEventSourceAccountsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPartnerEventSourceAccounts");
            ListPartnerEventSourceAccountsResponse listPartnerEventSourceAccountsResponse = (ListPartnerEventSourceAccountsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPartnerEventSourceAccounts").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPartnerEventSourceAccountsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListPartnerEventSourceAccountsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPartnerEventSourceAccountsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(this.clientConfiguration, listPartnerEventSourceAccountsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPartnerEventSourcesResponse listPartnerEventSources(ListPartnerEventSourcesRequest listPartnerEventSourcesRequest) throws InternalException, OperationDisabledException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPartnerEventSourcesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPartnerEventSources");
            ListPartnerEventSourcesResponse listPartnerEventSourcesResponse = (ListPartnerEventSourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPartnerEventSources").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPartnerEventSourcesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListPartnerEventSourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPartnerEventSourcesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(this.clientConfiguration, listPartnerEventSourcesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRuleNamesByTargetResponse listRuleNamesByTarget(ListRuleNamesByTargetRequest listRuleNamesByTargetRequest) throws InternalException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRuleNamesByTargetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRuleNamesByTarget");
            ListRuleNamesByTargetResponse listRuleNamesByTargetResponse = (ListRuleNamesByTargetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRuleNamesByTarget").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listRuleNamesByTargetRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListRuleNamesByTargetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listRuleNamesByTargetResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(this.clientConfiguration, listRuleNamesByTargetRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRulesResponse listRules(ListRulesRequest listRulesRequest) throws InternalException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRulesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRules");
            ListRulesResponse listRulesResponse = (ListRulesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRules").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listRulesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListRulesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listRulesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(this.clientConfiguration, listRulesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ResourceNotFoundException, InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTargetsByRuleResponse listTargetsByRule(ListTargetsByRuleRequest listTargetsByRuleRequest) throws ResourceNotFoundException, InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTargetsByRuleResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTargetsByRule");
            ListTargetsByRuleResponse listTargetsByRuleResponse = (ListTargetsByRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTargetsByRule").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTargetsByRuleRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListTargetsByRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTargetsByRuleResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(this.clientConfiguration, listTargetsByRuleRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutEventsResponse putEvents(PutEventsRequest putEventsRequest) throws InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutEventsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutEvents");
            PutEventsResponse putEventsResponse = (PutEventsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutEvents").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putEventsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new PutEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putEventsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(this.clientConfiguration, putEventsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutPartnerEventsResponse putPartnerEvents(PutPartnerEventsRequest putPartnerEventsRequest) throws InternalException, OperationDisabledException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutPartnerEventsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutPartnerEvents");
            PutPartnerEventsResponse putPartnerEventsResponse = (PutPartnerEventsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutPartnerEvents").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putPartnerEventsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new PutPartnerEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putPartnerEventsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(this.clientConfiguration, putPartnerEventsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutPermissionResponse putPermission(PutPermissionRequest putPermissionRequest) throws ResourceNotFoundException, PolicyLengthExceededException, InternalException, ConcurrentModificationException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutPermissionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutPermission");
            PutPermissionResponse putPermissionResponse = (PutPermissionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutPermission").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putPermissionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new PutPermissionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putPermissionResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(this.clientConfiguration, putPermissionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutRuleResponse putRule(PutRuleRequest putRuleRequest) throws InvalidEventPatternException, LimitExceededException, ConcurrentModificationException, ManagedRuleException, InternalException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutRuleResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutRule");
            PutRuleResponse putRuleResponse = (PutRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutRule").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putRuleRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new PutRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putRuleResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(this.clientConfiguration, putRuleRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutTargetsResponse putTargets(PutTargetsRequest putTargetsRequest) throws ResourceNotFoundException, ConcurrentModificationException, LimitExceededException, ManagedRuleException, InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutTargetsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutTargets");
            PutTargetsResponse putTargetsResponse = (PutTargetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutTargets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putTargetsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new PutTargetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putTargetsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(this.clientConfiguration, putTargetsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemovePermissionResponse removePermission(RemovePermissionRequest removePermissionRequest) throws ResourceNotFoundException, InternalException, ConcurrentModificationException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemovePermissionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemovePermission");
            RemovePermissionResponse removePermissionResponse = (RemovePermissionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemovePermission").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removePermissionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new RemovePermissionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return removePermissionResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(this.clientConfiguration, removePermissionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveTargetsResponse removeTargets(RemoveTargetsRequest removeTargetsRequest) throws ResourceNotFoundException, ConcurrentModificationException, ManagedRuleException, InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveTargetsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveTargets");
            RemoveTargetsResponse removeTargetsResponse = (RemoveTargetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveTargets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removeTargetsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new RemoveTargetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return removeTargetsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(this.clientConfiguration, removeTargetsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException, ConcurrentModificationException, InternalException, ManagedRuleException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TestEventPatternResponse testEventPattern(TestEventPatternRequest testEventPatternRequest) throws InvalidEventPatternException, InternalException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TestEventPatternResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TestEventPattern");
            TestEventPatternResponse testEventPatternResponse = (TestEventPatternResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TestEventPattern").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)testEventPatternRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new TestEventPatternRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return testEventPatternResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(this.clientConfiguration, testEventPatternRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException, InternalException, ConcurrentModificationException, ManagedRuleException, AwsServiceException, SdkClientException, CloudWatchEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultCloudWatchEventsClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CloudWatchEventsException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").exceptionBuilderSupplier(PolicyLengthExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidStateException").exceptionBuilderSupplier(InvalidStateException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").exceptionBuilderSupplier(InvalidEventPatternException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OperationDisabledException").exceptionBuilderSupplier(OperationDisabledException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalException").exceptionBuilderSupplier(InternalException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ManagedRuleException").exceptionBuilderSupplier(ManagedRuleException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }
}

