/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchevents.model.CloudWatchEventsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RemovePermissionRequest
extends CloudWatchEventsRequest
implements ToCopyableBuilder<Builder, RemovePermissionRequest> {
    private static final SdkField<String> STATEMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatementId").getter(RemovePermissionRequest.getter(RemovePermissionRequest::statementId)).setter(RemovePermissionRequest.setter(Builder::statementId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatementId").build()}).build();
    private static final SdkField<String> EVENT_BUS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventBusName").getter(RemovePermissionRequest.getter(RemovePermissionRequest::eventBusName)).setter(RemovePermissionRequest.setter(Builder::eventBusName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventBusName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATEMENT_ID_FIELD, EVENT_BUS_NAME_FIELD));
    private final String statementId;
    private final String eventBusName;

    private RemovePermissionRequest(BuilderImpl builder) {
        super(builder);
        this.statementId = builder.statementId;
        this.eventBusName = builder.eventBusName;
    }

    public String statementId() {
        return this.statementId;
    }

    public String eventBusName() {
        return this.eventBusName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.statementId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventBusName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemovePermissionRequest)) {
            return false;
        }
        RemovePermissionRequest other = (RemovePermissionRequest)((Object)obj);
        return Objects.equals(this.statementId(), other.statementId()) && Objects.equals(this.eventBusName(), other.eventBusName());
    }

    public String toString() {
        return ToString.builder((String)"RemovePermissionRequest").add("StatementId", (Object)this.statementId()).add("EventBusName", (Object)this.eventBusName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StatementId": {
                return Optional.ofNullable(clazz.cast(this.statementId()));
            }
            case "EventBusName": {
                return Optional.ofNullable(clazz.cast(this.eventBusName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemovePermissionRequest, T> g) {
        return obj -> g.apply((RemovePermissionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchEventsRequest.BuilderImpl
    implements Builder {
        private String statementId;
        private String eventBusName;

        private BuilderImpl() {
        }

        private BuilderImpl(RemovePermissionRequest model) {
            super(model);
            this.statementId(model.statementId);
            this.eventBusName(model.eventBusName);
        }

        public final String getStatementId() {
            return this.statementId;
        }

        @Override
        public final Builder statementId(String statementId) {
            this.statementId = statementId;
            return this;
        }

        public final void setStatementId(String statementId) {
            this.statementId = statementId;
        }

        public final String getEventBusName() {
            return this.eventBusName;
        }

        @Override
        public final Builder eventBusName(String eventBusName) {
            this.eventBusName = eventBusName;
            return this;
        }

        public final void setEventBusName(String eventBusName) {
            this.eventBusName = eventBusName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RemovePermissionRequest build() {
            return new RemovePermissionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchEventsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RemovePermissionRequest> {
        public Builder statementId(String var1);

        public Builder eventBusName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

