/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchevents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEventBusesResponse extends CloudWatchEventsResponse implements
        ToCopyableBuilder<ListEventBusesResponse.Builder, ListEventBusesResponse> {
    private static final SdkField<List<EventBus>> EVENT_BUSES_FIELD = SdkField
            .<List<EventBus>> builder(MarshallingType.LIST)
            .memberName("EventBuses")
            .getter(getter(ListEventBusesResponse::eventBuses))
            .setter(setter(Builder::eventBuses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventBuses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EventBus> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventBus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListEventBusesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_BUSES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<EventBus> eventBuses;

    private final String nextToken;

    private ListEventBusesResponse(BuilderImpl builder) {
        super(builder);
        this.eventBuses = builder.eventBuses;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the EventBuses property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasEventBuses() {
        return eventBuses != null && !(eventBuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * This list of event buses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEventBuses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return This list of event buses.
     */
    public List<EventBus> eventBuses() {
        return eventBuses;
    }

    /**
     * <p>
     * A token you can use in a subsequent operation to retrieve the next set of results.
     * </p>
     * 
     * @return A token you can use in a subsequent operation to retrieve the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(eventBuses());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEventBusesResponse)) {
            return false;
        }
        ListEventBusesResponse other = (ListEventBusesResponse) obj;
        return Objects.equals(eventBuses(), other.eventBuses()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListEventBusesResponse").add("EventBuses", eventBuses()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventBuses":
            return Optional.ofNullable(clazz.cast(eventBuses()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEventBusesResponse, T> g) {
        return obj -> g.apply((ListEventBusesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchEventsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListEventBusesResponse> {
        /**
         * <p>
         * This list of event buses.
         * </p>
         * 
         * @param eventBuses
         *        This list of event buses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventBuses(Collection<EventBus> eventBuses);

        /**
         * <p>
         * This list of event buses.
         * </p>
         * 
         * @param eventBuses
         *        This list of event buses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventBuses(EventBus... eventBuses);

        /**
         * <p>
         * This list of event buses.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EventBus>.Builder} avoiding the need to
         * create one manually via {@link List<EventBus>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EventBus>.Builder#build()} is called immediately and its
         * result is passed to {@link #eventBuses(List<EventBus>)}.
         * 
         * @param eventBuses
         *        a consumer that will call methods on {@link List<EventBus>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventBuses(List<EventBus>)
         */
        Builder eventBuses(Consumer<EventBus.Builder>... eventBuses);

        /**
         * <p>
         * A token you can use in a subsequent operation to retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        A token you can use in a subsequent operation to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudWatchEventsResponse.BuilderImpl implements Builder {
        private List<EventBus> eventBuses = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEventBusesResponse model) {
            super(model);
            eventBuses(model.eventBuses);
            nextToken(model.nextToken);
        }

        public final Collection<EventBus.Builder> getEventBuses() {
            return eventBuses != null ? eventBuses.stream().map(EventBus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder eventBuses(Collection<EventBus> eventBuses) {
            this.eventBuses = EventBusListCopier.copy(eventBuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventBuses(EventBus... eventBuses) {
            eventBuses(Arrays.asList(eventBuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventBuses(Consumer<EventBus.Builder>... eventBuses) {
            eventBuses(Stream.of(eventBuses).map(c -> EventBus.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEventBuses(Collection<EventBus.BuilderImpl> eventBuses) {
            this.eventBuses = EventBusListCopier.copyFromBuilder(eventBuses);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListEventBusesResponse build() {
            return new ListEventBusesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
