/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchevents.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListArchivesRequest extends CloudWatchEventsRequest implements
        ToCopyableBuilder<ListArchivesRequest.Builder, ListArchivesRequest> {
    private static final SdkField<String> NAME_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NamePrefix").getter(getter(ListArchivesRequest::namePrefix)).setter(setter(Builder::namePrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NamePrefix").build()).build();

    private static final SdkField<String> EVENT_SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventSourceArn").getter(getter(ListArchivesRequest::eventSourceArn))
            .setter(setter(Builder::eventSourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSourceArn").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(ListArchivesRequest::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListArchivesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Limit")
            .getter(getter(ListArchivesRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_PREFIX_FIELD,
            EVENT_SOURCE_ARN_FIELD, STATE_FIELD, NEXT_TOKEN_FIELD, LIMIT_FIELD));

    private final String namePrefix;

    private final String eventSourceArn;

    private final String state;

    private final String nextToken;

    private final Integer limit;

    private ListArchivesRequest(BuilderImpl builder) {
        super(builder);
        this.namePrefix = builder.namePrefix;
        this.eventSourceArn = builder.eventSourceArn;
        this.state = builder.state;
        this.nextToken = builder.nextToken;
        this.limit = builder.limit;
    }

    /**
     * <p>
     * A name prefix to filter the archives returned. Only archives with name that match the prefix are returned.
     * </p>
     * 
     * @return A name prefix to filter the archives returned. Only archives with name that match the prefix are
     *         returned.
     */
    public String namePrefix() {
        return namePrefix;
    }

    /**
     * <p>
     * The ARN of the event source associated with the archive.
     * </p>
     * 
     * @return The ARN of the event source associated with the archive.
     */
    public String eventSourceArn() {
        return eventSourceArn;
    }

    /**
     * <p>
     * The state of the archive.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ArchiveState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the archive.
     * @see ArchiveState
     */
    public ArchiveState state() {
        return ArchiveState.fromValue(state);
    }

    /**
     * <p>
     * The state of the archive.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ArchiveState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the archive.
     * @see ArchiveState
     */
    public String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The token returned by a previous call to retrieve the next set of results.
     * </p>
     * 
     * @return The token returned by a previous call to retrieve the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return.
     * </p>
     * 
     * @return The maximum number of results to return.
     */
    public Integer limit() {
        return limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(namePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(eventSourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListArchivesRequest)) {
            return false;
        }
        ListArchivesRequest other = (ListArchivesRequest) obj;
        return Objects.equals(namePrefix(), other.namePrefix()) && Objects.equals(eventSourceArn(), other.eventSourceArn())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(limit(), other.limit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListArchivesRequest").add("NamePrefix", namePrefix()).add("EventSourceArn", eventSourceArn())
                .add("State", stateAsString()).add("NextToken", nextToken()).add("Limit", limit()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NamePrefix":
            return Optional.ofNullable(clazz.cast(namePrefix()));
        case "EventSourceArn":
            return Optional.ofNullable(clazz.cast(eventSourceArn()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListArchivesRequest, T> g) {
        return obj -> g.apply((ListArchivesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchEventsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListArchivesRequest> {
        /**
         * <p>
         * A name prefix to filter the archives returned. Only archives with name that match the prefix are returned.
         * </p>
         * 
         * @param namePrefix
         *        A name prefix to filter the archives returned. Only archives with name that match the prefix are
         *        returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namePrefix(String namePrefix);

        /**
         * <p>
         * The ARN of the event source associated with the archive.
         * </p>
         * 
         * @param eventSourceArn
         *        The ARN of the event source associated with the archive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSourceArn(String eventSourceArn);

        /**
         * <p>
         * The state of the archive.
         * </p>
         * 
         * @param state
         *        The state of the archive.
         * @see ArchiveState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArchiveState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the archive.
         * </p>
         * 
         * @param state
         *        The state of the archive.
         * @see ArchiveState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArchiveState
         */
        Builder state(ArchiveState state);

        /**
         * <p>
         * The token returned by a previous call to retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token returned by a previous call to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return.
         * </p>
         * 
         * @param limit
         *        The maximum number of results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchEventsRequest.BuilderImpl implements Builder {
        private String namePrefix;

        private String eventSourceArn;

        private String state;

        private String nextToken;

        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(ListArchivesRequest model) {
            super(model);
            namePrefix(model.namePrefix);
            eventSourceArn(model.eventSourceArn);
            state(model.state);
            nextToken(model.nextToken);
            limit(model.limit);
        }

        public final String getNamePrefix() {
            return namePrefix;
        }

        @Override
        public final Builder namePrefix(String namePrefix) {
            this.namePrefix = namePrefix;
            return this;
        }

        public final void setNamePrefix(String namePrefix) {
            this.namePrefix = namePrefix;
        }

        public final String getEventSourceArn() {
            return eventSourceArn;
        }

        @Override
        public final Builder eventSourceArn(String eventSourceArn) {
            this.eventSourceArn = eventSourceArn;
            return this;
        }

        public final void setEventSourceArn(String eventSourceArn) {
            this.eventSourceArn = eventSourceArn;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ArchiveState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListArchivesRequest build() {
            return new ListArchivesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
