/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchevents.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateArchiveResponse extends CloudWatchEventsResponse implements
        ToCopyableBuilder<UpdateArchiveResponse.Builder, UpdateArchiveResponse> {
    private static final SdkField<String> ARCHIVE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArchiveArn").getter(getter(UpdateArchiveResponse::archiveArn)).setter(setter(Builder::archiveArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchiveArn").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(UpdateArchiveResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> STATE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StateReason").getter(getter(UpdateArchiveResponse::stateReason)).setter(setter(Builder::stateReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(UpdateArchiveResponse::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHIVE_ARN_FIELD,
            STATE_FIELD, STATE_REASON_FIELD, CREATION_TIME_FIELD));

    private final String archiveArn;

    private final String state;

    private final String stateReason;

    private final Instant creationTime;

    private UpdateArchiveResponse(BuilderImpl builder) {
        super(builder);
        this.archiveArn = builder.archiveArn;
        this.state = builder.state;
        this.stateReason = builder.stateReason;
        this.creationTime = builder.creationTime;
    }

    /**
     * <p>
     * The ARN of the archive.
     * </p>
     * 
     * @return The ARN of the archive.
     */
    public String archiveArn() {
        return archiveArn;
    }

    /**
     * <p>
     * The state of the archive.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ArchiveState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the archive.
     * @see ArchiveState
     */
    public ArchiveState state() {
        return ArchiveState.fromValue(state);
    }

    /**
     * <p>
     * The state of the archive.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ArchiveState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the archive.
     * @see ArchiveState
     */
    public String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The reason that the archive is in the current state.
     * </p>
     * 
     * @return The reason that the archive is in the current state.
     */
    public String stateReason() {
        return stateReason;
    }

    /**
     * <p>
     * The time at which the archive was updated.
     * </p>
     * 
     * @return The time at which the archive was updated.
     */
    public Instant creationTime() {
        return creationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(archiveArn());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateArchiveResponse)) {
            return false;
        }
        UpdateArchiveResponse other = (UpdateArchiveResponse) obj;
        return Objects.equals(archiveArn(), other.archiveArn()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(stateReason(), other.stateReason()) && Objects.equals(creationTime(), other.creationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateArchiveResponse").add("ArchiveArn", archiveArn()).add("State", stateAsString())
                .add("StateReason", stateReason()).add("CreationTime", creationTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ArchiveArn":
            return Optional.ofNullable(clazz.cast(archiveArn()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "StateReason":
            return Optional.ofNullable(clazz.cast(stateReason()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateArchiveResponse, T> g) {
        return obj -> g.apply((UpdateArchiveResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchEventsResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateArchiveResponse> {
        /**
         * <p>
         * The ARN of the archive.
         * </p>
         * 
         * @param archiveArn
         *        The ARN of the archive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder archiveArn(String archiveArn);

        /**
         * <p>
         * The state of the archive.
         * </p>
         * 
         * @param state
         *        The state of the archive.
         * @see ArchiveState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArchiveState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the archive.
         * </p>
         * 
         * @param state
         *        The state of the archive.
         * @see ArchiveState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArchiveState
         */
        Builder state(ArchiveState state);

        /**
         * <p>
         * The reason that the archive is in the current state.
         * </p>
         * 
         * @param stateReason
         *        The reason that the archive is in the current state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateReason(String stateReason);

        /**
         * <p>
         * The time at which the archive was updated.
         * </p>
         * 
         * @param creationTime
         *        The time at which the archive was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);
    }

    static final class BuilderImpl extends CloudWatchEventsResponse.BuilderImpl implements Builder {
        private String archiveArn;

        private String state;

        private String stateReason;

        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateArchiveResponse model) {
            super(model);
            archiveArn(model.archiveArn);
            state(model.state);
            stateReason(model.stateReason);
            creationTime(model.creationTime);
        }

        public final String getArchiveArn() {
            return archiveArn;
        }

        @Override
        public final Builder archiveArn(String archiveArn) {
            this.archiveArn = archiveArn;
            return this;
        }

        public final void setArchiveArn(String archiveArn) {
            this.archiveArn = archiveArn;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ArchiveState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStateReason() {
            return stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public UpdateArchiveResponse build() {
            return new UpdateArchiveResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
