/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cloudwatchevents.model.TransformerPathsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputTransformer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InputTransformer> {
    private static final SdkField<Map<String, String>> INPUT_PATHS_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("InputPathsMap").getter(InputTransformer.getter(InputTransformer::inputPathsMap)).setter(InputTransformer.setter(Builder::inputPathsMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputPathsMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> INPUT_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputTemplate").getter(InputTransformer.getter(InputTransformer::inputTemplate)).setter(InputTransformer.setter(Builder::inputTemplate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputTemplate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_PATHS_MAP_FIELD, INPUT_TEMPLATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, String> inputPathsMap;
    private final String inputTemplate;

    private InputTransformer(BuilderImpl builder) {
        this.inputPathsMap = builder.inputPathsMap;
        this.inputTemplate = builder.inputTemplate;
    }

    public boolean hasInputPathsMap() {
        return this.inputPathsMap != null && !(this.inputPathsMap instanceof SdkAutoConstructMap);
    }

    public Map<String, String> inputPathsMap() {
        return this.inputPathsMap;
    }

    public String inputTemplate() {
        return this.inputTemplate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputPathsMap() ? this.inputPathsMap() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.inputTemplate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputTransformer)) {
            return false;
        }
        InputTransformer other = (InputTransformer)obj;
        return this.hasInputPathsMap() == other.hasInputPathsMap() && Objects.equals(this.inputPathsMap(), other.inputPathsMap()) && Objects.equals(this.inputTemplate(), other.inputTemplate());
    }

    public String toString() {
        return ToString.builder((String)"InputTransformer").add("InputPathsMap", this.hasInputPathsMap() ? this.inputPathsMap() : null).add("InputTemplate", (Object)this.inputTemplate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InputPathsMap": {
                return Optional.ofNullable(clazz.cast(this.inputPathsMap()));
            }
            case "InputTemplate": {
                return Optional.ofNullable(clazz.cast(this.inputTemplate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputTransformer, T> g) {
        return obj -> g.apply((InputTransformer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> inputPathsMap = DefaultSdkAutoConstructMap.getInstance();
        private String inputTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(InputTransformer model) {
            this.inputPathsMap(model.inputPathsMap);
            this.inputTemplate(model.inputTemplate);
        }

        public final Map<String, String> getInputPathsMap() {
            if (this.inputPathsMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.inputPathsMap;
        }

        @Override
        public final Builder inputPathsMap(Map<String, String> inputPathsMap) {
            this.inputPathsMap = TransformerPathsCopier.copy(inputPathsMap);
            return this;
        }

        public final void setInputPathsMap(Map<String, String> inputPathsMap) {
            this.inputPathsMap = TransformerPathsCopier.copy(inputPathsMap);
        }

        public final String getInputTemplate() {
            return this.inputTemplate;
        }

        @Override
        public final Builder inputTemplate(String inputTemplate) {
            this.inputTemplate = inputTemplate;
            return this;
        }

        public final void setInputTemplate(String inputTemplate) {
            this.inputTemplate = inputTemplate;
        }

        public InputTransformer build() {
            return new InputTransformer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InputTransformer> {
        public Builder inputPathsMap(Map<String, String> var1);

        public Builder inputTemplate(String var1);
    }
}

