/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchevents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutEventsRequest extends CloudWatchEventsRequest implements
        ToCopyableBuilder<PutEventsRequest.Builder, PutEventsRequest> {
    private static final SdkField<List<PutEventsRequestEntry>> ENTRIES_FIELD = SdkField
            .<List<PutEventsRequestEntry>> builder(MarshallingType.LIST)
            .memberName("Entries")
            .getter(getter(PutEventsRequest::entries))
            .setter(setter(Builder::entries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PutEventsRequestEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(PutEventsRequestEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRIES_FIELD));

    private final List<PutEventsRequestEntry> entries;

    private PutEventsRequest(BuilderImpl builder) {
        super(builder);
        this.entries = builder.entries;
    }

    /**
     * Returns true if the Entries property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasEntries() {
        return entries != null && !(entries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The entry that defines an event in your system. You can specify several parameters for the entry such as the
     * source and type of the event, resources associated with the event, and so on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEntries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The entry that defines an event in your system. You can specify several parameters for the entry such as
     *         the source and type of the event, resources associated with the event, and so on.
     */
    public final List<PutEventsRequestEntry> entries() {
        return entries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEntries() ? entries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEventsRequest)) {
            return false;
        }
        PutEventsRequest other = (PutEventsRequest) obj;
        return hasEntries() == other.hasEntries() && Objects.equals(entries(), other.entries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutEventsRequest").add("Entries", hasEntries() ? entries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Entries":
            return Optional.ofNullable(clazz.cast(entries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutEventsRequest, T> g) {
        return obj -> g.apply((PutEventsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchEventsRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutEventsRequest> {
        /**
         * <p>
         * The entry that defines an event in your system. You can specify several parameters for the entry such as the
         * source and type of the event, resources associated with the event, and so on.
         * </p>
         * 
         * @param entries
         *        The entry that defines an event in your system. You can specify several parameters for the entry such
         *        as the source and type of the event, resources associated with the event, and so on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(Collection<PutEventsRequestEntry> entries);

        /**
         * <p>
         * The entry that defines an event in your system. You can specify several parameters for the entry such as the
         * source and type of the event, resources associated with the event, and so on.
         * </p>
         * 
         * @param entries
         *        The entry that defines an event in your system. You can specify several parameters for the entry such
         *        as the source and type of the event, resources associated with the event, and so on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(PutEventsRequestEntry... entries);

        /**
         * <p>
         * The entry that defines an event in your system. You can specify several parameters for the entry such as the
         * source and type of the event, resources associated with the event, and so on.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PutEventsRequestEntry>.Builder} avoiding
         * the need to create one manually via {@link List<PutEventsRequestEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PutEventsRequestEntry>.Builder#build()} is called
         * immediately and its result is passed to {@link #entries(List<PutEventsRequestEntry>)}.
         * 
         * @param entries
         *        a consumer that will call methods on {@link List<PutEventsRequestEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entries(List<PutEventsRequestEntry>)
         */
        Builder entries(Consumer<PutEventsRequestEntry.Builder>... entries);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchEventsRequest.BuilderImpl implements Builder {
        private List<PutEventsRequestEntry> entries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutEventsRequest model) {
            super(model);
            entries(model.entries);
        }

        public final Collection<PutEventsRequestEntry.Builder> getEntries() {
            if (entries instanceof SdkAutoConstructList) {
                return null;
            }
            return entries != null ? entries.stream().map(PutEventsRequestEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder entries(Collection<PutEventsRequestEntry> entries) {
            this.entries = PutEventsRequestEntryListCopier.copy(entries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(PutEventsRequestEntry... entries) {
            entries(Arrays.asList(entries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(Consumer<PutEventsRequestEntry.Builder>... entries) {
            entries(Stream.of(entries).map(c -> PutEventsRequestEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEntries(Collection<PutEventsRequestEntry.BuilderImpl> entries) {
            this.entries = PutEventsRequestEntryListCopier.copyFromBuilder(entries);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutEventsRequest build() {
            return new PutEventsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
