/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchevents.model.ConnectionBodyParameter;
import software.amazon.awssdk.services.cloudwatchevents.model.ConnectionBodyParametersListCopier;
import software.amazon.awssdk.services.cloudwatchevents.model.ConnectionHeaderParameter;
import software.amazon.awssdk.services.cloudwatchevents.model.ConnectionHeaderParametersListCopier;
import software.amazon.awssdk.services.cloudwatchevents.model.ConnectionQueryStringParameter;
import software.amazon.awssdk.services.cloudwatchevents.model.ConnectionQueryStringParametersListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectionHttpParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectionHttpParameters> {
    private static final SdkField<List<ConnectionHeaderParameter>> HEADER_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HeaderParameters").getter(ConnectionHttpParameters.getter(ConnectionHttpParameters::headerParameters)).setter(ConnectionHttpParameters.setter(Builder::headerParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeaderParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConnectionHeaderParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ConnectionQueryStringParameter>> QUERY_STRING_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("QueryStringParameters").getter(ConnectionHttpParameters.getter(ConnectionHttpParameters::queryStringParameters)).setter(ConnectionHttpParameters.setter(Builder::queryStringParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryStringParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConnectionQueryStringParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ConnectionBodyParameter>> BODY_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BodyParameters").getter(ConnectionHttpParameters.getter(ConnectionHttpParameters::bodyParameters)).setter(ConnectionHttpParameters.setter(Builder::bodyParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BodyParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConnectionBodyParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEADER_PARAMETERS_FIELD, QUERY_STRING_PARAMETERS_FIELD, BODY_PARAMETERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<ConnectionHeaderParameter> headerParameters;
    private final List<ConnectionQueryStringParameter> queryStringParameters;
    private final List<ConnectionBodyParameter> bodyParameters;

    private ConnectionHttpParameters(BuilderImpl builder) {
        this.headerParameters = builder.headerParameters;
        this.queryStringParameters = builder.queryStringParameters;
        this.bodyParameters = builder.bodyParameters;
    }

    public final boolean hasHeaderParameters() {
        return this.headerParameters != null && !(this.headerParameters instanceof SdkAutoConstructList);
    }

    public final List<ConnectionHeaderParameter> headerParameters() {
        return this.headerParameters;
    }

    public final boolean hasQueryStringParameters() {
        return this.queryStringParameters != null && !(this.queryStringParameters instanceof SdkAutoConstructList);
    }

    public final List<ConnectionQueryStringParameter> queryStringParameters() {
        return this.queryStringParameters;
    }

    public final boolean hasBodyParameters() {
        return this.bodyParameters != null && !(this.bodyParameters instanceof SdkAutoConstructList);
    }

    public final List<ConnectionBodyParameter> bodyParameters() {
        return this.bodyParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHeaderParameters() ? this.headerParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQueryStringParameters() ? this.queryStringParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBodyParameters() ? this.bodyParameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionHttpParameters)) {
            return false;
        }
        ConnectionHttpParameters other = (ConnectionHttpParameters)obj;
        return this.hasHeaderParameters() == other.hasHeaderParameters() && Objects.equals(this.headerParameters(), other.headerParameters()) && this.hasQueryStringParameters() == other.hasQueryStringParameters() && Objects.equals(this.queryStringParameters(), other.queryStringParameters()) && this.hasBodyParameters() == other.hasBodyParameters() && Objects.equals(this.bodyParameters(), other.bodyParameters());
    }

    public final String toString() {
        return ToString.builder((String)"ConnectionHttpParameters").add("HeaderParameters", this.hasHeaderParameters() ? this.headerParameters() : null).add("QueryStringParameters", this.hasQueryStringParameters() ? this.queryStringParameters() : null).add("BodyParameters", this.hasBodyParameters() ? this.bodyParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HeaderParameters": {
                return Optional.ofNullable(clazz.cast(this.headerParameters()));
            }
            case "QueryStringParameters": {
                return Optional.ofNullable(clazz.cast(this.queryStringParameters()));
            }
            case "BodyParameters": {
                return Optional.ofNullable(clazz.cast(this.bodyParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectionHttpParameters, T> g) {
        return obj -> g.apply((ConnectionHttpParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ConnectionHeaderParameter> headerParameters = DefaultSdkAutoConstructList.getInstance();
        private List<ConnectionQueryStringParameter> queryStringParameters = DefaultSdkAutoConstructList.getInstance();
        private List<ConnectionBodyParameter> bodyParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionHttpParameters model) {
            this.headerParameters(model.headerParameters);
            this.queryStringParameters(model.queryStringParameters);
            this.bodyParameters(model.bodyParameters);
        }

        public final Collection<ConnectionHeaderParameter.Builder> getHeaderParameters() {
            if (this.headerParameters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.headerParameters != null ? (Collection)this.headerParameters.stream().map(ConnectionHeaderParameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder headerParameters(Collection<ConnectionHeaderParameter> headerParameters) {
            this.headerParameters = ConnectionHeaderParametersListCopier.copy(headerParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headerParameters(ConnectionHeaderParameter ... headerParameters) {
            this.headerParameters(Arrays.asList(headerParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headerParameters(Consumer<ConnectionHeaderParameter.Builder> ... headerParameters) {
            this.headerParameters(Stream.of(headerParameters).map(c -> (ConnectionHeaderParameter)((ConnectionHeaderParameter.Builder)ConnectionHeaderParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setHeaderParameters(Collection<ConnectionHeaderParameter.BuilderImpl> headerParameters) {
            this.headerParameters = ConnectionHeaderParametersListCopier.copyFromBuilder(headerParameters);
        }

        public final Collection<ConnectionQueryStringParameter.Builder> getQueryStringParameters() {
            if (this.queryStringParameters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.queryStringParameters != null ? (Collection)this.queryStringParameters.stream().map(ConnectionQueryStringParameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder queryStringParameters(Collection<ConnectionQueryStringParameter> queryStringParameters) {
            this.queryStringParameters = ConnectionQueryStringParametersListCopier.copy(queryStringParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryStringParameters(ConnectionQueryStringParameter ... queryStringParameters) {
            this.queryStringParameters(Arrays.asList(queryStringParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryStringParameters(Consumer<ConnectionQueryStringParameter.Builder> ... queryStringParameters) {
            this.queryStringParameters(Stream.of(queryStringParameters).map(c -> (ConnectionQueryStringParameter)((ConnectionQueryStringParameter.Builder)ConnectionQueryStringParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setQueryStringParameters(Collection<ConnectionQueryStringParameter.BuilderImpl> queryStringParameters) {
            this.queryStringParameters = ConnectionQueryStringParametersListCopier.copyFromBuilder(queryStringParameters);
        }

        public final Collection<ConnectionBodyParameter.Builder> getBodyParameters() {
            if (this.bodyParameters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.bodyParameters != null ? (Collection)this.bodyParameters.stream().map(ConnectionBodyParameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder bodyParameters(Collection<ConnectionBodyParameter> bodyParameters) {
            this.bodyParameters = ConnectionBodyParametersListCopier.copy(bodyParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bodyParameters(ConnectionBodyParameter ... bodyParameters) {
            this.bodyParameters(Arrays.asList(bodyParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bodyParameters(Consumer<ConnectionBodyParameter.Builder> ... bodyParameters) {
            this.bodyParameters(Stream.of(bodyParameters).map(c -> (ConnectionBodyParameter)((ConnectionBodyParameter.Builder)ConnectionBodyParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBodyParameters(Collection<ConnectionBodyParameter.BuilderImpl> bodyParameters) {
            this.bodyParameters = ConnectionBodyParametersListCopier.copyFromBuilder(bodyParameters);
        }

        public ConnectionHttpParameters build() {
            return new ConnectionHttpParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectionHttpParameters> {
        public Builder headerParameters(Collection<ConnectionHeaderParameter> var1);

        public Builder headerParameters(ConnectionHeaderParameter ... var1);

        public Builder headerParameters(Consumer<ConnectionHeaderParameter.Builder> ... var1);

        public Builder queryStringParameters(Collection<ConnectionQueryStringParameter> var1);

        public Builder queryStringParameters(ConnectionQueryStringParameter ... var1);

        public Builder queryStringParameters(Consumer<ConnectionQueryStringParameter.Builder> ... var1);

        public Builder bodyParameters(Collection<ConnectionBodyParameter> var1);

        public Builder bodyParameters(ConnectionBodyParameter ... var1);

        public Builder bodyParameters(Consumer<ConnectionBodyParameter.Builder> ... var1);
    }
}

