/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchevents.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about an API destination.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApiDestination implements SdkPojo, Serializable, ToCopyableBuilder<ApiDestination.Builder, ApiDestination> {
    private static final SdkField<String> API_DESTINATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApiDestinationArn").getter(getter(ApiDestination::apiDestinationArn))
            .setter(setter(Builder::apiDestinationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiDestinationArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ApiDestination::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> API_DESTINATION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApiDestinationState").getter(getter(ApiDestination::apiDestinationStateAsString))
            .setter(setter(Builder::apiDestinationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiDestinationState").build())
            .build();

    private static final SdkField<String> CONNECTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionArn").getter(getter(ApiDestination::connectionArn)).setter(setter(Builder::connectionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionArn").build()).build();

    private static final SdkField<String> INVOCATION_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InvocationEndpoint").getter(getter(ApiDestination::invocationEndpoint))
            .setter(setter(Builder::invocationEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationEndpoint").build())
            .build();

    private static final SdkField<String> HTTP_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HttpMethod").getter(getter(ApiDestination::httpMethodAsString)).setter(setter(Builder::httpMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpMethod").build()).build();

    private static final SdkField<Integer> INVOCATION_RATE_LIMIT_PER_SECOND_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("InvocationRateLimitPerSecond")
            .getter(getter(ApiDestination::invocationRateLimitPerSecond))
            .setter(setter(Builder::invocationRateLimitPerSecond))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationRateLimitPerSecond")
                    .build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(ApiDestination::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(ApiDestination::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_DESTINATION_ARN_FIELD,
            NAME_FIELD, API_DESTINATION_STATE_FIELD, CONNECTION_ARN_FIELD, INVOCATION_ENDPOINT_FIELD, HTTP_METHOD_FIELD,
            INVOCATION_RATE_LIMIT_PER_SECOND_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String apiDestinationArn;

    private final String name;

    private final String apiDestinationState;

    private final String connectionArn;

    private final String invocationEndpoint;

    private final String httpMethod;

    private final Integer invocationRateLimitPerSecond;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private ApiDestination(BuilderImpl builder) {
        this.apiDestinationArn = builder.apiDestinationArn;
        this.name = builder.name;
        this.apiDestinationState = builder.apiDestinationState;
        this.connectionArn = builder.connectionArn;
        this.invocationEndpoint = builder.invocationEndpoint;
        this.httpMethod = builder.httpMethod;
        this.invocationRateLimitPerSecond = builder.invocationRateLimitPerSecond;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    /**
     * <p>
     * The ARN of the API destination.
     * </p>
     * 
     * @return The ARN of the API destination.
     */
    public final String apiDestinationArn() {
        return apiDestinationArn;
    }

    /**
     * <p>
     * The name of the API destination.
     * </p>
     * 
     * @return The name of the API destination.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The state of the API destination.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #apiDestinationState} will return {@link ApiDestinationState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #apiDestinationStateAsString}.
     * </p>
     * 
     * @return The state of the API destination.
     * @see ApiDestinationState
     */
    public final ApiDestinationState apiDestinationState() {
        return ApiDestinationState.fromValue(apiDestinationState);
    }

    /**
     * <p>
     * The state of the API destination.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #apiDestinationState} will return {@link ApiDestinationState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #apiDestinationStateAsString}.
     * </p>
     * 
     * @return The state of the API destination.
     * @see ApiDestinationState
     */
    public final String apiDestinationStateAsString() {
        return apiDestinationState;
    }

    /**
     * <p>
     * The ARN of the connection specified for the API destination.
     * </p>
     * 
     * @return The ARN of the connection specified for the API destination.
     */
    public final String connectionArn() {
        return connectionArn;
    }

    /**
     * <p>
     * The URL to the endpoint for the API destination.
     * </p>
     * 
     * @return The URL to the endpoint for the API destination.
     */
    public final String invocationEndpoint() {
        return invocationEndpoint;
    }

    /**
     * <p>
     * The method to use to connect to the HTTP endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #httpMethod} will
     * return {@link ApiDestinationHttpMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #httpMethodAsString}.
     * </p>
     * 
     * @return The method to use to connect to the HTTP endpoint.
     * @see ApiDestinationHttpMethod
     */
    public final ApiDestinationHttpMethod httpMethod() {
        return ApiDestinationHttpMethod.fromValue(httpMethod);
    }

    /**
     * <p>
     * The method to use to connect to the HTTP endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #httpMethod} will
     * return {@link ApiDestinationHttpMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #httpMethodAsString}.
     * </p>
     * 
     * @return The method to use to connect to the HTTP endpoint.
     * @see ApiDestinationHttpMethod
     */
    public final String httpMethodAsString() {
        return httpMethod;
    }

    /**
     * <p>
     * The maximum number of invocations per second to send to the HTTP endpoint.
     * </p>
     * 
     * @return The maximum number of invocations per second to send to the HTTP endpoint.
     */
    public final Integer invocationRateLimitPerSecond() {
        return invocationRateLimitPerSecond;
    }

    /**
     * <p>
     * A time stamp for the time that the API destination was created.
     * </p>
     * 
     * @return A time stamp for the time that the API destination was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * A time stamp for the time that the API destination was last modified.
     * </p>
     * 
     * @return A time stamp for the time that the API destination was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(apiDestinationArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(apiDestinationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(connectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(invocationEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(httpMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(invocationRateLimitPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApiDestination)) {
            return false;
        }
        ApiDestination other = (ApiDestination) obj;
        return Objects.equals(apiDestinationArn(), other.apiDestinationArn()) && Objects.equals(name(), other.name())
                && Objects.equals(apiDestinationStateAsString(), other.apiDestinationStateAsString())
                && Objects.equals(connectionArn(), other.connectionArn())
                && Objects.equals(invocationEndpoint(), other.invocationEndpoint())
                && Objects.equals(httpMethodAsString(), other.httpMethodAsString())
                && Objects.equals(invocationRateLimitPerSecond(), other.invocationRateLimitPerSecond())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApiDestination").add("ApiDestinationArn", apiDestinationArn()).add("Name", name())
                .add("ApiDestinationState", apiDestinationStateAsString()).add("ConnectionArn", connectionArn())
                .add("InvocationEndpoint", invocationEndpoint()).add("HttpMethod", httpMethodAsString())
                .add("InvocationRateLimitPerSecond", invocationRateLimitPerSecond()).add("CreationTime", creationTime())
                .add("LastModifiedTime", lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApiDestinationArn":
            return Optional.ofNullable(clazz.cast(apiDestinationArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ApiDestinationState":
            return Optional.ofNullable(clazz.cast(apiDestinationStateAsString()));
        case "ConnectionArn":
            return Optional.ofNullable(clazz.cast(connectionArn()));
        case "InvocationEndpoint":
            return Optional.ofNullable(clazz.cast(invocationEndpoint()));
        case "HttpMethod":
            return Optional.ofNullable(clazz.cast(httpMethodAsString()));
        case "InvocationRateLimitPerSecond":
            return Optional.ofNullable(clazz.cast(invocationRateLimitPerSecond()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApiDestination, T> g) {
        return obj -> g.apply((ApiDestination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApiDestination> {
        /**
         * <p>
         * The ARN of the API destination.
         * </p>
         * 
         * @param apiDestinationArn
         *        The ARN of the API destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiDestinationArn(String apiDestinationArn);

        /**
         * <p>
         * The name of the API destination.
         * </p>
         * 
         * @param name
         *        The name of the API destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The state of the API destination.
         * </p>
         * 
         * @param apiDestinationState
         *        The state of the API destination.
         * @see ApiDestinationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApiDestinationState
         */
        Builder apiDestinationState(String apiDestinationState);

        /**
         * <p>
         * The state of the API destination.
         * </p>
         * 
         * @param apiDestinationState
         *        The state of the API destination.
         * @see ApiDestinationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApiDestinationState
         */
        Builder apiDestinationState(ApiDestinationState apiDestinationState);

        /**
         * <p>
         * The ARN of the connection specified for the API destination.
         * </p>
         * 
         * @param connectionArn
         *        The ARN of the connection specified for the API destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionArn(String connectionArn);

        /**
         * <p>
         * The URL to the endpoint for the API destination.
         * </p>
         * 
         * @param invocationEndpoint
         *        The URL to the endpoint for the API destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationEndpoint(String invocationEndpoint);

        /**
         * <p>
         * The method to use to connect to the HTTP endpoint.
         * </p>
         * 
         * @param httpMethod
         *        The method to use to connect to the HTTP endpoint.
         * @see ApiDestinationHttpMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApiDestinationHttpMethod
         */
        Builder httpMethod(String httpMethod);

        /**
         * <p>
         * The method to use to connect to the HTTP endpoint.
         * </p>
         * 
         * @param httpMethod
         *        The method to use to connect to the HTTP endpoint.
         * @see ApiDestinationHttpMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApiDestinationHttpMethod
         */
        Builder httpMethod(ApiDestinationHttpMethod httpMethod);

        /**
         * <p>
         * The maximum number of invocations per second to send to the HTTP endpoint.
         * </p>
         * 
         * @param invocationRateLimitPerSecond
         *        The maximum number of invocations per second to send to the HTTP endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationRateLimitPerSecond(Integer invocationRateLimitPerSecond);

        /**
         * <p>
         * A time stamp for the time that the API destination was created.
         * </p>
         * 
         * @param creationTime
         *        A time stamp for the time that the API destination was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * A time stamp for the time that the API destination was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        A time stamp for the time that the API destination was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);
    }

    static final class BuilderImpl implements Builder {
        private String apiDestinationArn;

        private String name;

        private String apiDestinationState;

        private String connectionArn;

        private String invocationEndpoint;

        private String httpMethod;

        private Integer invocationRateLimitPerSecond;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ApiDestination model) {
            apiDestinationArn(model.apiDestinationArn);
            name(model.name);
            apiDestinationState(model.apiDestinationState);
            connectionArn(model.connectionArn);
            invocationEndpoint(model.invocationEndpoint);
            httpMethod(model.httpMethod);
            invocationRateLimitPerSecond(model.invocationRateLimitPerSecond);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
        }

        public final String getApiDestinationArn() {
            return apiDestinationArn;
        }

        @Override
        public final Builder apiDestinationArn(String apiDestinationArn) {
            this.apiDestinationArn = apiDestinationArn;
            return this;
        }

        public final void setApiDestinationArn(String apiDestinationArn) {
            this.apiDestinationArn = apiDestinationArn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getApiDestinationState() {
            return apiDestinationState;
        }

        @Override
        public final Builder apiDestinationState(String apiDestinationState) {
            this.apiDestinationState = apiDestinationState;
            return this;
        }

        @Override
        public final Builder apiDestinationState(ApiDestinationState apiDestinationState) {
            this.apiDestinationState(apiDestinationState == null ? null : apiDestinationState.toString());
            return this;
        }

        public final void setApiDestinationState(String apiDestinationState) {
            this.apiDestinationState = apiDestinationState;
        }

        public final String getConnectionArn() {
            return connectionArn;
        }

        @Override
        public final Builder connectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
            return this;
        }

        public final void setConnectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
        }

        public final String getInvocationEndpoint() {
            return invocationEndpoint;
        }

        @Override
        public final Builder invocationEndpoint(String invocationEndpoint) {
            this.invocationEndpoint = invocationEndpoint;
            return this;
        }

        public final void setInvocationEndpoint(String invocationEndpoint) {
            this.invocationEndpoint = invocationEndpoint;
        }

        public final String getHttpMethod() {
            return httpMethod;
        }

        @Override
        public final Builder httpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        @Override
        public final Builder httpMethod(ApiDestinationHttpMethod httpMethod) {
            this.httpMethod(httpMethod == null ? null : httpMethod.toString());
            return this;
        }

        public final void setHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
        }

        public final Integer getInvocationRateLimitPerSecond() {
            return invocationRateLimitPerSecond;
        }

        @Override
        public final Builder invocationRateLimitPerSecond(Integer invocationRateLimitPerSecond) {
            this.invocationRateLimitPerSecond = invocationRateLimitPerSecond;
            return this;
        }

        public final void setInvocationRateLimitPerSecond(Integer invocationRateLimitPerSecond) {
            this.invocationRateLimitPerSecond = invocationRateLimitPerSecond;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public ApiDestination build() {
            return new ApiDestination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
