/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchevents.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateApiDestinationResponse extends CloudWatchEventsResponse implements
        ToCopyableBuilder<CreateApiDestinationResponse.Builder, CreateApiDestinationResponse> {
    private static final SdkField<String> API_DESTINATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApiDestinationArn").getter(getter(CreateApiDestinationResponse::apiDestinationArn))
            .setter(setter(Builder::apiDestinationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiDestinationArn").build()).build();

    private static final SdkField<String> API_DESTINATION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApiDestinationState").getter(getter(CreateApiDestinationResponse::apiDestinationStateAsString))
            .setter(setter(Builder::apiDestinationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiDestinationState").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(CreateApiDestinationResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(CreateApiDestinationResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_DESTINATION_ARN_FIELD,
            API_DESTINATION_STATE_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD));

    private final String apiDestinationArn;

    private final String apiDestinationState;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private CreateApiDestinationResponse(BuilderImpl builder) {
        super(builder);
        this.apiDestinationArn = builder.apiDestinationArn;
        this.apiDestinationState = builder.apiDestinationState;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    /**
     * <p>
     * The ARN of the API destination that was created by the request.
     * </p>
     * 
     * @return The ARN of the API destination that was created by the request.
     */
    public final String apiDestinationArn() {
        return apiDestinationArn;
    }

    /**
     * <p>
     * The state of the API destination that was created by the request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #apiDestinationState} will return {@link ApiDestinationState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #apiDestinationStateAsString}.
     * </p>
     * 
     * @return The state of the API destination that was created by the request.
     * @see ApiDestinationState
     */
    public final ApiDestinationState apiDestinationState() {
        return ApiDestinationState.fromValue(apiDestinationState);
    }

    /**
     * <p>
     * The state of the API destination that was created by the request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #apiDestinationState} will return {@link ApiDestinationState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #apiDestinationStateAsString}.
     * </p>
     * 
     * @return The state of the API destination that was created by the request.
     * @see ApiDestinationState
     */
    public final String apiDestinationStateAsString() {
        return apiDestinationState;
    }

    /**
     * <p>
     * A time stamp indicating the time that the API destination was created.
     * </p>
     * 
     * @return A time stamp indicating the time that the API destination was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * A time stamp indicating the time that the API destination was last modified.
     * </p>
     * 
     * @return A time stamp indicating the time that the API destination was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(apiDestinationArn());
        hashCode = 31 * hashCode + Objects.hashCode(apiDestinationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApiDestinationResponse)) {
            return false;
        }
        CreateApiDestinationResponse other = (CreateApiDestinationResponse) obj;
        return Objects.equals(apiDestinationArn(), other.apiDestinationArn())
                && Objects.equals(apiDestinationStateAsString(), other.apiDestinationStateAsString())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateApiDestinationResponse").add("ApiDestinationArn", apiDestinationArn())
                .add("ApiDestinationState", apiDestinationStateAsString()).add("CreationTime", creationTime())
                .add("LastModifiedTime", lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApiDestinationArn":
            return Optional.ofNullable(clazz.cast(apiDestinationArn()));
        case "ApiDestinationState":
            return Optional.ofNullable(clazz.cast(apiDestinationStateAsString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateApiDestinationResponse, T> g) {
        return obj -> g.apply((CreateApiDestinationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchEventsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateApiDestinationResponse> {
        /**
         * <p>
         * The ARN of the API destination that was created by the request.
         * </p>
         * 
         * @param apiDestinationArn
         *        The ARN of the API destination that was created by the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiDestinationArn(String apiDestinationArn);

        /**
         * <p>
         * The state of the API destination that was created by the request.
         * </p>
         * 
         * @param apiDestinationState
         *        The state of the API destination that was created by the request.
         * @see ApiDestinationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApiDestinationState
         */
        Builder apiDestinationState(String apiDestinationState);

        /**
         * <p>
         * The state of the API destination that was created by the request.
         * </p>
         * 
         * @param apiDestinationState
         *        The state of the API destination that was created by the request.
         * @see ApiDestinationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApiDestinationState
         */
        Builder apiDestinationState(ApiDestinationState apiDestinationState);

        /**
         * <p>
         * A time stamp indicating the time that the API destination was created.
         * </p>
         * 
         * @param creationTime
         *        A time stamp indicating the time that the API destination was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * A time stamp indicating the time that the API destination was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        A time stamp indicating the time that the API destination was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);
    }

    static final class BuilderImpl extends CloudWatchEventsResponse.BuilderImpl implements Builder {
        private String apiDestinationArn;

        private String apiDestinationState;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApiDestinationResponse model) {
            super(model);
            apiDestinationArn(model.apiDestinationArn);
            apiDestinationState(model.apiDestinationState);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
        }

        public final String getApiDestinationArn() {
            return apiDestinationArn;
        }

        @Override
        public final Builder apiDestinationArn(String apiDestinationArn) {
            this.apiDestinationArn = apiDestinationArn;
            return this;
        }

        public final void setApiDestinationArn(String apiDestinationArn) {
            this.apiDestinationArn = apiDestinationArn;
        }

        public final String getApiDestinationState() {
            return apiDestinationState;
        }

        @Override
        public final Builder apiDestinationState(String apiDestinationState) {
            this.apiDestinationState = apiDestinationState;
            return this;
        }

        @Override
        public final Builder apiDestinationState(ApiDestinationState apiDestinationState) {
            this.apiDestinationState(apiDestinationState == null ? null : apiDestinationState.toString());
            return this;
        }

        public final void setApiDestinationState(String apiDestinationState) {
            this.apiDestinationState = apiDestinationState;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public CreateApiDestinationResponse build() {
            return new CreateApiDestinationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
