/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchevents.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This object enables you to specify a JSON path to extract from the event and use as the partition key for the Amazon
 * Kinesis data stream, so that you can control the shard to which the event goes. If you do not include this parameter,
 * the default is to use the <code>eventId</code> as the partition key.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KinesisParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<KinesisParameters.Builder, KinesisParameters> {
    private static final SdkField<String> PARTITION_KEY_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PartitionKeyPath").getter(getter(KinesisParameters::partitionKeyPath))
            .setter(setter(Builder::partitionKeyPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionKeyPath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTITION_KEY_PATH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String partitionKeyPath;

    private KinesisParameters(BuilderImpl builder) {
        this.partitionKeyPath = builder.partitionKeyPath;
    }

    /**
     * <p>
     * The JSON path to be extracted from the event and used as the partition key. For more information, see <a
     * href="https://docs.aws.amazon.com/streams/latest/dev/key-concepts.html#partition-key">Amazon Kinesis Streams Key
     * Concepts</a> in the <i>Amazon Kinesis Streams Developer Guide</i>.
     * </p>
     * 
     * @return The JSON path to be extracted from the event and used as the partition key. For more information, see <a
     *         href="https://docs.aws.amazon.com/streams/latest/dev/key-concepts.html#partition-key">Amazon Kinesis
     *         Streams Key Concepts</a> in the <i>Amazon Kinesis Streams Developer Guide</i>.
     */
    public final String partitionKeyPath() {
        return partitionKeyPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(partitionKeyPath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisParameters)) {
            return false;
        }
        KinesisParameters other = (KinesisParameters) obj;
        return Objects.equals(partitionKeyPath(), other.partitionKeyPath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KinesisParameters").add("PartitionKeyPath", partitionKeyPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PartitionKeyPath":
            return Optional.ofNullable(clazz.cast(partitionKeyPath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KinesisParameters, T> g) {
        return obj -> g.apply((KinesisParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KinesisParameters> {
        /**
         * <p>
         * The JSON path to be extracted from the event and used as the partition key. For more information, see <a
         * href="https://docs.aws.amazon.com/streams/latest/dev/key-concepts.html#partition-key">Amazon Kinesis Streams
         * Key Concepts</a> in the <i>Amazon Kinesis Streams Developer Guide</i>.
         * </p>
         * 
         * @param partitionKeyPath
         *        The JSON path to be extracted from the event and used as the partition key. For more information, see
         *        <a href="https://docs.aws.amazon.com/streams/latest/dev/key-concepts.html#partition-key">Amazon
         *        Kinesis Streams Key Concepts</a> in the <i>Amazon Kinesis Streams Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionKeyPath(String partitionKeyPath);
    }

    static final class BuilderImpl implements Builder {
        private String partitionKeyPath;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisParameters model) {
            partitionKeyPath(model.partitionKeyPath);
        }

        public final String getPartitionKeyPath() {
            return partitionKeyPath;
        }

        public final void setPartitionKeyPath(String partitionKeyPath) {
            this.partitionKeyPath = partitionKeyPath;
        }

        @Override
        @Transient
        public final Builder partitionKeyPath(String partitionKeyPath) {
            this.partitionKeyPath = partitionKeyPath;
            return this;
        }

        @Override
        public KinesisParameters build() {
            return new KinesisParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
