/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchevents.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A <code>RetryPolicy</code> object that includes information about the retry policy settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetryPolicy implements SdkPojo, Serializable, ToCopyableBuilder<RetryPolicy.Builder, RetryPolicy> {
    private static final SdkField<Integer> MAXIMUM_RETRY_ATTEMPTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaximumRetryAttempts").getter(getter(RetryPolicy::maximumRetryAttempts))
            .setter(setter(Builder::maximumRetryAttempts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumRetryAttempts").build())
            .build();

    private static final SdkField<Integer> MAXIMUM_EVENT_AGE_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("MaximumEventAgeInSeconds")
            .getter(getter(RetryPolicy::maximumEventAgeInSeconds)).setter(setter(Builder::maximumEventAgeInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumEventAgeInSeconds").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAXIMUM_RETRY_ATTEMPTS_FIELD,
            MAXIMUM_EVENT_AGE_IN_SECONDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer maximumRetryAttempts;

    private final Integer maximumEventAgeInSeconds;

    private RetryPolicy(BuilderImpl builder) {
        this.maximumRetryAttempts = builder.maximumRetryAttempts;
        this.maximumEventAgeInSeconds = builder.maximumEventAgeInSeconds;
    }

    /**
     * <p>
     * The maximum number of retry attempts to make before the request fails. Retry attempts continue until either the
     * maximum number of attempts is made or until the duration of the <code>MaximumEventAgeInSeconds</code> is met.
     * </p>
     * 
     * @return The maximum number of retry attempts to make before the request fails. Retry attempts continue until
     *         either the maximum number of attempts is made or until the duration of the
     *         <code>MaximumEventAgeInSeconds</code> is met.
     */
    public final Integer maximumRetryAttempts() {
        return maximumRetryAttempts;
    }

    /**
     * <p>
     * The maximum amount of time, in seconds, to continue to make retry attempts.
     * </p>
     * 
     * @return The maximum amount of time, in seconds, to continue to make retry attempts.
     */
    public final Integer maximumEventAgeInSeconds() {
        return maximumEventAgeInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maximumRetryAttempts());
        hashCode = 31 * hashCode + Objects.hashCode(maximumEventAgeInSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetryPolicy)) {
            return false;
        }
        RetryPolicy other = (RetryPolicy) obj;
        return Objects.equals(maximumRetryAttempts(), other.maximumRetryAttempts())
                && Objects.equals(maximumEventAgeInSeconds(), other.maximumEventAgeInSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RetryPolicy").add("MaximumRetryAttempts", maximumRetryAttempts())
                .add("MaximumEventAgeInSeconds", maximumEventAgeInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaximumRetryAttempts":
            return Optional.ofNullable(clazz.cast(maximumRetryAttempts()));
        case "MaximumEventAgeInSeconds":
            return Optional.ofNullable(clazz.cast(maximumEventAgeInSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RetryPolicy, T> g) {
        return obj -> g.apply((RetryPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RetryPolicy> {
        /**
         * <p>
         * The maximum number of retry attempts to make before the request fails. Retry attempts continue until either
         * the maximum number of attempts is made or until the duration of the <code>MaximumEventAgeInSeconds</code> is
         * met.
         * </p>
         * 
         * @param maximumRetryAttempts
         *        The maximum number of retry attempts to make before the request fails. Retry attempts continue until
         *        either the maximum number of attempts is made or until the duration of the
         *        <code>MaximumEventAgeInSeconds</code> is met.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumRetryAttempts(Integer maximumRetryAttempts);

        /**
         * <p>
         * The maximum amount of time, in seconds, to continue to make retry attempts.
         * </p>
         * 
         * @param maximumEventAgeInSeconds
         *        The maximum amount of time, in seconds, to continue to make retry attempts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumEventAgeInSeconds(Integer maximumEventAgeInSeconds);
    }

    static final class BuilderImpl implements Builder {
        private Integer maximumRetryAttempts;

        private Integer maximumEventAgeInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(RetryPolicy model) {
            maximumRetryAttempts(model.maximumRetryAttempts);
            maximumEventAgeInSeconds(model.maximumEventAgeInSeconds);
        }

        public final Integer getMaximumRetryAttempts() {
            return maximumRetryAttempts;
        }

        public final void setMaximumRetryAttempts(Integer maximumRetryAttempts) {
            this.maximumRetryAttempts = maximumRetryAttempts;
        }

        @Override
        @Transient
        public final Builder maximumRetryAttempts(Integer maximumRetryAttempts) {
            this.maximumRetryAttempts = maximumRetryAttempts;
            return this;
        }

        public final Integer getMaximumEventAgeInSeconds() {
            return maximumEventAgeInSeconds;
        }

        public final void setMaximumEventAgeInSeconds(Integer maximumEventAgeInSeconds) {
            this.maximumEventAgeInSeconds = maximumEventAgeInSeconds;
        }

        @Override
        @Transient
        public final Builder maximumEventAgeInSeconds(Integer maximumEventAgeInSeconds) {
            this.maximumEventAgeInSeconds = maximumEventAgeInSeconds;
            return this;
        }

        @Override
        public RetryPolicy build() {
            return new RetryPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
