/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchevents.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains additional parameters for the connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectionHttpParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectionHttpParameters.Builder, ConnectionHttpParameters> {
    private static final SdkField<List<ConnectionHeaderParameter>> HEADER_PARAMETERS_FIELD = SdkField
            .<List<ConnectionHeaderParameter>> builder(MarshallingType.LIST)
            .memberName("HeaderParameters")
            .getter(getter(ConnectionHttpParameters::headerParameters))
            .setter(setter(Builder::headerParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeaderParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConnectionHeaderParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConnectionHeaderParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ConnectionQueryStringParameter>> QUERY_STRING_PARAMETERS_FIELD = SdkField
            .<List<ConnectionQueryStringParameter>> builder(MarshallingType.LIST)
            .memberName("QueryStringParameters")
            .getter(getter(ConnectionHttpParameters::queryStringParameters))
            .setter(setter(Builder::queryStringParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryStringParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConnectionQueryStringParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConnectionQueryStringParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ConnectionBodyParameter>> BODY_PARAMETERS_FIELD = SdkField
            .<List<ConnectionBodyParameter>> builder(MarshallingType.LIST)
            .memberName("BodyParameters")
            .getter(getter(ConnectionHttpParameters::bodyParameters))
            .setter(setter(Builder::bodyParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BodyParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConnectionBodyParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConnectionBodyParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEADER_PARAMETERS_FIELD,
            QUERY_STRING_PARAMETERS_FIELD, BODY_PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ConnectionHeaderParameter> headerParameters;

    private final List<ConnectionQueryStringParameter> queryStringParameters;

    private final List<ConnectionBodyParameter> bodyParameters;

    private ConnectionHttpParameters(BuilderImpl builder) {
        this.headerParameters = builder.headerParameters;
        this.queryStringParameters = builder.queryStringParameters;
        this.bodyParameters = builder.bodyParameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the HeaderParameters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHeaderParameters() {
        return headerParameters != null && !(headerParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains additional header parameters for the connection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHeaderParameters} method.
     * </p>
     * 
     * @return Contains additional header parameters for the connection.
     */
    public final List<ConnectionHeaderParameter> headerParameters() {
        return headerParameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the QueryStringParameters property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasQueryStringParameters() {
        return queryStringParameters != null && !(queryStringParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains additional query string parameters for the connection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQueryStringParameters} method.
     * </p>
     * 
     * @return Contains additional query string parameters for the connection.
     */
    public final List<ConnectionQueryStringParameter> queryStringParameters() {
        return queryStringParameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the BodyParameters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBodyParameters() {
        return bodyParameters != null && !(bodyParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains additional body string parameters for the connection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBodyParameters} method.
     * </p>
     * 
     * @return Contains additional body string parameters for the connection.
     */
    public final List<ConnectionBodyParameter> bodyParameters() {
        return bodyParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasHeaderParameters() ? headerParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasQueryStringParameters() ? queryStringParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBodyParameters() ? bodyParameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionHttpParameters)) {
            return false;
        }
        ConnectionHttpParameters other = (ConnectionHttpParameters) obj;
        return hasHeaderParameters() == other.hasHeaderParameters()
                && Objects.equals(headerParameters(), other.headerParameters())
                && hasQueryStringParameters() == other.hasQueryStringParameters()
                && Objects.equals(queryStringParameters(), other.queryStringParameters())
                && hasBodyParameters() == other.hasBodyParameters() && Objects.equals(bodyParameters(), other.bodyParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectionHttpParameters")
                .add("HeaderParameters", hasHeaderParameters() ? headerParameters() : null)
                .add("QueryStringParameters", hasQueryStringParameters() ? queryStringParameters() : null)
                .add("BodyParameters", hasBodyParameters() ? bodyParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HeaderParameters":
            return Optional.ofNullable(clazz.cast(headerParameters()));
        case "QueryStringParameters":
            return Optional.ofNullable(clazz.cast(queryStringParameters()));
        case "BodyParameters":
            return Optional.ofNullable(clazz.cast(bodyParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectionHttpParameters, T> g) {
        return obj -> g.apply((ConnectionHttpParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectionHttpParameters> {
        /**
         * <p>
         * Contains additional header parameters for the connection.
         * </p>
         * 
         * @param headerParameters
         *        Contains additional header parameters for the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headerParameters(Collection<ConnectionHeaderParameter> headerParameters);

        /**
         * <p>
         * Contains additional header parameters for the connection.
         * </p>
         * 
         * @param headerParameters
         *        Contains additional header parameters for the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headerParameters(ConnectionHeaderParameter... headerParameters);

        /**
         * <p>
         * Contains additional header parameters for the connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ConnectionHeaderParameter>.Builder}
         * avoiding the need to create one manually via {@link List<ConnectionHeaderParameter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConnectionHeaderParameter>.Builder#build()} is called
         * immediately and its result is passed to {@link #headerParameters(List<ConnectionHeaderParameter>)}.
         * 
         * @param headerParameters
         *        a consumer that will call methods on {@link List<ConnectionHeaderParameter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #headerParameters(List<ConnectionHeaderParameter>)
         */
        Builder headerParameters(Consumer<ConnectionHeaderParameter.Builder>... headerParameters);

        /**
         * <p>
         * Contains additional query string parameters for the connection.
         * </p>
         * 
         * @param queryStringParameters
         *        Contains additional query string parameters for the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryStringParameters(Collection<ConnectionQueryStringParameter> queryStringParameters);

        /**
         * <p>
         * Contains additional query string parameters for the connection.
         * </p>
         * 
         * @param queryStringParameters
         *        Contains additional query string parameters for the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryStringParameters(ConnectionQueryStringParameter... queryStringParameters);

        /**
         * <p>
         * Contains additional query string parameters for the connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <ConnectionQueryStringParameter>.Builder} avoiding the need to create one manually via {@link List
         * <ConnectionQueryStringParameter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConnectionQueryStringParameter>.Builder#build()} is called
         * immediately and its result is passed to {@link #queryStringParameters(List<ConnectionQueryStringParameter>)}.
         * 
         * @param queryStringParameters
         *        a consumer that will call methods on {@link List<ConnectionQueryStringParameter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryStringParameters(List<ConnectionQueryStringParameter>)
         */
        Builder queryStringParameters(Consumer<ConnectionQueryStringParameter.Builder>... queryStringParameters);

        /**
         * <p>
         * Contains additional body string parameters for the connection.
         * </p>
         * 
         * @param bodyParameters
         *        Contains additional body string parameters for the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bodyParameters(Collection<ConnectionBodyParameter> bodyParameters);

        /**
         * <p>
         * Contains additional body string parameters for the connection.
         * </p>
         * 
         * @param bodyParameters
         *        Contains additional body string parameters for the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bodyParameters(ConnectionBodyParameter... bodyParameters);

        /**
         * <p>
         * Contains additional body string parameters for the connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ConnectionBodyParameter>.Builder}
         * avoiding the need to create one manually via {@link List<ConnectionBodyParameter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConnectionBodyParameter>.Builder#build()} is called
         * immediately and its result is passed to {@link #bodyParameters(List<ConnectionBodyParameter>)}.
         * 
         * @param bodyParameters
         *        a consumer that will call methods on {@link List<ConnectionBodyParameter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bodyParameters(List<ConnectionBodyParameter>)
         */
        Builder bodyParameters(Consumer<ConnectionBodyParameter.Builder>... bodyParameters);
    }

    static final class BuilderImpl implements Builder {
        private List<ConnectionHeaderParameter> headerParameters = DefaultSdkAutoConstructList.getInstance();

        private List<ConnectionQueryStringParameter> queryStringParameters = DefaultSdkAutoConstructList.getInstance();

        private List<ConnectionBodyParameter> bodyParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionHttpParameters model) {
            headerParameters(model.headerParameters);
            queryStringParameters(model.queryStringParameters);
            bodyParameters(model.bodyParameters);
        }

        public final List<ConnectionHeaderParameter.Builder> getHeaderParameters() {
            List<ConnectionHeaderParameter.Builder> result = ConnectionHeaderParametersListCopier
                    .copyToBuilder(this.headerParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHeaderParameters(Collection<ConnectionHeaderParameter.BuilderImpl> headerParameters) {
            this.headerParameters = ConnectionHeaderParametersListCopier.copyFromBuilder(headerParameters);
        }

        @Override
        @Transient
        public final Builder headerParameters(Collection<ConnectionHeaderParameter> headerParameters) {
            this.headerParameters = ConnectionHeaderParametersListCopier.copy(headerParameters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder headerParameters(ConnectionHeaderParameter... headerParameters) {
            headerParameters(Arrays.asList(headerParameters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder headerParameters(Consumer<ConnectionHeaderParameter.Builder>... headerParameters) {
            headerParameters(Stream.of(headerParameters).map(c -> ConnectionHeaderParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ConnectionQueryStringParameter.Builder> getQueryStringParameters() {
            List<ConnectionQueryStringParameter.Builder> result = ConnectionQueryStringParametersListCopier
                    .copyToBuilder(this.queryStringParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQueryStringParameters(Collection<ConnectionQueryStringParameter.BuilderImpl> queryStringParameters) {
            this.queryStringParameters = ConnectionQueryStringParametersListCopier.copyFromBuilder(queryStringParameters);
        }

        @Override
        @Transient
        public final Builder queryStringParameters(Collection<ConnectionQueryStringParameter> queryStringParameters) {
            this.queryStringParameters = ConnectionQueryStringParametersListCopier.copy(queryStringParameters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder queryStringParameters(ConnectionQueryStringParameter... queryStringParameters) {
            queryStringParameters(Arrays.asList(queryStringParameters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder queryStringParameters(Consumer<ConnectionQueryStringParameter.Builder>... queryStringParameters) {
            queryStringParameters(Stream.of(queryStringParameters)
                    .map(c -> ConnectionQueryStringParameter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ConnectionBodyParameter.Builder> getBodyParameters() {
            List<ConnectionBodyParameter.Builder> result = ConnectionBodyParametersListCopier.copyToBuilder(this.bodyParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBodyParameters(Collection<ConnectionBodyParameter.BuilderImpl> bodyParameters) {
            this.bodyParameters = ConnectionBodyParametersListCopier.copyFromBuilder(bodyParameters);
        }

        @Override
        @Transient
        public final Builder bodyParameters(Collection<ConnectionBodyParameter> bodyParameters) {
            this.bodyParameters = ConnectionBodyParametersListCopier.copy(bodyParameters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder bodyParameters(ConnectionBodyParameter... bodyParameters) {
            bodyParameters(Arrays.asList(bodyParameters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder bodyParameters(Consumer<ConnectionBodyParameter.Builder>... bodyParameters) {
            bodyParameters(Stream.of(bodyParameters).map(c -> ConnectionBodyParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ConnectionHttpParameters build() {
            return new ConnectionHttpParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
