/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchevents.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response parameters when OAuth is specified as the authorization type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectionOAuthResponseParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectionOAuthResponseParameters.Builder, ConnectionOAuthResponseParameters> {
    private static final SdkField<ConnectionOAuthClientResponseParameters> CLIENT_PARAMETERS_FIELD = SdkField
            .<ConnectionOAuthClientResponseParameters> builder(MarshallingType.SDK_POJO).memberName("ClientParameters")
            .getter(getter(ConnectionOAuthResponseParameters::clientParameters)).setter(setter(Builder::clientParameters))
            .constructor(ConnectionOAuthClientResponseParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientParameters").build()).build();

    private static final SdkField<String> AUTHORIZATION_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthorizationEndpoint").getter(getter(ConnectionOAuthResponseParameters::authorizationEndpoint))
            .setter(setter(Builder::authorizationEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizationEndpoint").build())
            .build();

    private static final SdkField<String> HTTP_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HttpMethod").getter(getter(ConnectionOAuthResponseParameters::httpMethodAsString))
            .setter(setter(Builder::httpMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpMethod").build()).build();

    private static final SdkField<ConnectionHttpParameters> O_AUTH_HTTP_PARAMETERS_FIELD = SdkField
            .<ConnectionHttpParameters> builder(MarshallingType.SDK_POJO).memberName("OAuthHttpParameters")
            .getter(getter(ConnectionOAuthResponseParameters::oAuthHttpParameters)).setter(setter(Builder::oAuthHttpParameters))
            .constructor(ConnectionHttpParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OAuthHttpParameters").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_PARAMETERS_FIELD,
            AUTHORIZATION_ENDPOINT_FIELD, HTTP_METHOD_FIELD, O_AUTH_HTTP_PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final ConnectionOAuthClientResponseParameters clientParameters;

    private final String authorizationEndpoint;

    private final String httpMethod;

    private final ConnectionHttpParameters oAuthHttpParameters;

    private ConnectionOAuthResponseParameters(BuilderImpl builder) {
        this.clientParameters = builder.clientParameters;
        this.authorizationEndpoint = builder.authorizationEndpoint;
        this.httpMethod = builder.httpMethod;
        this.oAuthHttpParameters = builder.oAuthHttpParameters;
    }

    /**
     * <p>
     * A <code>ConnectionOAuthClientResponseParameters</code> object that contains details about the client parameters
     * returned when OAuth is specified as the authorization type.
     * </p>
     * 
     * @return A <code>ConnectionOAuthClientResponseParameters</code> object that contains details about the client
     *         parameters returned when OAuth is specified as the authorization type.
     */
    public final ConnectionOAuthClientResponseParameters clientParameters() {
        return clientParameters;
    }

    /**
     * <p>
     * The URL to the HTTP endpoint that authorized the request.
     * </p>
     * 
     * @return The URL to the HTTP endpoint that authorized the request.
     */
    public final String authorizationEndpoint() {
        return authorizationEndpoint;
    }

    /**
     * <p>
     * The method used to connect to the HTTP endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #httpMethod} will
     * return {@link ConnectionOAuthHttpMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #httpMethodAsString}.
     * </p>
     * 
     * @return The method used to connect to the HTTP endpoint.
     * @see ConnectionOAuthHttpMethod
     */
    public final ConnectionOAuthHttpMethod httpMethod() {
        return ConnectionOAuthHttpMethod.fromValue(httpMethod);
    }

    /**
     * <p>
     * The method used to connect to the HTTP endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #httpMethod} will
     * return {@link ConnectionOAuthHttpMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #httpMethodAsString}.
     * </p>
     * 
     * @return The method used to connect to the HTTP endpoint.
     * @see ConnectionOAuthHttpMethod
     */
    public final String httpMethodAsString() {
        return httpMethod;
    }

    /**
     * <p>
     * The additional HTTP parameters used for the OAuth authorization request.
     * </p>
     * 
     * @return The additional HTTP parameters used for the OAuth authorization request.
     */
    public final ConnectionHttpParameters oAuthHttpParameters() {
        return oAuthHttpParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientParameters());
        hashCode = 31 * hashCode + Objects.hashCode(authorizationEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(httpMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(oAuthHttpParameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionOAuthResponseParameters)) {
            return false;
        }
        ConnectionOAuthResponseParameters other = (ConnectionOAuthResponseParameters) obj;
        return Objects.equals(clientParameters(), other.clientParameters())
                && Objects.equals(authorizationEndpoint(), other.authorizationEndpoint())
                && Objects.equals(httpMethodAsString(), other.httpMethodAsString())
                && Objects.equals(oAuthHttpParameters(), other.oAuthHttpParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectionOAuthResponseParameters").add("ClientParameters", clientParameters())
                .add("AuthorizationEndpoint", authorizationEndpoint()).add("HttpMethod", httpMethodAsString())
                .add("OAuthHttpParameters", oAuthHttpParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientParameters":
            return Optional.ofNullable(clazz.cast(clientParameters()));
        case "AuthorizationEndpoint":
            return Optional.ofNullable(clazz.cast(authorizationEndpoint()));
        case "HttpMethod":
            return Optional.ofNullable(clazz.cast(httpMethodAsString()));
        case "OAuthHttpParameters":
            return Optional.ofNullable(clazz.cast(oAuthHttpParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectionOAuthResponseParameters, T> g) {
        return obj -> g.apply((ConnectionOAuthResponseParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectionOAuthResponseParameters> {
        /**
         * <p>
         * A <code>ConnectionOAuthClientResponseParameters</code> object that contains details about the client
         * parameters returned when OAuth is specified as the authorization type.
         * </p>
         * 
         * @param clientParameters
         *        A <code>ConnectionOAuthClientResponseParameters</code> object that contains details about the client
         *        parameters returned when OAuth is specified as the authorization type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientParameters(ConnectionOAuthClientResponseParameters clientParameters);

        /**
         * <p>
         * A <code>ConnectionOAuthClientResponseParameters</code> object that contains details about the client
         * parameters returned when OAuth is specified as the authorization type.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ConnectionOAuthClientResponseParameters.Builder} avoiding the need to create one manually via
         * {@link ConnectionOAuthClientResponseParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConnectionOAuthClientResponseParameters.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #clientParameters(ConnectionOAuthClientResponseParameters)}.
         * 
         * @param clientParameters
         *        a consumer that will call methods on {@link ConnectionOAuthClientResponseParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clientParameters(ConnectionOAuthClientResponseParameters)
         */
        default Builder clientParameters(Consumer<ConnectionOAuthClientResponseParameters.Builder> clientParameters) {
            return clientParameters(ConnectionOAuthClientResponseParameters.builder().applyMutation(clientParameters).build());
        }

        /**
         * <p>
         * The URL to the HTTP endpoint that authorized the request.
         * </p>
         * 
         * @param authorizationEndpoint
         *        The URL to the HTTP endpoint that authorized the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizationEndpoint(String authorizationEndpoint);

        /**
         * <p>
         * The method used to connect to the HTTP endpoint.
         * </p>
         * 
         * @param httpMethod
         *        The method used to connect to the HTTP endpoint.
         * @see ConnectionOAuthHttpMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionOAuthHttpMethod
         */
        Builder httpMethod(String httpMethod);

        /**
         * <p>
         * The method used to connect to the HTTP endpoint.
         * </p>
         * 
         * @param httpMethod
         *        The method used to connect to the HTTP endpoint.
         * @see ConnectionOAuthHttpMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionOAuthHttpMethod
         */
        Builder httpMethod(ConnectionOAuthHttpMethod httpMethod);

        /**
         * <p>
         * The additional HTTP parameters used for the OAuth authorization request.
         * </p>
         * 
         * @param oAuthHttpParameters
         *        The additional HTTP parameters used for the OAuth authorization request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oAuthHttpParameters(ConnectionHttpParameters oAuthHttpParameters);

        /**
         * <p>
         * The additional HTTP parameters used for the OAuth authorization request.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConnectionHttpParameters.Builder}
         * avoiding the need to create one manually via {@link ConnectionHttpParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConnectionHttpParameters.Builder#build()} is called immediately
         * and its result is passed to {@link #oAuthHttpParameters(ConnectionHttpParameters)}.
         * 
         * @param oAuthHttpParameters
         *        a consumer that will call methods on {@link ConnectionHttpParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oAuthHttpParameters(ConnectionHttpParameters)
         */
        default Builder oAuthHttpParameters(Consumer<ConnectionHttpParameters.Builder> oAuthHttpParameters) {
            return oAuthHttpParameters(ConnectionHttpParameters.builder().applyMutation(oAuthHttpParameters).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ConnectionOAuthClientResponseParameters clientParameters;

        private String authorizationEndpoint;

        private String httpMethod;

        private ConnectionHttpParameters oAuthHttpParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionOAuthResponseParameters model) {
            clientParameters(model.clientParameters);
            authorizationEndpoint(model.authorizationEndpoint);
            httpMethod(model.httpMethod);
            oAuthHttpParameters(model.oAuthHttpParameters);
        }

        public final ConnectionOAuthClientResponseParameters.Builder getClientParameters() {
            return clientParameters != null ? clientParameters.toBuilder() : null;
        }

        public final void setClientParameters(ConnectionOAuthClientResponseParameters.BuilderImpl clientParameters) {
            this.clientParameters = clientParameters != null ? clientParameters.build() : null;
        }

        @Override
        @Transient
        public final Builder clientParameters(ConnectionOAuthClientResponseParameters clientParameters) {
            this.clientParameters = clientParameters;
            return this;
        }

        public final String getAuthorizationEndpoint() {
            return authorizationEndpoint;
        }

        public final void setAuthorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
        }

        @Override
        @Transient
        public final Builder authorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
            return this;
        }

        public final String getHttpMethod() {
            return httpMethod;
        }

        public final void setHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
        }

        @Override
        @Transient
        public final Builder httpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        @Override
        @Transient
        public final Builder httpMethod(ConnectionOAuthHttpMethod httpMethod) {
            this.httpMethod(httpMethod == null ? null : httpMethod.toString());
            return this;
        }

        public final ConnectionHttpParameters.Builder getOAuthHttpParameters() {
            return oAuthHttpParameters != null ? oAuthHttpParameters.toBuilder() : null;
        }

        public final void setOAuthHttpParameters(ConnectionHttpParameters.BuilderImpl oAuthHttpParameters) {
            this.oAuthHttpParameters = oAuthHttpParameters != null ? oAuthHttpParameters.build() : null;
        }

        @Override
        @Transient
        public final Builder oAuthHttpParameters(ConnectionHttpParameters oAuthHttpParameters) {
            this.oAuthHttpParameters = oAuthHttpParameters;
            return this;
        }

        @Override
        public ConnectionOAuthResponseParameters build() {
            return new ConnectionOAuthResponseParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
