/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the additional parameters to use for the connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateConnectionAuthRequestParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateConnectionAuthRequestParameters.Builder, UpdateConnectionAuthRequestParameters> {
    private static final SdkField<UpdateConnectionBasicAuthRequestParameters> BASIC_AUTH_PARAMETERS_FIELD = SdkField
            .<UpdateConnectionBasicAuthRequestParameters> builder(MarshallingType.SDK_POJO).memberName("BasicAuthParameters")
            .getter(getter(UpdateConnectionAuthRequestParameters::basicAuthParameters))
            .setter(setter(Builder::basicAuthParameters)).constructor(UpdateConnectionBasicAuthRequestParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BasicAuthParameters").build())
            .build();

    private static final SdkField<UpdateConnectionOAuthRequestParameters> O_AUTH_PARAMETERS_FIELD = SdkField
            .<UpdateConnectionOAuthRequestParameters> builder(MarshallingType.SDK_POJO).memberName("OAuthParameters")
            .getter(getter(UpdateConnectionAuthRequestParameters::oAuthParameters)).setter(setter(Builder::oAuthParameters))
            .constructor(UpdateConnectionOAuthRequestParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OAuthParameters").build()).build();

    private static final SdkField<UpdateConnectionApiKeyAuthRequestParameters> API_KEY_AUTH_PARAMETERS_FIELD = SdkField
            .<UpdateConnectionApiKeyAuthRequestParameters> builder(MarshallingType.SDK_POJO).memberName("ApiKeyAuthParameters")
            .getter(getter(UpdateConnectionAuthRequestParameters::apiKeyAuthParameters))
            .setter(setter(Builder::apiKeyAuthParameters)).constructor(UpdateConnectionApiKeyAuthRequestParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiKeyAuthParameters").build())
            .build();

    private static final SdkField<ConnectionHttpParameters> INVOCATION_HTTP_PARAMETERS_FIELD = SdkField
            .<ConnectionHttpParameters> builder(MarshallingType.SDK_POJO).memberName("InvocationHttpParameters")
            .getter(getter(UpdateConnectionAuthRequestParameters::invocationHttpParameters))
            .setter(setter(Builder::invocationHttpParameters)).constructor(ConnectionHttpParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationHttpParameters").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASIC_AUTH_PARAMETERS_FIELD,
            O_AUTH_PARAMETERS_FIELD, API_KEY_AUTH_PARAMETERS_FIELD, INVOCATION_HTTP_PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final UpdateConnectionBasicAuthRequestParameters basicAuthParameters;

    private final UpdateConnectionOAuthRequestParameters oAuthParameters;

    private final UpdateConnectionApiKeyAuthRequestParameters apiKeyAuthParameters;

    private final ConnectionHttpParameters invocationHttpParameters;

    private UpdateConnectionAuthRequestParameters(BuilderImpl builder) {
        this.basicAuthParameters = builder.basicAuthParameters;
        this.oAuthParameters = builder.oAuthParameters;
        this.apiKeyAuthParameters = builder.apiKeyAuthParameters;
        this.invocationHttpParameters = builder.invocationHttpParameters;
    }

    /**
     * <p>
     * A <code>UpdateConnectionBasicAuthRequestParameters</code> object that contains the authorization parameters for
     * Basic authorization.
     * </p>
     * 
     * @return A <code>UpdateConnectionBasicAuthRequestParameters</code> object that contains the authorization
     *         parameters for Basic authorization.
     */
    public final UpdateConnectionBasicAuthRequestParameters basicAuthParameters() {
        return basicAuthParameters;
    }

    /**
     * <p>
     * A <code>UpdateConnectionOAuthRequestParameters</code> object that contains the authorization parameters for OAuth
     * authorization.
     * </p>
     * 
     * @return A <code>UpdateConnectionOAuthRequestParameters</code> object that contains the authorization parameters
     *         for OAuth authorization.
     */
    public final UpdateConnectionOAuthRequestParameters oAuthParameters() {
        return oAuthParameters;
    }

    /**
     * <p>
     * A <code>UpdateConnectionApiKeyAuthRequestParameters</code> object that contains the authorization parameters for
     * API key authorization.
     * </p>
     * 
     * @return A <code>UpdateConnectionApiKeyAuthRequestParameters</code> object that contains the authorization
     *         parameters for API key authorization.
     */
    public final UpdateConnectionApiKeyAuthRequestParameters apiKeyAuthParameters() {
        return apiKeyAuthParameters;
    }

    /**
     * <p>
     * A <code>ConnectionHttpParameters</code> object that contains the additional parameters to use for the connection.
     * </p>
     * 
     * @return A <code>ConnectionHttpParameters</code> object that contains the additional parameters to use for the
     *         connection.
     */
    public final ConnectionHttpParameters invocationHttpParameters() {
        return invocationHttpParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(basicAuthParameters());
        hashCode = 31 * hashCode + Objects.hashCode(oAuthParameters());
        hashCode = 31 * hashCode + Objects.hashCode(apiKeyAuthParameters());
        hashCode = 31 * hashCode + Objects.hashCode(invocationHttpParameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConnectionAuthRequestParameters)) {
            return false;
        }
        UpdateConnectionAuthRequestParameters other = (UpdateConnectionAuthRequestParameters) obj;
        return Objects.equals(basicAuthParameters(), other.basicAuthParameters())
                && Objects.equals(oAuthParameters(), other.oAuthParameters())
                && Objects.equals(apiKeyAuthParameters(), other.apiKeyAuthParameters())
                && Objects.equals(invocationHttpParameters(), other.invocationHttpParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateConnectionAuthRequestParameters").add("BasicAuthParameters", basicAuthParameters())
                .add("OAuthParameters", oAuthParameters()).add("ApiKeyAuthParameters", apiKeyAuthParameters())
                .add("InvocationHttpParameters", invocationHttpParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BasicAuthParameters":
            return Optional.ofNullable(clazz.cast(basicAuthParameters()));
        case "OAuthParameters":
            return Optional.ofNullable(clazz.cast(oAuthParameters()));
        case "ApiKeyAuthParameters":
            return Optional.ofNullable(clazz.cast(apiKeyAuthParameters()));
        case "InvocationHttpParameters":
            return Optional.ofNullable(clazz.cast(invocationHttpParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateConnectionAuthRequestParameters, T> g) {
        return obj -> g.apply((UpdateConnectionAuthRequestParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateConnectionAuthRequestParameters> {
        /**
         * <p>
         * A <code>UpdateConnectionBasicAuthRequestParameters</code> object that contains the authorization parameters
         * for Basic authorization.
         * </p>
         * 
         * @param basicAuthParameters
         *        A <code>UpdateConnectionBasicAuthRequestParameters</code> object that contains the authorization
         *        parameters for Basic authorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder basicAuthParameters(UpdateConnectionBasicAuthRequestParameters basicAuthParameters);

        /**
         * <p>
         * A <code>UpdateConnectionBasicAuthRequestParameters</code> object that contains the authorization parameters
         * for Basic authorization.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UpdateConnectionBasicAuthRequestParameters.Builder} avoiding the need to create one manually via
         * {@link UpdateConnectionBasicAuthRequestParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link UpdateConnectionBasicAuthRequestParameters.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #basicAuthParameters(UpdateConnectionBasicAuthRequestParameters)}.
         * 
         * @param basicAuthParameters
         *        a consumer that will call methods on {@link UpdateConnectionBasicAuthRequestParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #basicAuthParameters(UpdateConnectionBasicAuthRequestParameters)
         */
        default Builder basicAuthParameters(Consumer<UpdateConnectionBasicAuthRequestParameters.Builder> basicAuthParameters) {
            return basicAuthParameters(UpdateConnectionBasicAuthRequestParameters.builder().applyMutation(basicAuthParameters)
                    .build());
        }

        /**
         * <p>
         * A <code>UpdateConnectionOAuthRequestParameters</code> object that contains the authorization parameters for
         * OAuth authorization.
         * </p>
         * 
         * @param oAuthParameters
         *        A <code>UpdateConnectionOAuthRequestParameters</code> object that contains the authorization
         *        parameters for OAuth authorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oAuthParameters(UpdateConnectionOAuthRequestParameters oAuthParameters);

        /**
         * <p>
         * A <code>UpdateConnectionOAuthRequestParameters</code> object that contains the authorization parameters for
         * OAuth authorization.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UpdateConnectionOAuthRequestParameters.Builder} avoiding the need to create one manually via
         * {@link UpdateConnectionOAuthRequestParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link UpdateConnectionOAuthRequestParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #oAuthParameters(UpdateConnectionOAuthRequestParameters)}.
         * 
         * @param oAuthParameters
         *        a consumer that will call methods on {@link UpdateConnectionOAuthRequestParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oAuthParameters(UpdateConnectionOAuthRequestParameters)
         */
        default Builder oAuthParameters(Consumer<UpdateConnectionOAuthRequestParameters.Builder> oAuthParameters) {
            return oAuthParameters(UpdateConnectionOAuthRequestParameters.builder().applyMutation(oAuthParameters).build());
        }

        /**
         * <p>
         * A <code>UpdateConnectionApiKeyAuthRequestParameters</code> object that contains the authorization parameters
         * for API key authorization.
         * </p>
         * 
         * @param apiKeyAuthParameters
         *        A <code>UpdateConnectionApiKeyAuthRequestParameters</code> object that contains the authorization
         *        parameters for API key authorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiKeyAuthParameters(UpdateConnectionApiKeyAuthRequestParameters apiKeyAuthParameters);

        /**
         * <p>
         * A <code>UpdateConnectionApiKeyAuthRequestParameters</code> object that contains the authorization parameters
         * for API key authorization.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UpdateConnectionApiKeyAuthRequestParameters.Builder} avoiding the need to create one manually via
         * {@link UpdateConnectionApiKeyAuthRequestParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link UpdateConnectionApiKeyAuthRequestParameters.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #apiKeyAuthParameters(UpdateConnectionApiKeyAuthRequestParameters)}.
         * 
         * @param apiKeyAuthParameters
         *        a consumer that will call methods on {@link UpdateConnectionApiKeyAuthRequestParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #apiKeyAuthParameters(UpdateConnectionApiKeyAuthRequestParameters)
         */
        default Builder apiKeyAuthParameters(Consumer<UpdateConnectionApiKeyAuthRequestParameters.Builder> apiKeyAuthParameters) {
            return apiKeyAuthParameters(UpdateConnectionApiKeyAuthRequestParameters.builder().applyMutation(apiKeyAuthParameters)
                    .build());
        }

        /**
         * <p>
         * A <code>ConnectionHttpParameters</code> object that contains the additional parameters to use for the
         * connection.
         * </p>
         * 
         * @param invocationHttpParameters
         *        A <code>ConnectionHttpParameters</code> object that contains the additional parameters to use for the
         *        connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationHttpParameters(ConnectionHttpParameters invocationHttpParameters);

        /**
         * <p>
         * A <code>ConnectionHttpParameters</code> object that contains the additional parameters to use for the
         * connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConnectionHttpParameters.Builder}
         * avoiding the need to create one manually via {@link ConnectionHttpParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConnectionHttpParameters.Builder#build()} is called immediately
         * and its result is passed to {@link #invocationHttpParameters(ConnectionHttpParameters)}.
         * 
         * @param invocationHttpParameters
         *        a consumer that will call methods on {@link ConnectionHttpParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #invocationHttpParameters(ConnectionHttpParameters)
         */
        default Builder invocationHttpParameters(Consumer<ConnectionHttpParameters.Builder> invocationHttpParameters) {
            return invocationHttpParameters(ConnectionHttpParameters.builder().applyMutation(invocationHttpParameters).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private UpdateConnectionBasicAuthRequestParameters basicAuthParameters;

        private UpdateConnectionOAuthRequestParameters oAuthParameters;

        private UpdateConnectionApiKeyAuthRequestParameters apiKeyAuthParameters;

        private ConnectionHttpParameters invocationHttpParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConnectionAuthRequestParameters model) {
            basicAuthParameters(model.basicAuthParameters);
            oAuthParameters(model.oAuthParameters);
            apiKeyAuthParameters(model.apiKeyAuthParameters);
            invocationHttpParameters(model.invocationHttpParameters);
        }

        public final UpdateConnectionBasicAuthRequestParameters.Builder getBasicAuthParameters() {
            return basicAuthParameters != null ? basicAuthParameters.toBuilder() : null;
        }

        public final void setBasicAuthParameters(UpdateConnectionBasicAuthRequestParameters.BuilderImpl basicAuthParameters) {
            this.basicAuthParameters = basicAuthParameters != null ? basicAuthParameters.build() : null;
        }

        @Override
        public final Builder basicAuthParameters(UpdateConnectionBasicAuthRequestParameters basicAuthParameters) {
            this.basicAuthParameters = basicAuthParameters;
            return this;
        }

        public final UpdateConnectionOAuthRequestParameters.Builder getOAuthParameters() {
            return oAuthParameters != null ? oAuthParameters.toBuilder() : null;
        }

        public final void setOAuthParameters(UpdateConnectionOAuthRequestParameters.BuilderImpl oAuthParameters) {
            this.oAuthParameters = oAuthParameters != null ? oAuthParameters.build() : null;
        }

        @Override
        public final Builder oAuthParameters(UpdateConnectionOAuthRequestParameters oAuthParameters) {
            this.oAuthParameters = oAuthParameters;
            return this;
        }

        public final UpdateConnectionApiKeyAuthRequestParameters.Builder getApiKeyAuthParameters() {
            return apiKeyAuthParameters != null ? apiKeyAuthParameters.toBuilder() : null;
        }

        public final void setApiKeyAuthParameters(UpdateConnectionApiKeyAuthRequestParameters.BuilderImpl apiKeyAuthParameters) {
            this.apiKeyAuthParameters = apiKeyAuthParameters != null ? apiKeyAuthParameters.build() : null;
        }

        @Override
        public final Builder apiKeyAuthParameters(UpdateConnectionApiKeyAuthRequestParameters apiKeyAuthParameters) {
            this.apiKeyAuthParameters = apiKeyAuthParameters;
            return this;
        }

        public final ConnectionHttpParameters.Builder getInvocationHttpParameters() {
            return invocationHttpParameters != null ? invocationHttpParameters.toBuilder() : null;
        }

        public final void setInvocationHttpParameters(ConnectionHttpParameters.BuilderImpl invocationHttpParameters) {
            this.invocationHttpParameters = invocationHttpParameters != null ? invocationHttpParameters.build() : null;
        }

        @Override
        public final Builder invocationHttpParameters(ConnectionHttpParameters invocationHttpParameters) {
            this.invocationHttpParameters = invocationHttpParameters;
            return this;
        }

        @Override
        public UpdateConnectionAuthRequestParameters build() {
            return new UpdateConnectionAuthRequestParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
