/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the API key authorization parameters for the connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateConnectionApiKeyAuthRequestParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateConnectionApiKeyAuthRequestParameters.Builder, CreateConnectionApiKeyAuthRequestParameters> {
    private static final SdkField<String> API_KEY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApiKeyName").getter(getter(CreateConnectionApiKeyAuthRequestParameters::apiKeyName))
            .setter(setter(Builder::apiKeyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiKeyName").build()).build();

    private static final SdkField<String> API_KEY_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApiKeyValue").getter(getter(CreateConnectionApiKeyAuthRequestParameters::apiKeyValue))
            .setter(setter(Builder::apiKeyValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiKeyValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_KEY_NAME_FIELD,
            API_KEY_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String apiKeyName;

    private final String apiKeyValue;

    private CreateConnectionApiKeyAuthRequestParameters(BuilderImpl builder) {
        this.apiKeyName = builder.apiKeyName;
        this.apiKeyValue = builder.apiKeyValue;
    }

    /**
     * <p>
     * The name of the API key to use for authorization.
     * </p>
     * 
     * @return The name of the API key to use for authorization.
     */
    public final String apiKeyName() {
        return apiKeyName;
    }

    /**
     * <p>
     * The value for the API key to use for authorization.
     * </p>
     * 
     * @return The value for the API key to use for authorization.
     */
    public final String apiKeyValue() {
        return apiKeyValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(apiKeyName());
        hashCode = 31 * hashCode + Objects.hashCode(apiKeyValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConnectionApiKeyAuthRequestParameters)) {
            return false;
        }
        CreateConnectionApiKeyAuthRequestParameters other = (CreateConnectionApiKeyAuthRequestParameters) obj;
        return Objects.equals(apiKeyName(), other.apiKeyName()) && Objects.equals(apiKeyValue(), other.apiKeyValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateConnectionApiKeyAuthRequestParameters").add("ApiKeyName", apiKeyName())
                .add("ApiKeyValue", apiKeyValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApiKeyName":
            return Optional.ofNullable(clazz.cast(apiKeyName()));
        case "ApiKeyValue":
            return Optional.ofNullable(clazz.cast(apiKeyValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateConnectionApiKeyAuthRequestParameters, T> g) {
        return obj -> g.apply((CreateConnectionApiKeyAuthRequestParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateConnectionApiKeyAuthRequestParameters> {
        /**
         * <p>
         * The name of the API key to use for authorization.
         * </p>
         * 
         * @param apiKeyName
         *        The name of the API key to use for authorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiKeyName(String apiKeyName);

        /**
         * <p>
         * The value for the API key to use for authorization.
         * </p>
         * 
         * @param apiKeyValue
         *        The value for the API key to use for authorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiKeyValue(String apiKeyValue);
    }

    static final class BuilderImpl implements Builder {
        private String apiKeyName;

        private String apiKeyValue;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConnectionApiKeyAuthRequestParameters model) {
            apiKeyName(model.apiKeyName);
            apiKeyValue(model.apiKeyValue);
        }

        public final String getApiKeyName() {
            return apiKeyName;
        }

        public final void setApiKeyName(String apiKeyName) {
            this.apiKeyName = apiKeyName;
        }

        @Override
        public final Builder apiKeyName(String apiKeyName) {
            this.apiKeyName = apiKeyName;
            return this;
        }

        public final String getApiKeyValue() {
            return apiKeyValue;
        }

        public final void setApiKeyValue(String apiKeyValue) {
            this.apiKeyValue = apiKeyValue;
        }

        @Override
        public final Builder apiKeyValue(String apiKeyValue) {
            this.apiKeyValue = apiKeyValue;
            return this;
        }

        @Override
        public CreateConnectionApiKeyAuthRequestParameters build() {
            return new CreateConnectionApiKeyAuthRequestParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
