/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ReplayState {
    STARTING("STARTING"),
    RUNNING("RUNNING"),
    CANCELLING("CANCELLING"),
    COMPLETED("COMPLETED"),
    CANCELLED("CANCELLED"),
    FAILED("FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ReplayState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ReplayState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ReplayState.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ReplayState> knownValues() {
        return Stream.of(ReplayState.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

