/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the authorization parameters to use for the connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectionAuthResponseParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectionAuthResponseParameters.Builder, ConnectionAuthResponseParameters> {
    private static final SdkField<ConnectionBasicAuthResponseParameters> BASIC_AUTH_PARAMETERS_FIELD = SdkField
            .<ConnectionBasicAuthResponseParameters> builder(MarshallingType.SDK_POJO).memberName("BasicAuthParameters")
            .getter(getter(ConnectionAuthResponseParameters::basicAuthParameters)).setter(setter(Builder::basicAuthParameters))
            .constructor(ConnectionBasicAuthResponseParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BasicAuthParameters").build())
            .build();

    private static final SdkField<ConnectionOAuthResponseParameters> O_AUTH_PARAMETERS_FIELD = SdkField
            .<ConnectionOAuthResponseParameters> builder(MarshallingType.SDK_POJO).memberName("OAuthParameters")
            .getter(getter(ConnectionAuthResponseParameters::oAuthParameters)).setter(setter(Builder::oAuthParameters))
            .constructor(ConnectionOAuthResponseParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OAuthParameters").build()).build();

    private static final SdkField<ConnectionApiKeyAuthResponseParameters> API_KEY_AUTH_PARAMETERS_FIELD = SdkField
            .<ConnectionApiKeyAuthResponseParameters> builder(MarshallingType.SDK_POJO).memberName("ApiKeyAuthParameters")
            .getter(getter(ConnectionAuthResponseParameters::apiKeyAuthParameters)).setter(setter(Builder::apiKeyAuthParameters))
            .constructor(ConnectionApiKeyAuthResponseParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiKeyAuthParameters").build())
            .build();

    private static final SdkField<ConnectionHttpParameters> INVOCATION_HTTP_PARAMETERS_FIELD = SdkField
            .<ConnectionHttpParameters> builder(MarshallingType.SDK_POJO).memberName("InvocationHttpParameters")
            .getter(getter(ConnectionAuthResponseParameters::invocationHttpParameters))
            .setter(setter(Builder::invocationHttpParameters)).constructor(ConnectionHttpParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationHttpParameters").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASIC_AUTH_PARAMETERS_FIELD,
            O_AUTH_PARAMETERS_FIELD, API_KEY_AUTH_PARAMETERS_FIELD, INVOCATION_HTTP_PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final ConnectionBasicAuthResponseParameters basicAuthParameters;

    private final ConnectionOAuthResponseParameters oAuthParameters;

    private final ConnectionApiKeyAuthResponseParameters apiKeyAuthParameters;

    private final ConnectionHttpParameters invocationHttpParameters;

    private ConnectionAuthResponseParameters(BuilderImpl builder) {
        this.basicAuthParameters = builder.basicAuthParameters;
        this.oAuthParameters = builder.oAuthParameters;
        this.apiKeyAuthParameters = builder.apiKeyAuthParameters;
        this.invocationHttpParameters = builder.invocationHttpParameters;
    }

    /**
     * <p>
     * The authorization parameters for Basic authorization.
     * </p>
     * 
     * @return The authorization parameters for Basic authorization.
     */
    public final ConnectionBasicAuthResponseParameters basicAuthParameters() {
        return basicAuthParameters;
    }

    /**
     * <p>
     * The OAuth parameters to use for authorization.
     * </p>
     * 
     * @return The OAuth parameters to use for authorization.
     */
    public final ConnectionOAuthResponseParameters oAuthParameters() {
        return oAuthParameters;
    }

    /**
     * <p>
     * The API Key parameters to use for authorization.
     * </p>
     * 
     * @return The API Key parameters to use for authorization.
     */
    public final ConnectionApiKeyAuthResponseParameters apiKeyAuthParameters() {
        return apiKeyAuthParameters;
    }

    /**
     * <p>
     * Additional parameters for the connection that are passed through with every invocation to the HTTP endpoint.
     * </p>
     * 
     * @return Additional parameters for the connection that are passed through with every invocation to the HTTP
     *         endpoint.
     */
    public final ConnectionHttpParameters invocationHttpParameters() {
        return invocationHttpParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(basicAuthParameters());
        hashCode = 31 * hashCode + Objects.hashCode(oAuthParameters());
        hashCode = 31 * hashCode + Objects.hashCode(apiKeyAuthParameters());
        hashCode = 31 * hashCode + Objects.hashCode(invocationHttpParameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionAuthResponseParameters)) {
            return false;
        }
        ConnectionAuthResponseParameters other = (ConnectionAuthResponseParameters) obj;
        return Objects.equals(basicAuthParameters(), other.basicAuthParameters())
                && Objects.equals(oAuthParameters(), other.oAuthParameters())
                && Objects.equals(apiKeyAuthParameters(), other.apiKeyAuthParameters())
                && Objects.equals(invocationHttpParameters(), other.invocationHttpParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectionAuthResponseParameters").add("BasicAuthParameters", basicAuthParameters())
                .add("OAuthParameters", oAuthParameters()).add("ApiKeyAuthParameters", apiKeyAuthParameters())
                .add("InvocationHttpParameters", invocationHttpParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BasicAuthParameters":
            return Optional.ofNullable(clazz.cast(basicAuthParameters()));
        case "OAuthParameters":
            return Optional.ofNullable(clazz.cast(oAuthParameters()));
        case "ApiKeyAuthParameters":
            return Optional.ofNullable(clazz.cast(apiKeyAuthParameters()));
        case "InvocationHttpParameters":
            return Optional.ofNullable(clazz.cast(invocationHttpParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectionAuthResponseParameters, T> g) {
        return obj -> g.apply((ConnectionAuthResponseParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectionAuthResponseParameters> {
        /**
         * <p>
         * The authorization parameters for Basic authorization.
         * </p>
         * 
         * @param basicAuthParameters
         *        The authorization parameters for Basic authorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder basicAuthParameters(ConnectionBasicAuthResponseParameters basicAuthParameters);

        /**
         * <p>
         * The authorization parameters for Basic authorization.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ConnectionBasicAuthResponseParameters.Builder} avoiding the need to create one manually via
         * {@link ConnectionBasicAuthResponseParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectionBasicAuthResponseParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #basicAuthParameters(ConnectionBasicAuthResponseParameters)}.
         * 
         * @param basicAuthParameters
         *        a consumer that will call methods on {@link ConnectionBasicAuthResponseParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #basicAuthParameters(ConnectionBasicAuthResponseParameters)
         */
        default Builder basicAuthParameters(Consumer<ConnectionBasicAuthResponseParameters.Builder> basicAuthParameters) {
            return basicAuthParameters(ConnectionBasicAuthResponseParameters.builder().applyMutation(basicAuthParameters).build());
        }

        /**
         * <p>
         * The OAuth parameters to use for authorization.
         * </p>
         * 
         * @param oAuthParameters
         *        The OAuth parameters to use for authorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oAuthParameters(ConnectionOAuthResponseParameters oAuthParameters);

        /**
         * <p>
         * The OAuth parameters to use for authorization.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ConnectionOAuthResponseParameters.Builder} avoiding the need to create one manually via
         * {@link ConnectionOAuthResponseParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectionOAuthResponseParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #oAuthParameters(ConnectionOAuthResponseParameters)}.
         * 
         * @param oAuthParameters
         *        a consumer that will call methods on {@link ConnectionOAuthResponseParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oAuthParameters(ConnectionOAuthResponseParameters)
         */
        default Builder oAuthParameters(Consumer<ConnectionOAuthResponseParameters.Builder> oAuthParameters) {
            return oAuthParameters(ConnectionOAuthResponseParameters.builder().applyMutation(oAuthParameters).build());
        }

        /**
         * <p>
         * The API Key parameters to use for authorization.
         * </p>
         * 
         * @param apiKeyAuthParameters
         *        The API Key parameters to use for authorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiKeyAuthParameters(ConnectionApiKeyAuthResponseParameters apiKeyAuthParameters);

        /**
         * <p>
         * The API Key parameters to use for authorization.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ConnectionApiKeyAuthResponseParameters.Builder} avoiding the need to create one manually via
         * {@link ConnectionApiKeyAuthResponseParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectionApiKeyAuthResponseParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #apiKeyAuthParameters(ConnectionApiKeyAuthResponseParameters)}.
         * 
         * @param apiKeyAuthParameters
         *        a consumer that will call methods on {@link ConnectionApiKeyAuthResponseParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #apiKeyAuthParameters(ConnectionApiKeyAuthResponseParameters)
         */
        default Builder apiKeyAuthParameters(Consumer<ConnectionApiKeyAuthResponseParameters.Builder> apiKeyAuthParameters) {
            return apiKeyAuthParameters(ConnectionApiKeyAuthResponseParameters.builder().applyMutation(apiKeyAuthParameters)
                    .build());
        }

        /**
         * <p>
         * Additional parameters for the connection that are passed through with every invocation to the HTTP endpoint.
         * </p>
         * 
         * @param invocationHttpParameters
         *        Additional parameters for the connection that are passed through with every invocation to the HTTP
         *        endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationHttpParameters(ConnectionHttpParameters invocationHttpParameters);

        /**
         * <p>
         * Additional parameters for the connection that are passed through with every invocation to the HTTP endpoint.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConnectionHttpParameters.Builder}
         * avoiding the need to create one manually via {@link ConnectionHttpParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectionHttpParameters.Builder#build()} is called immediately
         * and its result is passed to {@link #invocationHttpParameters(ConnectionHttpParameters)}.
         * 
         * @param invocationHttpParameters
         *        a consumer that will call methods on {@link ConnectionHttpParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #invocationHttpParameters(ConnectionHttpParameters)
         */
        default Builder invocationHttpParameters(Consumer<ConnectionHttpParameters.Builder> invocationHttpParameters) {
            return invocationHttpParameters(ConnectionHttpParameters.builder().applyMutation(invocationHttpParameters).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ConnectionBasicAuthResponseParameters basicAuthParameters;

        private ConnectionOAuthResponseParameters oAuthParameters;

        private ConnectionApiKeyAuthResponseParameters apiKeyAuthParameters;

        private ConnectionHttpParameters invocationHttpParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionAuthResponseParameters model) {
            basicAuthParameters(model.basicAuthParameters);
            oAuthParameters(model.oAuthParameters);
            apiKeyAuthParameters(model.apiKeyAuthParameters);
            invocationHttpParameters(model.invocationHttpParameters);
        }

        public final ConnectionBasicAuthResponseParameters.Builder getBasicAuthParameters() {
            return basicAuthParameters != null ? basicAuthParameters.toBuilder() : null;
        }

        public final void setBasicAuthParameters(ConnectionBasicAuthResponseParameters.BuilderImpl basicAuthParameters) {
            this.basicAuthParameters = basicAuthParameters != null ? basicAuthParameters.build() : null;
        }

        @Override
        public final Builder basicAuthParameters(ConnectionBasicAuthResponseParameters basicAuthParameters) {
            this.basicAuthParameters = basicAuthParameters;
            return this;
        }

        public final ConnectionOAuthResponseParameters.Builder getOAuthParameters() {
            return oAuthParameters != null ? oAuthParameters.toBuilder() : null;
        }

        public final void setOAuthParameters(ConnectionOAuthResponseParameters.BuilderImpl oAuthParameters) {
            this.oAuthParameters = oAuthParameters != null ? oAuthParameters.build() : null;
        }

        @Override
        public final Builder oAuthParameters(ConnectionOAuthResponseParameters oAuthParameters) {
            this.oAuthParameters = oAuthParameters;
            return this;
        }

        public final ConnectionApiKeyAuthResponseParameters.Builder getApiKeyAuthParameters() {
            return apiKeyAuthParameters != null ? apiKeyAuthParameters.toBuilder() : null;
        }

        public final void setApiKeyAuthParameters(ConnectionApiKeyAuthResponseParameters.BuilderImpl apiKeyAuthParameters) {
            this.apiKeyAuthParameters = apiKeyAuthParameters != null ? apiKeyAuthParameters.build() : null;
        }

        @Override
        public final Builder apiKeyAuthParameters(ConnectionApiKeyAuthResponseParameters apiKeyAuthParameters) {
            this.apiKeyAuthParameters = apiKeyAuthParameters;
            return this;
        }

        public final ConnectionHttpParameters.Builder getInvocationHttpParameters() {
            return invocationHttpParameters != null ? invocationHttpParameters.toBuilder() : null;
        }

        public final void setInvocationHttpParameters(ConnectionHttpParameters.BuilderImpl invocationHttpParameters) {
            this.invocationHttpParameters = invocationHttpParameters != null ? invocationHttpParameters.build() : null;
        }

        @Override
        public final Builder invocationHttpParameters(ConnectionHttpParameters invocationHttpParameters) {
            this.invocationHttpParameters = invocationHttpParameters;
            return this;
        }

        @Override
        public ConnectionAuthResponseParameters build() {
            return new ConnectionAuthResponseParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
