/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchevents.model.ApiDestinationState;
import software.amazon.awssdk.services.cloudwatchevents.model.CloudWatchEventsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateApiDestinationResponse
extends CloudWatchEventsResponse
implements ToCopyableBuilder<Builder, CreateApiDestinationResponse> {
    private static final SdkField<String> API_DESTINATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApiDestinationArn").getter(CreateApiDestinationResponse.getter(CreateApiDestinationResponse::apiDestinationArn)).setter(CreateApiDestinationResponse.setter(Builder::apiDestinationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiDestinationArn").build()}).build();
    private static final SdkField<String> API_DESTINATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApiDestinationState").getter(CreateApiDestinationResponse.getter(CreateApiDestinationResponse::apiDestinationStateAsString)).setter(CreateApiDestinationResponse.setter(Builder::apiDestinationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiDestinationState").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(CreateApiDestinationResponse.getter(CreateApiDestinationResponse::creationTime)).setter(CreateApiDestinationResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(CreateApiDestinationResponse.getter(CreateApiDestinationResponse::lastModifiedTime)).setter(CreateApiDestinationResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_DESTINATION_ARN_FIELD, API_DESTINATION_STATE_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD));
    private final String apiDestinationArn;
    private final String apiDestinationState;
    private final Instant creationTime;
    private final Instant lastModifiedTime;

    private CreateApiDestinationResponse(BuilderImpl builder) {
        super(builder);
        this.apiDestinationArn = builder.apiDestinationArn;
        this.apiDestinationState = builder.apiDestinationState;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    public final String apiDestinationArn() {
        return this.apiDestinationArn;
    }

    public final ApiDestinationState apiDestinationState() {
        return ApiDestinationState.fromValue(this.apiDestinationState);
    }

    public final String apiDestinationStateAsString() {
        return this.apiDestinationState;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.apiDestinationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiDestinationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApiDestinationResponse)) {
            return false;
        }
        CreateApiDestinationResponse other = (CreateApiDestinationResponse)((Object)obj);
        return Objects.equals(this.apiDestinationArn(), other.apiDestinationArn()) && Objects.equals(this.apiDestinationStateAsString(), other.apiDestinationStateAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime());
    }

    public final String toString() {
        return ToString.builder((String)"CreateApiDestinationResponse").add("ApiDestinationArn", (Object)this.apiDestinationArn()).add("ApiDestinationState", (Object)this.apiDestinationStateAsString()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApiDestinationArn": {
                return Optional.ofNullable(clazz.cast(this.apiDestinationArn()));
            }
            case "ApiDestinationState": {
                return Optional.ofNullable(clazz.cast(this.apiDestinationStateAsString()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateApiDestinationResponse, T> g) {
        return obj -> g.apply((CreateApiDestinationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchEventsResponse.BuilderImpl
    implements Builder {
        private String apiDestinationArn;
        private String apiDestinationState;
        private Instant creationTime;
        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApiDestinationResponse model) {
            super(model);
            this.apiDestinationArn(model.apiDestinationArn);
            this.apiDestinationState(model.apiDestinationState);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
        }

        public final String getApiDestinationArn() {
            return this.apiDestinationArn;
        }

        public final void setApiDestinationArn(String apiDestinationArn) {
            this.apiDestinationArn = apiDestinationArn;
        }

        @Override
        public final Builder apiDestinationArn(String apiDestinationArn) {
            this.apiDestinationArn = apiDestinationArn;
            return this;
        }

        public final String getApiDestinationState() {
            return this.apiDestinationState;
        }

        public final void setApiDestinationState(String apiDestinationState) {
            this.apiDestinationState = apiDestinationState;
        }

        @Override
        public final Builder apiDestinationState(String apiDestinationState) {
            this.apiDestinationState = apiDestinationState;
            return this;
        }

        @Override
        public final Builder apiDestinationState(ApiDestinationState apiDestinationState) {
            this.apiDestinationState(apiDestinationState == null ? null : apiDestinationState.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        @Override
        public CreateApiDestinationResponse build() {
            return new CreateApiDestinationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchEventsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateApiDestinationResponse> {
        public Builder apiDestinationArn(String var1);

        public Builder apiDestinationState(String var1);

        public Builder apiDestinationState(ApiDestinationState var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);
    }
}

