/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchevents.model.ReplayDestinationFiltersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplayDestination
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReplayDestination> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(ReplayDestination.getter(ReplayDestination::arn)).setter(ReplayDestination.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<List<String>> FILTER_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FilterArns").getter(ReplayDestination.getter(ReplayDestination::filterArns)).setter(ReplayDestination.setter(Builder::filterArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, FILTER_ARNS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Arn", ARN_FIELD);
            this.put("FilterArns", FILTER_ARNS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final List<String> filterArns;

    private ReplayDestination(BuilderImpl builder) {
        this.arn = builder.arn;
        this.filterArns = builder.filterArns;
    }

    public final String arn() {
        return this.arn;
    }

    public final boolean hasFilterArns() {
        return this.filterArns != null && !(this.filterArns instanceof SdkAutoConstructList);
    }

    public final List<String> filterArns() {
        return this.filterArns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilterArns() ? this.filterArns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplayDestination)) {
            return false;
        }
        ReplayDestination other = (ReplayDestination)obj;
        return Objects.equals(this.arn(), other.arn()) && this.hasFilterArns() == other.hasFilterArns() && Objects.equals(this.filterArns(), other.filterArns());
    }

    public final String toString() {
        return ToString.builder((String)"ReplayDestination").add("Arn", (Object)this.arn()).add("FilterArns", this.hasFilterArns() ? this.filterArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "FilterArns": {
                return Optional.ofNullable(clazz.cast(this.filterArns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ReplayDestination, T> g) {
        return obj -> g.apply((ReplayDestination)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private List<String> filterArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReplayDestination model) {
            this.arn(model.arn);
            this.filterArns(model.filterArns);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Collection<String> getFilterArns() {
            if (this.filterArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.filterArns;
        }

        public final void setFilterArns(Collection<String> filterArns) {
            this.filterArns = ReplayDestinationFiltersCopier.copy(filterArns);
        }

        @Override
        public final Builder filterArns(Collection<String> filterArns) {
            this.filterArns = ReplayDestinationFiltersCopier.copy(filterArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterArns(String ... filterArns) {
            this.filterArns(Arrays.asList(filterArns));
            return this;
        }

        public ReplayDestination build() {
            return new ReplayDestination(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReplayDestination> {
        public Builder arn(String var1);

        public Builder filterArns(Collection<String> var1);

        public Builder filterArns(String ... var1);
    }
}

