/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * These are custom parameters to use when the target is a SageMaker Model Building Pipeline that starts based on
 * EventBridge events.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SageMakerPipelineParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<SageMakerPipelineParameters.Builder, SageMakerPipelineParameters> {
    private static final SdkField<List<SageMakerPipelineParameter>> PIPELINE_PARAMETER_LIST_FIELD = SdkField
            .<List<SageMakerPipelineParameter>> builder(MarshallingType.LIST)
            .memberName("PipelineParameterList")
            .getter(getter(SageMakerPipelineParameters::pipelineParameterList))
            .setter(setter(Builder::pipelineParameterList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineParameterList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SageMakerPipelineParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(SageMakerPipelineParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(PIPELINE_PARAMETER_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("PipelineParameterList", PIPELINE_PARAMETER_LIST_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final List<SageMakerPipelineParameter> pipelineParameterList;

    private SageMakerPipelineParameters(BuilderImpl builder) {
        this.pipelineParameterList = builder.pipelineParameterList;
    }

    /**
     * For responses, this returns true if the service returned a value for the PipelineParameterList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPipelineParameterList() {
        return pipelineParameterList != null && !(pipelineParameterList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of Parameter names and values for SageMaker Model Building Pipeline execution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPipelineParameterList} method.
     * </p>
     * 
     * @return List of Parameter names and values for SageMaker Model Building Pipeline execution.
     */
    public final List<SageMakerPipelineParameter> pipelineParameterList() {
        return pipelineParameterList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasPipelineParameterList() ? pipelineParameterList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SageMakerPipelineParameters)) {
            return false;
        }
        SageMakerPipelineParameters other = (SageMakerPipelineParameters) obj;
        return hasPipelineParameterList() == other.hasPipelineParameterList()
                && Objects.equals(pipelineParameterList(), other.pipelineParameterList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SageMakerPipelineParameters")
                .add("PipelineParameterList", hasPipelineParameterList() ? pipelineParameterList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PipelineParameterList":
            return Optional.ofNullable(clazz.cast(pipelineParameterList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SageMakerPipelineParameters, T> g) {
        return obj -> g.apply((SageMakerPipelineParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SageMakerPipelineParameters> {
        /**
         * <p>
         * List of Parameter names and values for SageMaker Model Building Pipeline execution.
         * </p>
         * 
         * @param pipelineParameterList
         *        List of Parameter names and values for SageMaker Model Building Pipeline execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineParameterList(Collection<SageMakerPipelineParameter> pipelineParameterList);

        /**
         * <p>
         * List of Parameter names and values for SageMaker Model Building Pipeline execution.
         * </p>
         * 
         * @param pipelineParameterList
         *        List of Parameter names and values for SageMaker Model Building Pipeline execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineParameterList(SageMakerPipelineParameter... pipelineParameterList);

        /**
         * <p>
         * List of Parameter names and values for SageMaker Model Building Pipeline execution.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudwatchevents.model.SageMakerPipelineParameter.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.cloudwatchevents.model.SageMakerPipelineParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudwatchevents.model.SageMakerPipelineParameter.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #pipelineParameterList(List<SageMakerPipelineParameter>)}.
         * 
         * @param pipelineParameterList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudwatchevents.model.SageMakerPipelineParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pipelineParameterList(java.util.Collection<SageMakerPipelineParameter>)
         */
        Builder pipelineParameterList(Consumer<SageMakerPipelineParameter.Builder>... pipelineParameterList);
    }

    static final class BuilderImpl implements Builder {
        private List<SageMakerPipelineParameter> pipelineParameterList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SageMakerPipelineParameters model) {
            pipelineParameterList(model.pipelineParameterList);
        }

        public final List<SageMakerPipelineParameter.Builder> getPipelineParameterList() {
            List<SageMakerPipelineParameter.Builder> result = SageMakerPipelineParameterListCopier
                    .copyToBuilder(this.pipelineParameterList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPipelineParameterList(Collection<SageMakerPipelineParameter.BuilderImpl> pipelineParameterList) {
            this.pipelineParameterList = SageMakerPipelineParameterListCopier.copyFromBuilder(pipelineParameterList);
        }

        @Override
        public final Builder pipelineParameterList(Collection<SageMakerPipelineParameter> pipelineParameterList) {
            this.pipelineParameterList = SageMakerPipelineParameterListCopier.copy(pipelineParameterList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineParameterList(SageMakerPipelineParameter... pipelineParameterList) {
            pipelineParameterList(Arrays.asList(pipelineParameterList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineParameterList(Consumer<SageMakerPipelineParameter.Builder>... pipelineParameterList) {
            pipelineParameterList(Stream.of(pipelineParameterList)
                    .map(c -> SageMakerPipelineParameter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SageMakerPipelineParameters build() {
            return new SageMakerPipelineParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
