/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchevents.model.CloudWatchEventsResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.ConnectionAuthResponseParameters;
import software.amazon.awssdk.services.cloudwatchevents.model.ConnectionAuthorizationType;
import software.amazon.awssdk.services.cloudwatchevents.model.ConnectionState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConnectionResponse
extends CloudWatchEventsResponse
implements ToCopyableBuilder<Builder, DescribeConnectionResponse> {
    private static final SdkField<String> CONNECTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionArn").getter(DescribeConnectionResponse.getter(DescribeConnectionResponse::connectionArn)).setter(DescribeConnectionResponse.setter(Builder::connectionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DescribeConnectionResponse.getter(DescribeConnectionResponse::name)).setter(DescribeConnectionResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DescribeConnectionResponse.getter(DescribeConnectionResponse::description)).setter(DescribeConnectionResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> CONNECTION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionState").getter(DescribeConnectionResponse.getter(DescribeConnectionResponse::connectionStateAsString)).setter(DescribeConnectionResponse.setter(Builder::connectionState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionState").build()}).build();
    private static final SdkField<String> STATE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateReason").getter(DescribeConnectionResponse.getter(DescribeConnectionResponse::stateReason)).setter(DescribeConnectionResponse.setter(Builder::stateReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason").build()}).build();
    private static final SdkField<String> AUTHORIZATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthorizationType").getter(DescribeConnectionResponse.getter(DescribeConnectionResponse::authorizationTypeAsString)).setter(DescribeConnectionResponse.setter(Builder::authorizationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizationType").build()}).build();
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretArn").getter(DescribeConnectionResponse.getter(DescribeConnectionResponse::secretArn)).setter(DescribeConnectionResponse.setter(Builder::secretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()}).build();
    private static final SdkField<ConnectionAuthResponseParameters> AUTH_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AuthParameters").getter(DescribeConnectionResponse.getter(DescribeConnectionResponse::authParameters)).setter(DescribeConnectionResponse.setter(Builder::authParameters)).constructor(ConnectionAuthResponseParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthParameters").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeConnectionResponse.getter(DescribeConnectionResponse::creationTime)).setter(DescribeConnectionResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(DescribeConnectionResponse.getter(DescribeConnectionResponse::lastModifiedTime)).setter(DescribeConnectionResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<Instant> LAST_AUTHORIZED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastAuthorizedTime").getter(DescribeConnectionResponse.getter(DescribeConnectionResponse::lastAuthorizedTime)).setter(DescribeConnectionResponse.setter(Builder::lastAuthorizedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastAuthorizedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, CONNECTION_STATE_FIELD, STATE_REASON_FIELD, AUTHORIZATION_TYPE_FIELD, SECRET_ARN_FIELD, AUTH_PARAMETERS_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_AUTHORIZED_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ConnectionArn", CONNECTION_ARN_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("ConnectionState", CONNECTION_STATE_FIELD);
            this.put("StateReason", STATE_REASON_FIELD);
            this.put("AuthorizationType", AUTHORIZATION_TYPE_FIELD);
            this.put("SecretArn", SECRET_ARN_FIELD);
            this.put("AuthParameters", AUTH_PARAMETERS_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
            this.put("LastAuthorizedTime", LAST_AUTHORIZED_TIME_FIELD);
        }
    });
    private final String connectionArn;
    private final String name;
    private final String description;
    private final String connectionState;
    private final String stateReason;
    private final String authorizationType;
    private final String secretArn;
    private final ConnectionAuthResponseParameters authParameters;
    private final Instant creationTime;
    private final Instant lastModifiedTime;
    private final Instant lastAuthorizedTime;

    private DescribeConnectionResponse(BuilderImpl builder) {
        super(builder);
        this.connectionArn = builder.connectionArn;
        this.name = builder.name;
        this.description = builder.description;
        this.connectionState = builder.connectionState;
        this.stateReason = builder.stateReason;
        this.authorizationType = builder.authorizationType;
        this.secretArn = builder.secretArn;
        this.authParameters = builder.authParameters;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastAuthorizedTime = builder.lastAuthorizedTime;
    }

    public final String connectionArn() {
        return this.connectionArn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final ConnectionState connectionState() {
        return ConnectionState.fromValue(this.connectionState);
    }

    public final String connectionStateAsString() {
        return this.connectionState;
    }

    public final String stateReason() {
        return this.stateReason;
    }

    public final ConnectionAuthorizationType authorizationType() {
        return ConnectionAuthorizationType.fromValue(this.authorizationType);
    }

    public final String authorizationTypeAsString() {
        return this.authorizationType;
    }

    public final String secretArn() {
        return this.secretArn;
    }

    public final ConnectionAuthResponseParameters authParameters() {
        return this.authParameters;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final Instant lastAuthorizedTime() {
        return this.lastAuthorizedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.authParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastAuthorizedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConnectionResponse)) {
            return false;
        }
        DescribeConnectionResponse other = (DescribeConnectionResponse)((Object)obj);
        return Objects.equals(this.connectionArn(), other.connectionArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.connectionStateAsString(), other.connectionStateAsString()) && Objects.equals(this.stateReason(), other.stateReason()) && Objects.equals(this.authorizationTypeAsString(), other.authorizationTypeAsString()) && Objects.equals(this.secretArn(), other.secretArn()) && Objects.equals(this.authParameters(), other.authParameters()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.lastAuthorizedTime(), other.lastAuthorizedTime());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeConnectionResponse").add("ConnectionArn", (Object)this.connectionArn()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("ConnectionState", (Object)this.connectionStateAsString()).add("StateReason", (Object)this.stateReason()).add("AuthorizationType", (Object)this.authorizationTypeAsString()).add("SecretArn", (Object)this.secretArn()).add("AuthParameters", (Object)this.authParameters()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("LastAuthorizedTime", (Object)this.lastAuthorizedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectionArn": {
                return Optional.ofNullable(clazz.cast(this.connectionArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ConnectionState": {
                return Optional.ofNullable(clazz.cast(this.connectionStateAsString()));
            }
            case "StateReason": {
                return Optional.ofNullable(clazz.cast(this.stateReason()));
            }
            case "AuthorizationType": {
                return Optional.ofNullable(clazz.cast(this.authorizationTypeAsString()));
            }
            case "SecretArn": {
                return Optional.ofNullable(clazz.cast(this.secretArn()));
            }
            case "AuthParameters": {
                return Optional.ofNullable(clazz.cast(this.authParameters()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "LastAuthorizedTime": {
                return Optional.ofNullable(clazz.cast(this.lastAuthorizedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConnectionResponse, T> g) {
        return obj -> g.apply((DescribeConnectionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchEventsResponse.BuilderImpl
    implements Builder {
        private String connectionArn;
        private String name;
        private String description;
        private String connectionState;
        private String stateReason;
        private String authorizationType;
        private String secretArn;
        private ConnectionAuthResponseParameters authParameters;
        private Instant creationTime;
        private Instant lastModifiedTime;
        private Instant lastAuthorizedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConnectionResponse model) {
            super(model);
            this.connectionArn(model.connectionArn);
            this.name(model.name);
            this.description(model.description);
            this.connectionState(model.connectionState);
            this.stateReason(model.stateReason);
            this.authorizationType(model.authorizationType);
            this.secretArn(model.secretArn);
            this.authParameters(model.authParameters);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.lastAuthorizedTime(model.lastAuthorizedTime);
        }

        public final String getConnectionArn() {
            return this.connectionArn;
        }

        public final void setConnectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
        }

        @Override
        public final Builder connectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getConnectionState() {
            return this.connectionState;
        }

        public final void setConnectionState(String connectionState) {
            this.connectionState = connectionState;
        }

        @Override
        public final Builder connectionState(String connectionState) {
            this.connectionState = connectionState;
            return this;
        }

        @Override
        public final Builder connectionState(ConnectionState connectionState) {
            this.connectionState(connectionState == null ? null : connectionState.toString());
            return this;
        }

        public final String getStateReason() {
            return this.stateReason;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final String getAuthorizationType() {
            return this.authorizationType;
        }

        public final void setAuthorizationType(String authorizationType) {
            this.authorizationType = authorizationType;
        }

        @Override
        public final Builder authorizationType(String authorizationType) {
            this.authorizationType = authorizationType;
            return this;
        }

        @Override
        public final Builder authorizationType(ConnectionAuthorizationType authorizationType) {
            this.authorizationType(authorizationType == null ? null : authorizationType.toString());
            return this;
        }

        public final String getSecretArn() {
            return this.secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final ConnectionAuthResponseParameters.Builder getAuthParameters() {
            return this.authParameters != null ? this.authParameters.toBuilder() : null;
        }

        public final void setAuthParameters(ConnectionAuthResponseParameters.BuilderImpl authParameters) {
            this.authParameters = authParameters != null ? authParameters.build() : null;
        }

        @Override
        public final Builder authParameters(ConnectionAuthResponseParameters authParameters) {
            this.authParameters = authParameters;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Instant getLastAuthorizedTime() {
            return this.lastAuthorizedTime;
        }

        public final void setLastAuthorizedTime(Instant lastAuthorizedTime) {
            this.lastAuthorizedTime = lastAuthorizedTime;
        }

        @Override
        public final Builder lastAuthorizedTime(Instant lastAuthorizedTime) {
            this.lastAuthorizedTime = lastAuthorizedTime;
            return this;
        }

        @Override
        public DescribeConnectionResponse build() {
            return new DescribeConnectionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudWatchEventsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeConnectionResponse> {
        public Builder connectionArn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder connectionState(String var1);

        public Builder connectionState(ConnectionState var1);

        public Builder stateReason(String var1);

        public Builder authorizationType(String var1);

        public Builder authorizationType(ConnectionAuthorizationType var1);

        public Builder secretArn(String var1);

        public Builder authParameters(ConnectionAuthResponseParameters var1);

        default public Builder authParameters(Consumer<ConnectionAuthResponseParameters.Builder> authParameters) {
            return this.authParameters((ConnectionAuthResponseParameters)((ConnectionAuthResponseParameters.Builder)ConnectionAuthResponseParameters.builder().applyMutation(authParameters)).build());
        }

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder lastAuthorizedTime(Instant var1);
    }
}

