/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchevents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRuleNamesByTargetResponse extends CloudWatchEventsResponse implements
        ToCopyableBuilder<ListRuleNamesByTargetResponse.Builder, ListRuleNamesByTargetResponse> {
    private static final SdkField<List<String>> RULE_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListRuleNamesByTargetResponse::ruleNames))
            .setter(setter(Builder::ruleNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListRuleNamesByTargetResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_NAMES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<String> ruleNames;

    private final String nextToken;

    private ListRuleNamesByTargetResponse(BuilderImpl builder) {
        super(builder);
        this.ruleNames = builder.ruleNames;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The names of the rules that can invoke the given target.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The names of the rules that can invoke the given target.
     */
    public List<String> ruleNames() {
        return ruleNames;
    }

    /**
     * <p>
     * Indicates whether there are additional results to retrieve. If there are no more results, the value is null.
     * </p>
     * 
     * @return Indicates whether there are additional results to retrieve. If there are no more results, the value is
     *         null.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ruleNames());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRuleNamesByTargetResponse)) {
            return false;
        }
        ListRuleNamesByTargetResponse other = (ListRuleNamesByTargetResponse) obj;
        return Objects.equals(ruleNames(), other.ruleNames()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListRuleNamesByTargetResponse").add("RuleNames", ruleNames()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleNames":
            return Optional.ofNullable(clazz.cast(ruleNames()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRuleNamesByTargetResponse, T> g) {
        return obj -> g.apply((ListRuleNamesByTargetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchEventsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListRuleNamesByTargetResponse> {
        /**
         * <p>
         * The names of the rules that can invoke the given target.
         * </p>
         * 
         * @param ruleNames
         *        The names of the rules that can invoke the given target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleNames(Collection<String> ruleNames);

        /**
         * <p>
         * The names of the rules that can invoke the given target.
         * </p>
         * 
         * @param ruleNames
         *        The names of the rules that can invoke the given target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleNames(String... ruleNames);

        /**
         * <p>
         * Indicates whether there are additional results to retrieve. If there are no more results, the value is null.
         * </p>
         * 
         * @param nextToken
         *        Indicates whether there are additional results to retrieve. If there are no more results, the value is
         *        null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudWatchEventsResponse.BuilderImpl implements Builder {
        private List<String> ruleNames = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRuleNamesByTargetResponse model) {
            super(model);
            ruleNames(model.ruleNames);
            nextToken(model.nextToken);
        }

        public final Collection<String> getRuleNames() {
            return ruleNames;
        }

        @Override
        public final Builder ruleNames(Collection<String> ruleNames) {
            this.ruleNames = RuleNameListCopier.copy(ruleNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleNames(String... ruleNames) {
            ruleNames(Arrays.asList(ruleNames));
            return this;
        }

        public final void setRuleNames(Collection<String> ruleNames) {
            this.ruleNames = RuleNameListCopier.copy(ruleNames);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListRuleNamesByTargetResponse build() {
            return new ListRuleNamesByTargetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
