/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchevents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPartnerEventSourceAccountsResponse extends CloudWatchEventsResponse implements
        ToCopyableBuilder<ListPartnerEventSourceAccountsResponse.Builder, ListPartnerEventSourceAccountsResponse> {
    private static final SdkField<List<PartnerEventSourceAccount>> PARTNER_EVENT_SOURCE_ACCOUNTS_FIELD = SdkField
            .<List<PartnerEventSourceAccount>> builder(MarshallingType.LIST)
            .memberName("PartnerEventSourceAccounts")
            .getter(getter(ListPartnerEventSourceAccountsResponse::partnerEventSourceAccounts))
            .setter(setter(Builder::partnerEventSourceAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartnerEventSourceAccounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PartnerEventSourceAccount> builder(MarshallingType.SDK_POJO)
                                            .constructor(PartnerEventSourceAccount::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListPartnerEventSourceAccountsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PARTNER_EVENT_SOURCE_ACCOUNTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<PartnerEventSourceAccount> partnerEventSourceAccounts;

    private final String nextToken;

    private ListPartnerEventSourceAccountsResponse(BuilderImpl builder) {
        super(builder);
        this.partnerEventSourceAccounts = builder.partnerEventSourceAccounts;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the PartnerEventSourceAccounts property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPartnerEventSourceAccounts() {
        return partnerEventSourceAccounts != null && !(partnerEventSourceAccounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of partner event sources returned by the operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPartnerEventSourceAccounts} method.
     * </p>
     * 
     * @return The list of partner event sources returned by the operation.
     */
    public final List<PartnerEventSourceAccount> partnerEventSourceAccounts() {
        return partnerEventSourceAccounts;
    }

    /**
     * <p>
     * A token you can use in a subsequent operation to retrieve the next set of results.
     * </p>
     * 
     * @return A token you can use in a subsequent operation to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPartnerEventSourceAccounts() ? partnerEventSourceAccounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPartnerEventSourceAccountsResponse)) {
            return false;
        }
        ListPartnerEventSourceAccountsResponse other = (ListPartnerEventSourceAccountsResponse) obj;
        return hasPartnerEventSourceAccounts() == other.hasPartnerEventSourceAccounts()
                && Objects.equals(partnerEventSourceAccounts(), other.partnerEventSourceAccounts())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPartnerEventSourceAccountsResponse")
                .add("PartnerEventSourceAccounts", hasPartnerEventSourceAccounts() ? partnerEventSourceAccounts() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PartnerEventSourceAccounts":
            return Optional.ofNullable(clazz.cast(partnerEventSourceAccounts()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PartnerEventSourceAccounts", PARTNER_EVENT_SOURCE_ACCOUNTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPartnerEventSourceAccountsResponse, T> g) {
        return obj -> g.apply((ListPartnerEventSourceAccountsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchEventsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListPartnerEventSourceAccountsResponse> {
        /**
         * <p>
         * The list of partner event sources returned by the operation.
         * </p>
         * 
         * @param partnerEventSourceAccounts
         *        The list of partner event sources returned by the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partnerEventSourceAccounts(Collection<PartnerEventSourceAccount> partnerEventSourceAccounts);

        /**
         * <p>
         * The list of partner event sources returned by the operation.
         * </p>
         * 
         * @param partnerEventSourceAccounts
         *        The list of partner event sources returned by the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partnerEventSourceAccounts(PartnerEventSourceAccount... partnerEventSourceAccounts);

        /**
         * <p>
         * The list of partner event sources returned by the operation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudwatchevents.model.PartnerEventSourceAccount.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.cloudwatchevents.model.PartnerEventSourceAccount#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudwatchevents.model.PartnerEventSourceAccount.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #partnerEventSourceAccounts(List<PartnerEventSourceAccount>)}.
         * 
         * @param partnerEventSourceAccounts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudwatchevents.model.PartnerEventSourceAccount.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #partnerEventSourceAccounts(java.util.Collection<PartnerEventSourceAccount>)
         */
        Builder partnerEventSourceAccounts(Consumer<PartnerEventSourceAccount.Builder>... partnerEventSourceAccounts);

        /**
         * <p>
         * A token you can use in a subsequent operation to retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        A token you can use in a subsequent operation to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudWatchEventsResponse.BuilderImpl implements Builder {
        private List<PartnerEventSourceAccount> partnerEventSourceAccounts = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPartnerEventSourceAccountsResponse model) {
            super(model);
            partnerEventSourceAccounts(model.partnerEventSourceAccounts);
            nextToken(model.nextToken);
        }

        public final List<PartnerEventSourceAccount.Builder> getPartnerEventSourceAccounts() {
            List<PartnerEventSourceAccount.Builder> result = PartnerEventSourceAccountListCopier
                    .copyToBuilder(this.partnerEventSourceAccounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPartnerEventSourceAccounts(
                Collection<PartnerEventSourceAccount.BuilderImpl> partnerEventSourceAccounts) {
            this.partnerEventSourceAccounts = PartnerEventSourceAccountListCopier.copyFromBuilder(partnerEventSourceAccounts);
        }

        @Override
        public final Builder partnerEventSourceAccounts(Collection<PartnerEventSourceAccount> partnerEventSourceAccounts) {
            this.partnerEventSourceAccounts = PartnerEventSourceAccountListCopier.copy(partnerEventSourceAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partnerEventSourceAccounts(PartnerEventSourceAccount... partnerEventSourceAccounts) {
            partnerEventSourceAccounts(Arrays.asList(partnerEventSourceAccounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partnerEventSourceAccounts(Consumer<PartnerEventSourceAccount.Builder>... partnerEventSourceAccounts) {
            partnerEventSourceAccounts(Stream.of(partnerEventSourceAccounts)
                    .map(c -> PartnerEventSourceAccount.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPartnerEventSourceAccountsResponse build() {
            return new ListPartnerEventSourceAccountsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
