/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchevents.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTargetsByRuleRequest extends CloudWatchEventsRequest implements
        ToCopyableBuilder<ListTargetsByRuleRequest.Builder, ListTargetsByRuleRequest> {
    private static final SdkField<String> RULE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Rule")
            .getter(getter(ListTargetsByRuleRequest::rule)).setter(setter(Builder::rule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rule").build()).build();

    private static final SdkField<String> EVENT_BUS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventBusName").getter(getter(ListTargetsByRuleRequest::eventBusName))
            .setter(setter(Builder::eventBusName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventBusName").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListTargetsByRuleRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Limit")
            .getter(getter(ListTargetsByRuleRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_FIELD,
            EVENT_BUS_NAME_FIELD, NEXT_TOKEN_FIELD, LIMIT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String rule;

    private final String eventBusName;

    private final String nextToken;

    private final Integer limit;

    private ListTargetsByRuleRequest(BuilderImpl builder) {
        super(builder);
        this.rule = builder.rule;
        this.eventBusName = builder.eventBusName;
        this.nextToken = builder.nextToken;
        this.limit = builder.limit;
    }

    /**
     * <p>
     * The name of the rule.
     * </p>
     * 
     * @return The name of the rule.
     */
    public final String rule() {
        return rule;
    }

    /**
     * <p>
     * The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.
     * </p>
     * 
     * @return The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is
     *         used.
     */
    public final String eventBusName() {
        return eventBusName;
    }

    /**
     * <p>
     * The token returned by a previous call to retrieve the next set of results.
     * </p>
     * 
     * @return The token returned by a previous call to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return.
     * </p>
     * 
     * @return The maximum number of results to return.
     */
    public final Integer limit() {
        return limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(rule());
        hashCode = 31 * hashCode + Objects.hashCode(eventBusName());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTargetsByRuleRequest)) {
            return false;
        }
        ListTargetsByRuleRequest other = (ListTargetsByRuleRequest) obj;
        return Objects.equals(rule(), other.rule()) && Objects.equals(eventBusName(), other.eventBusName())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(limit(), other.limit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTargetsByRuleRequest").add("Rule", rule()).add("EventBusName", eventBusName())
                .add("NextToken", nextToken()).add("Limit", limit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Rule":
            return Optional.ofNullable(clazz.cast(rule()));
        case "EventBusName":
            return Optional.ofNullable(clazz.cast(eventBusName()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Rule", RULE_FIELD);
        map.put("EventBusName", EVENT_BUS_NAME_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Limit", LIMIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTargetsByRuleRequest, T> g) {
        return obj -> g.apply((ListTargetsByRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchEventsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListTargetsByRuleRequest> {
        /**
         * <p>
         * The name of the rule.
         * </p>
         * 
         * @param rule
         *        The name of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rule(String rule);

        /**
         * <p>
         * The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.
         * </p>
         * 
         * @param eventBusName
         *        The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is
         *        used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventBusName(String eventBusName);

        /**
         * <p>
         * The token returned by a previous call to retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token returned by a previous call to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return.
         * </p>
         * 
         * @param limit
         *        The maximum number of results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchEventsRequest.BuilderImpl implements Builder {
        private String rule;

        private String eventBusName;

        private String nextToken;

        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTargetsByRuleRequest model) {
            super(model);
            rule(model.rule);
            eventBusName(model.eventBusName);
            nextToken(model.nextToken);
            limit(model.limit);
        }

        public final String getRule() {
            return rule;
        }

        public final void setRule(String rule) {
            this.rule = rule;
        }

        @Override
        public final Builder rule(String rule) {
            this.rule = rule;
            return this;
        }

        public final String getEventBusName() {
            return eventBusName;
        }

        public final void setEventBusName(String eventBusName) {
            this.eventBusName = eventBusName;
        }

        @Override
        public final Builder eventBusName(String eventBusName) {
            this.eventBusName = eventBusName;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTargetsByRuleRequest build() {
            return new ListTargetsByRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
