/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchevents.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RemovePermissionRequest extends CloudWatchEventsRequest implements
        ToCopyableBuilder<RemovePermissionRequest.Builder, RemovePermissionRequest> {
    private static final SdkField<String> STATEMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatementId").getter(getter(RemovePermissionRequest::statementId)).setter(setter(Builder::statementId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatementId").build()).build();

    private static final SdkField<Boolean> REMOVE_ALL_PERMISSIONS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RemoveAllPermissions").getter(getter(RemovePermissionRequest::removeAllPermissions))
            .setter(setter(Builder::removeAllPermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveAllPermissions").build())
            .build();

    private static final SdkField<String> EVENT_BUS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventBusName").getter(getter(RemovePermissionRequest::eventBusName))
            .setter(setter(Builder::eventBusName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventBusName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATEMENT_ID_FIELD,
            REMOVE_ALL_PERMISSIONS_FIELD, EVENT_BUS_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String statementId;

    private final Boolean removeAllPermissions;

    private final String eventBusName;

    private RemovePermissionRequest(BuilderImpl builder) {
        super(builder);
        this.statementId = builder.statementId;
        this.removeAllPermissions = builder.removeAllPermissions;
        this.eventBusName = builder.eventBusName;
    }

    /**
     * <p>
     * The statement ID corresponding to the account that is no longer allowed to put events to the default event bus.
     * </p>
     * 
     * @return The statement ID corresponding to the account that is no longer allowed to put events to the default
     *         event bus.
     */
    public final String statementId() {
        return statementId;
    }

    /**
     * <p>
     * Specifies whether to remove all permissions.
     * </p>
     * 
     * @return Specifies whether to remove all permissions.
     */
    public final Boolean removeAllPermissions() {
        return removeAllPermissions;
    }

    /**
     * <p>
     * The name of the event bus to revoke permissions for. If you omit this, the default event bus is used.
     * </p>
     * 
     * @return The name of the event bus to revoke permissions for. If you omit this, the default event bus is used.
     */
    public final String eventBusName() {
        return eventBusName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(statementId());
        hashCode = 31 * hashCode + Objects.hashCode(removeAllPermissions());
        hashCode = 31 * hashCode + Objects.hashCode(eventBusName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemovePermissionRequest)) {
            return false;
        }
        RemovePermissionRequest other = (RemovePermissionRequest) obj;
        return Objects.equals(statementId(), other.statementId())
                && Objects.equals(removeAllPermissions(), other.removeAllPermissions())
                && Objects.equals(eventBusName(), other.eventBusName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RemovePermissionRequest").add("StatementId", statementId())
                .add("RemoveAllPermissions", removeAllPermissions()).add("EventBusName", eventBusName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StatementId":
            return Optional.ofNullable(clazz.cast(statementId()));
        case "RemoveAllPermissions":
            return Optional.ofNullable(clazz.cast(removeAllPermissions()));
        case "EventBusName":
            return Optional.ofNullable(clazz.cast(eventBusName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StatementId", STATEMENT_ID_FIELD);
        map.put("RemoveAllPermissions", REMOVE_ALL_PERMISSIONS_FIELD);
        map.put("EventBusName", EVENT_BUS_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RemovePermissionRequest, T> g) {
        return obj -> g.apply((RemovePermissionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchEventsRequest.Builder, SdkPojo, CopyableBuilder<Builder, RemovePermissionRequest> {
        /**
         * <p>
         * The statement ID corresponding to the account that is no longer allowed to put events to the default event
         * bus.
         * </p>
         * 
         * @param statementId
         *        The statement ID corresponding to the account that is no longer allowed to put events to the default
         *        event bus.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statementId(String statementId);

        /**
         * <p>
         * Specifies whether to remove all permissions.
         * </p>
         * 
         * @param removeAllPermissions
         *        Specifies whether to remove all permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeAllPermissions(Boolean removeAllPermissions);

        /**
         * <p>
         * The name of the event bus to revoke permissions for. If you omit this, the default event bus is used.
         * </p>
         * 
         * @param eventBusName
         *        The name of the event bus to revoke permissions for. If you omit this, the default event bus is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventBusName(String eventBusName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchEventsRequest.BuilderImpl implements Builder {
        private String statementId;

        private Boolean removeAllPermissions;

        private String eventBusName;

        private BuilderImpl() {
        }

        private BuilderImpl(RemovePermissionRequest model) {
            super(model);
            statementId(model.statementId);
            removeAllPermissions(model.removeAllPermissions);
            eventBusName(model.eventBusName);
        }

        public final String getStatementId() {
            return statementId;
        }

        public final void setStatementId(String statementId) {
            this.statementId = statementId;
        }

        @Override
        public final Builder statementId(String statementId) {
            this.statementId = statementId;
            return this;
        }

        public final Boolean getRemoveAllPermissions() {
            return removeAllPermissions;
        }

        public final void setRemoveAllPermissions(Boolean removeAllPermissions) {
            this.removeAllPermissions = removeAllPermissions;
        }

        @Override
        public final Builder removeAllPermissions(Boolean removeAllPermissions) {
            this.removeAllPermissions = removeAllPermissions;
            return this;
        }

        public final String getEventBusName() {
            return eventBusName;
        }

        public final void setEventBusName(String eventBusName) {
            this.eventBusName = eventBusName;
        }

        @Override
        public final Builder eventBusName(String eventBusName) {
            this.eventBusName = eventBusName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RemovePermissionRequest build() {
            return new RemovePermissionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
