/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchevents.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteRuleRequest extends CloudWatchEventsRequest implements
        ToCopyableBuilder<DeleteRuleRequest.Builder, DeleteRuleRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteRuleRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Boolean> FORCE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(DeleteRuleRequest::force)).setter(setter(Builder::force))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Force").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, FORCE_FIELD));

    private final String name;

    private final Boolean force;

    private DeleteRuleRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.force = builder.force;
    }

    /**
     * <p>
     * The name of the rule.
     * </p>
     * 
     * @return The name of the rule.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * If this is a managed rule, created by an AWS service on your behalf, you must specify <code>Force</code> as
     * <code>True</code> to delete the rule. This parameter is ignored for rules that are not managed rules. You can
     * check whether a rule is a managed rule by using <code>DescribeRule</code> or <code>ListRules</code> and checking
     * the <code>ManagedBy</code> field of the response.
     * </p>
     * 
     * @return If this is a managed rule, created by an AWS service on your behalf, you must specify <code>Force</code>
     *         as <code>True</code> to delete the rule. This parameter is ignored for rules that are not managed rules.
     *         You can check whether a rule is a managed rule by using <code>DescribeRule</code> or
     *         <code>ListRules</code> and checking the <code>ManagedBy</code> field of the response.
     */
    public Boolean force() {
        return force;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(force());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRuleRequest)) {
            return false;
        }
        DeleteRuleRequest other = (DeleteRuleRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(force(), other.force());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteRuleRequest").add("Name", name()).add("Force", force()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Force":
            return Optional.ofNullable(clazz.cast(force()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteRuleRequest, T> g) {
        return obj -> g.apply((DeleteRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchEventsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteRuleRequest> {
        /**
         * <p>
         * The name of the rule.
         * </p>
         * 
         * @param name
         *        The name of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * If this is a managed rule, created by an AWS service on your behalf, you must specify <code>Force</code> as
         * <code>True</code> to delete the rule. This parameter is ignored for rules that are not managed rules. You can
         * check whether a rule is a managed rule by using <code>DescribeRule</code> or <code>ListRules</code> and
         * checking the <code>ManagedBy</code> field of the response.
         * </p>
         * 
         * @param force
         *        If this is a managed rule, created by an AWS service on your behalf, you must specify
         *        <code>Force</code> as <code>True</code> to delete the rule. This parameter is ignored for rules that
         *        are not managed rules. You can check whether a rule is a managed rule by using
         *        <code>DescribeRule</code> or <code>ListRules</code> and checking the <code>ManagedBy</code> field of
         *        the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder force(Boolean force);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchEventsRequest.BuilderImpl implements Builder {
        private String name;

        private Boolean force;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRuleRequest model) {
            super(model);
            name(model.name);
            force(model.force);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Boolean getForce() {
            return force;
        }

        @Override
        public final Builder force(Boolean force) {
            this.force = force;
            return this;
        }

        public final void setForce(Boolean force) {
            this.force = force;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteRuleRequest build() {
            return new DeleteRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
