/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure specifies the VPC subnets and security groups for the task, and whether a public IP address is to be
 * used. This structure is relevant only for ECS tasks that use the <code>awsvpc</code> network mode.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsVpcConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsVpcConfiguration.Builder, AwsVpcConfiguration> {
    private static final SdkField<List<String>> SUBNETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(AwsVpcConfiguration::subnets))
            .setter(setter(Builder::subnets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subnets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(AwsVpcConfiguration::securityGroups))
            .setter(setter(Builder::securityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ASSIGN_PUBLIC_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsVpcConfiguration::assignPublicIpAsString)).setter(setter(Builder::assignPublicIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignPublicIp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNETS_FIELD,
            SECURITY_GROUPS_FIELD, ASSIGN_PUBLIC_IP_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> subnets;

    private final List<String> securityGroups;

    private final String assignPublicIp;

    private AwsVpcConfiguration(BuilderImpl builder) {
        this.subnets = builder.subnets;
        this.securityGroups = builder.securityGroups;
        this.assignPublicIp = builder.assignPublicIp;
    }

    /**
     * <p>
     * Specifies the subnets associated with the task. These subnets must all be in the same VPC. You can specify as
     * many as 16 subnets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Specifies the subnets associated with the task. These subnets must all be in the same VPC. You can
     *         specify as many as 16 subnets.
     */
    public List<String> subnets() {
        return subnets;
    }

    /**
     * <p>
     * Specifies the security groups associated with the task. These security groups must all be in the same VPC. You
     * can specify as many as five security groups. If you do not specify a security group, the default security group
     * for the VPC is used.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Specifies the security groups associated with the task. These security groups must all be in the same
     *         VPC. You can specify as many as five security groups. If you do not specify a security group, the default
     *         security group for the VPC is used.
     */
    public List<String> securityGroups() {
        return securityGroups;
    }

    /**
     * <p>
     * Specifies whether the task's elastic network interface receives a public IP address. You can specify
     * <code>ENABLED</code> only when <code>LaunchType</code> in <code>EcsParameters</code> is set to
     * <code>FARGATE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #assignPublicIp}
     * will return {@link AssignPublicIp#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #assignPublicIpAsString}.
     * </p>
     * 
     * @return Specifies whether the task's elastic network interface receives a public IP address. You can specify
     *         <code>ENABLED</code> only when <code>LaunchType</code> in <code>EcsParameters</code> is set to
     *         <code>FARGATE</code>.
     * @see AssignPublicIp
     */
    public AssignPublicIp assignPublicIp() {
        return AssignPublicIp.fromValue(assignPublicIp);
    }

    /**
     * <p>
     * Specifies whether the task's elastic network interface receives a public IP address. You can specify
     * <code>ENABLED</code> only when <code>LaunchType</code> in <code>EcsParameters</code> is set to
     * <code>FARGATE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #assignPublicIp}
     * will return {@link AssignPublicIp#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #assignPublicIpAsString}.
     * </p>
     * 
     * @return Specifies whether the task's elastic network interface receives a public IP address. You can specify
     *         <code>ENABLED</code> only when <code>LaunchType</code> in <code>EcsParameters</code> is set to
     *         <code>FARGATE</code>.
     * @see AssignPublicIp
     */
    public String assignPublicIpAsString() {
        return assignPublicIp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(subnets());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(assignPublicIpAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsVpcConfiguration)) {
            return false;
        }
        AwsVpcConfiguration other = (AwsVpcConfiguration) obj;
        return Objects.equals(subnets(), other.subnets()) && Objects.equals(securityGroups(), other.securityGroups())
                && Objects.equals(assignPublicIpAsString(), other.assignPublicIpAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AwsVpcConfiguration").add("Subnets", subnets()).add("SecurityGroups", securityGroups())
                .add("AssignPublicIp", assignPublicIpAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Subnets":
            return Optional.ofNullable(clazz.cast(subnets()));
        case "SecurityGroups":
            return Optional.ofNullable(clazz.cast(securityGroups()));
        case "AssignPublicIp":
            return Optional.ofNullable(clazz.cast(assignPublicIpAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsVpcConfiguration, T> g) {
        return obj -> g.apply((AwsVpcConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsVpcConfiguration> {
        /**
         * <p>
         * Specifies the subnets associated with the task. These subnets must all be in the same VPC. You can specify as
         * many as 16 subnets.
         * </p>
         * 
         * @param subnets
         *        Specifies the subnets associated with the task. These subnets must all be in the same VPC. You can
         *        specify as many as 16 subnets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(Collection<String> subnets);

        /**
         * <p>
         * Specifies the subnets associated with the task. These subnets must all be in the same VPC. You can specify as
         * many as 16 subnets.
         * </p>
         * 
         * @param subnets
         *        Specifies the subnets associated with the task. These subnets must all be in the same VPC. You can
         *        specify as many as 16 subnets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(String... subnets);

        /**
         * <p>
         * Specifies the security groups associated with the task. These security groups must all be in the same VPC.
         * You can specify as many as five security groups. If you do not specify a security group, the default security
         * group for the VPC is used.
         * </p>
         * 
         * @param securityGroups
         *        Specifies the security groups associated with the task. These security groups must all be in the same
         *        VPC. You can specify as many as five security groups. If you do not specify a security group, the
         *        default security group for the VPC is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<String> securityGroups);

        /**
         * <p>
         * Specifies the security groups associated with the task. These security groups must all be in the same VPC.
         * You can specify as many as five security groups. If you do not specify a security group, the default security
         * group for the VPC is used.
         * </p>
         * 
         * @param securityGroups
         *        Specifies the security groups associated with the task. These security groups must all be in the same
         *        VPC. You can specify as many as five security groups. If you do not specify a security group, the
         *        default security group for the VPC is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(String... securityGroups);

        /**
         * <p>
         * Specifies whether the task's elastic network interface receives a public IP address. You can specify
         * <code>ENABLED</code> only when <code>LaunchType</code> in <code>EcsParameters</code> is set to
         * <code>FARGATE</code>.
         * </p>
         * 
         * @param assignPublicIp
         *        Specifies whether the task's elastic network interface receives a public IP address. You can specify
         *        <code>ENABLED</code> only when <code>LaunchType</code> in <code>EcsParameters</code> is set to
         *        <code>FARGATE</code>.
         * @see AssignPublicIp
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssignPublicIp
         */
        Builder assignPublicIp(String assignPublicIp);

        /**
         * <p>
         * Specifies whether the task's elastic network interface receives a public IP address. You can specify
         * <code>ENABLED</code> only when <code>LaunchType</code> in <code>EcsParameters</code> is set to
         * <code>FARGATE</code>.
         * </p>
         * 
         * @param assignPublicIp
         *        Specifies whether the task's elastic network interface receives a public IP address. You can specify
         *        <code>ENABLED</code> only when <code>LaunchType</code> in <code>EcsParameters</code> is set to
         *        <code>FARGATE</code>.
         * @see AssignPublicIp
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssignPublicIp
         */
        Builder assignPublicIp(AssignPublicIp assignPublicIp);
    }

    static final class BuilderImpl implements Builder {
        private List<String> subnets = DefaultSdkAutoConstructList.getInstance();

        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private String assignPublicIp;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsVpcConfiguration model) {
            subnets(model.subnets);
            securityGroups(model.securityGroups);
            assignPublicIp(model.assignPublicIp);
        }

        public final Collection<String> getSubnets() {
            return subnets;
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String... subnets) {
            subnets(Arrays.asList(subnets));
            return this;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
        }

        public final Collection<String> getSecurityGroups() {
            return securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = StringListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = StringListCopier.copy(securityGroups);
        }

        public final String getAssignPublicIpAsString() {
            return assignPublicIp;
        }

        @Override
        public final Builder assignPublicIp(String assignPublicIp) {
            this.assignPublicIp = assignPublicIp;
            return this;
        }

        @Override
        public final Builder assignPublicIp(AssignPublicIp assignPublicIp) {
            this.assignPublicIp(assignPublicIp.toString());
            return this;
        }

        public final void setAssignPublicIp(String assignPublicIp) {
            this.assignPublicIp = assignPublicIp;
        }

        @Override
        public AwsVpcConfiguration build() {
            return new AwsVpcConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
