/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchevents.model.AssignPublicIp;
import software.amazon.awssdk.services.cloudwatchevents.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsVpcConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsVpcConfiguration> {
    private static final SdkField<List<String>> SUBNETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AwsVpcConfiguration.getter(AwsVpcConfiguration::subnets)).setter(AwsVpcConfiguration.setter(Builder::subnets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subnets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AwsVpcConfiguration.getter(AwsVpcConfiguration::securityGroups)).setter(AwsVpcConfiguration.setter(Builder::securityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ASSIGN_PUBLIC_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AwsVpcConfiguration.getter(AwsVpcConfiguration::assignPublicIpAsString)).setter(AwsVpcConfiguration.setter(Builder::assignPublicIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignPublicIp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNETS_FIELD, SECURITY_GROUPS_FIELD, ASSIGN_PUBLIC_IP_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> subnets;
    private final List<String> securityGroups;
    private final String assignPublicIp;

    private AwsVpcConfiguration(BuilderImpl builder) {
        this.subnets = builder.subnets;
        this.securityGroups = builder.securityGroups;
        this.assignPublicIp = builder.assignPublicIp;
    }

    public List<String> subnets() {
        return this.subnets;
    }

    public List<String> securityGroups() {
        return this.securityGroups;
    }

    public AssignPublicIp assignPublicIp() {
        return AssignPublicIp.fromValue(this.assignPublicIp);
    }

    public String assignPublicIpAsString() {
        return this.assignPublicIp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subnets());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.assignPublicIpAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsVpcConfiguration)) {
            return false;
        }
        AwsVpcConfiguration other = (AwsVpcConfiguration)obj;
        return Objects.equals(this.subnets(), other.subnets()) && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.assignPublicIpAsString(), other.assignPublicIpAsString());
    }

    public String toString() {
        return ToString.builder((String)"AwsVpcConfiguration").add("Subnets", this.subnets()).add("SecurityGroups", this.securityGroups()).add("AssignPublicIp", (Object)this.assignPublicIpAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Subnets": {
                return Optional.ofNullable(clazz.cast(this.subnets()));
            }
            case "SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
            case "AssignPublicIp": {
                return Optional.ofNullable(clazz.cast(this.assignPublicIpAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsVpcConfiguration, T> g) {
        return obj -> g.apply((AwsVpcConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> subnets = DefaultSdkAutoConstructList.getInstance();
        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();
        private String assignPublicIp;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsVpcConfiguration model) {
            this.subnets(model.subnets);
            this.securityGroups(model.securityGroups);
            this.assignPublicIp(model.assignPublicIp);
        }

        public final Collection<String> getSubnets() {
            return this.subnets;
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String ... subnets) {
            this.subnets(Arrays.asList(subnets));
            return this;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
        }

        public final Collection<String> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = StringListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = StringListCopier.copy(securityGroups);
        }

        public final String getAssignPublicIpAsString() {
            return this.assignPublicIp;
        }

        @Override
        public final Builder assignPublicIp(String assignPublicIp) {
            this.assignPublicIp = assignPublicIp;
            return this;
        }

        @Override
        public final Builder assignPublicIp(AssignPublicIp assignPublicIp) {
            this.assignPublicIp(assignPublicIp == null ? null : assignPublicIp.toString());
            return this;
        }

        public final void setAssignPublicIp(String assignPublicIp) {
            this.assignPublicIp = assignPublicIp;
        }

        public AwsVpcConfiguration build() {
            return new AwsVpcConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsVpcConfiguration> {
        public Builder subnets(Collection<String> var1);

        public Builder subnets(String ... var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);

        public Builder assignPublicIp(String var1);

        public Builder assignPublicIp(AssignPublicIp var1);
    }
}

