/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates how to transform ingested log eventsto metric data in a CloudWatch metric.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricTransformation implements SdkPojo, Serializable,
        ToCopyableBuilder<MetricTransformation.Builder, MetricTransformation> {
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MetricTransformation::metricName)).setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricName").build()).build();

    private static final SdkField<String> METRIC_NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MetricTransformation::metricNamespace)).setter(setter(Builder::metricNamespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricNamespace").build()).build();

    private static final SdkField<String> METRIC_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MetricTransformation::metricValue)).setter(setter(Builder::metricValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricValue").build()).build();

    private static final SdkField<Double> DEFAULT_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(MetricTransformation::defaultValue)).setter(setter(Builder::defaultValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAME_FIELD,
            METRIC_NAMESPACE_FIELD, METRIC_VALUE_FIELD, DEFAULT_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String metricName;

    private final String metricNamespace;

    private final String metricValue;

    private final Double defaultValue;

    private MetricTransformation(BuilderImpl builder) {
        this.metricName = builder.metricName;
        this.metricNamespace = builder.metricNamespace;
        this.metricValue = builder.metricValue;
        this.defaultValue = builder.defaultValue;
    }

    /**
     * <p>
     * The name of the CloudWatch metric.
     * </p>
     * 
     * @return The name of the CloudWatch metric.
     */
    public String metricName() {
        return metricName;
    }

    /**
     * <p>
     * The namespace of the CloudWatch metric.
     * </p>
     * 
     * @return The namespace of the CloudWatch metric.
     */
    public String metricNamespace() {
        return metricNamespace;
    }

    /**
     * <p>
     * The value to publish to the CloudWatch metric when a filter pattern matches a log event.
     * </p>
     * 
     * @return The value to publish to the CloudWatch metric when a filter pattern matches a log event.
     */
    public String metricValue() {
        return metricValue;
    }

    /**
     * <p>
     * (Optional) The value to emit when a filter pattern does not match a log event. This value can be null.
     * </p>
     * 
     * @return (Optional) The value to emit when a filter pattern does not match a log event. This value can be null.
     */
    public Double defaultValue() {
        return defaultValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metricName());
        hashCode = 31 * hashCode + Objects.hashCode(metricNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(metricValue());
        hashCode = 31 * hashCode + Objects.hashCode(defaultValue());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricTransformation)) {
            return false;
        }
        MetricTransformation other = (MetricTransformation) obj;
        return Objects.equals(metricName(), other.metricName()) && Objects.equals(metricNamespace(), other.metricNamespace())
                && Objects.equals(metricValue(), other.metricValue()) && Objects.equals(defaultValue(), other.defaultValue());
    }

    @Override
    public String toString() {
        return ToString.builder("MetricTransformation").add("MetricName", metricName()).add("MetricNamespace", metricNamespace())
                .add("MetricValue", metricValue()).add("DefaultValue", defaultValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "metricName":
            return Optional.ofNullable(clazz.cast(metricName()));
        case "metricNamespace":
            return Optional.ofNullable(clazz.cast(metricNamespace()));
        case "metricValue":
            return Optional.ofNullable(clazz.cast(metricValue()));
        case "defaultValue":
            return Optional.ofNullable(clazz.cast(defaultValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricTransformation, T> g) {
        return obj -> g.apply((MetricTransformation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricTransformation> {
        /**
         * <p>
         * The name of the CloudWatch metric.
         * </p>
         * 
         * @param metricName
         *        The name of the CloudWatch metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The namespace of the CloudWatch metric.
         * </p>
         * 
         * @param metricNamespace
         *        The namespace of the CloudWatch metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricNamespace(String metricNamespace);

        /**
         * <p>
         * The value to publish to the CloudWatch metric when a filter pattern matches a log event.
         * </p>
         * 
         * @param metricValue
         *        The value to publish to the CloudWatch metric when a filter pattern matches a log event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricValue(String metricValue);

        /**
         * <p>
         * (Optional) The value to emit when a filter pattern does not match a log event. This value can be null.
         * </p>
         * 
         * @param defaultValue
         *        (Optional) The value to emit when a filter pattern does not match a log event. This value can be null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(Double defaultValue);
    }

    static final class BuilderImpl implements Builder {
        private String metricName;

        private String metricNamespace;

        private String metricValue;

        private Double defaultValue;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricTransformation model) {
            metricName(model.metricName);
            metricNamespace(model.metricNamespace);
            metricValue(model.metricValue);
            defaultValue(model.defaultValue);
        }

        public final String getMetricName() {
            return metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final String getMetricNamespace() {
            return metricNamespace;
        }

        @Override
        public final Builder metricNamespace(String metricNamespace) {
            this.metricNamespace = metricNamespace;
            return this;
        }

        public final void setMetricNamespace(String metricNamespace) {
            this.metricNamespace = metricNamespace;
        }

        public final String getMetricValue() {
            return metricValue;
        }

        @Override
        public final Builder metricValue(String metricValue) {
            this.metricValue = metricValue;
            return this;
        }

        public final void setMetricValue(String metricValue) {
            this.metricValue = metricValue;
        }

        public final Double getDefaultValue() {
            return defaultValue;
        }

        @Override
        public final Builder defaultValue(Double defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final void setDefaultValue(Double defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public MetricTransformation build() {
            return new MetricTransformation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
