/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopQueryResponse extends CloudWatchLogsResponse implements
        ToCopyableBuilder<StopQueryResponse.Builder, StopQueryResponse> {
    private static final SdkField<Boolean> SUCCESS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(StopQueryResponse::success)).setter(setter(Builder::success))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("success").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESS_FIELD));

    private final Boolean success;

    private StopQueryResponse(BuilderImpl builder) {
        super(builder);
        this.success = builder.success;
    }

    /**
     * <p>
     * This is true if the query was stopped by the <code>StopQuery</code> operation.
     * </p>
     * 
     * @return This is true if the query was stopped by the <code>StopQuery</code> operation.
     */
    public Boolean success() {
        return success;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(success());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopQueryResponse)) {
            return false;
        }
        StopQueryResponse other = (StopQueryResponse) obj;
        return Objects.equals(success(), other.success());
    }

    @Override
    public String toString() {
        return ToString.builder("StopQueryResponse").add("Success", success()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "success":
            return Optional.ofNullable(clazz.cast(success()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StopQueryResponse, T> g) {
        return obj -> g.apply((StopQueryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsResponse.Builder, SdkPojo, CopyableBuilder<Builder, StopQueryResponse> {
        /**
         * <p>
         * This is true if the query was stopped by the <code>StopQuery</code> operation.
         * </p>
         * 
         * @param success
         *        This is true if the query was stopped by the <code>StopQuery</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder success(Boolean success);
    }

    static final class BuilderImpl extends CloudWatchLogsResponse.BuilderImpl implements Builder {
        private Boolean success;

        private BuilderImpl() {
        }

        private BuilderImpl(StopQueryResponse model) {
            super(model);
            success(model.success);
        }

        public final Boolean getSuccess() {
            return success;
        }

        @Override
        public final Builder success(Boolean success) {
            this.success = success;
            return this;
        }

        public final void setSuccess(Boolean success) {
            this.success = success;
        }

        @Override
        public StopQueryResponse build() {
            return new StopQueryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
