/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The fields contained in log events found by a <code>GetLogGroupFields</code> operation, along with the percentage of
 * queried log events in which each field appears.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LogGroupField implements SdkPojo, Serializable, ToCopyableBuilder<LogGroupField.Builder, LogGroupField> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LogGroupField::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Integer> PERCENT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(LogGroupField::percent)).setter(setter(Builder::percent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("percent").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, PERCENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Integer percent;

    private LogGroupField(BuilderImpl builder) {
        this.name = builder.name;
        this.percent = builder.percent;
    }

    /**
     * <p>
     * The name of a log field.
     * </p>
     * 
     * @return The name of a log field.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The percentage of log events queried that contained the field.
     * </p>
     * 
     * @return The percentage of log events queried that contained the field.
     */
    public Integer percent() {
        return percent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(percent());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogGroupField)) {
            return false;
        }
        LogGroupField other = (LogGroupField) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(percent(), other.percent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LogGroupField").add("Name", name()).add("Percent", percent()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "percent":
            return Optional.ofNullable(clazz.cast(percent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LogGroupField, T> g) {
        return obj -> g.apply((LogGroupField) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LogGroupField> {
        /**
         * <p>
         * The name of a log field.
         * </p>
         * 
         * @param name
         *        The name of a log field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The percentage of log events queried that contained the field.
         * </p>
         * 
         * @param percent
         *        The percentage of log events queried that contained the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder percent(Integer percent);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Integer percent;

        private BuilderImpl() {
        }

        private BuilderImpl(LogGroupField model) {
            name(model.name);
            percent(model.percent);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getPercent() {
            return percent;
        }

        @Override
        public final Builder percent(Integer percent) {
            this.percent = percent;
            return this;
        }

        public final void setPercent(Integer percent) {
            this.percent = percent;
        }

        @Override
        public LogGroupField build() {
            return new LogGroupField(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
