/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Reserved.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryCompileErrorLocation implements SdkPojo, Serializable,
        ToCopyableBuilder<QueryCompileErrorLocation.Builder, QueryCompileErrorLocation> {
    private static final SdkField<Integer> START_CHAR_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(QueryCompileErrorLocation::startCharOffset)).setter(setter(Builder::startCharOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startCharOffset").build()).build();

    private static final SdkField<Integer> END_CHAR_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(QueryCompileErrorLocation::endCharOffset)).setter(setter(Builder::endCharOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endCharOffset").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_CHAR_OFFSET_FIELD,
            END_CHAR_OFFSET_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer startCharOffset;

    private final Integer endCharOffset;

    private QueryCompileErrorLocation(BuilderImpl builder) {
        this.startCharOffset = builder.startCharOffset;
        this.endCharOffset = builder.endCharOffset;
    }

    /**
     * <p>
     * Reserved.
     * </p>
     * 
     * @return Reserved.
     */
    public Integer startCharOffset() {
        return startCharOffset;
    }

    /**
     * <p>
     * Reserved.
     * </p>
     * 
     * @return Reserved.
     */
    public Integer endCharOffset() {
        return endCharOffset;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startCharOffset());
        hashCode = 31 * hashCode + Objects.hashCode(endCharOffset());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryCompileErrorLocation)) {
            return false;
        }
        QueryCompileErrorLocation other = (QueryCompileErrorLocation) obj;
        return Objects.equals(startCharOffset(), other.startCharOffset())
                && Objects.equals(endCharOffset(), other.endCharOffset());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("QueryCompileErrorLocation").add("StartCharOffset", startCharOffset())
                .add("EndCharOffset", endCharOffset()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "startCharOffset":
            return Optional.ofNullable(clazz.cast(startCharOffset()));
        case "endCharOffset":
            return Optional.ofNullable(clazz.cast(endCharOffset()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryCompileErrorLocation, T> g) {
        return obj -> g.apply((QueryCompileErrorLocation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueryCompileErrorLocation> {
        /**
         * <p>
         * Reserved.
         * </p>
         * 
         * @param startCharOffset
         *        Reserved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startCharOffset(Integer startCharOffset);

        /**
         * <p>
         * Reserved.
         * </p>
         * 
         * @param endCharOffset
         *        Reserved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endCharOffset(Integer endCharOffset);
    }

    static final class BuilderImpl implements Builder {
        private Integer startCharOffset;

        private Integer endCharOffset;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryCompileErrorLocation model) {
            startCharOffset(model.startCharOffset);
            endCharOffset(model.endCharOffset);
        }

        public final Integer getStartCharOffset() {
            return startCharOffset;
        }

        @Override
        public final Builder startCharOffset(Integer startCharOffset) {
            this.startCharOffset = startCharOffset;
            return this;
        }

        public final void setStartCharOffset(Integer startCharOffset) {
            this.startCharOffset = startCharOffset;
        }

        public final Integer getEndCharOffset() {
            return endCharOffset;
        }

        @Override
        public final Builder endCharOffset(Integer endCharOffset) {
            this.endCharOffset = endCharOffset;
            return this;
        }

        public final void setEndCharOffset(Integer endCharOffset) {
            this.endCharOffset = endCharOffset;
        }

        @Override
        public QueryCompileErrorLocation build() {
            return new QueryCompileErrorLocation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
