/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutResourcePolicyResponse extends CloudWatchLogsResponse implements
        ToCopyableBuilder<PutResourcePolicyResponse.Builder, PutResourcePolicyResponse> {
    private static final SdkField<ResourcePolicy> RESOURCE_POLICY_FIELD = SdkField
            .<ResourcePolicy> builder(MarshallingType.SDK_POJO).getter(getter(PutResourcePolicyResponse::resourcePolicy))
            .setter(setter(Builder::resourcePolicy)).constructor(ResourcePolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourcePolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_POLICY_FIELD));

    private final ResourcePolicy resourcePolicy;

    private PutResourcePolicyResponse(BuilderImpl builder) {
        super(builder);
        this.resourcePolicy = builder.resourcePolicy;
    }

    /**
     * <p>
     * The new policy.
     * </p>
     * 
     * @return The new policy.
     */
    public ResourcePolicy resourcePolicy() {
        return resourcePolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourcePolicy());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutResourcePolicyResponse)) {
            return false;
        }
        PutResourcePolicyResponse other = (PutResourcePolicyResponse) obj;
        return Objects.equals(resourcePolicy(), other.resourcePolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutResourcePolicyResponse").add("ResourcePolicy", resourcePolicy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourcePolicy":
            return Optional.ofNullable(clazz.cast(resourcePolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutResourcePolicyResponse, T> g) {
        return obj -> g.apply((PutResourcePolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutResourcePolicyResponse> {
        /**
         * <p>
         * The new policy.
         * </p>
         * 
         * @param resourcePolicy
         *        The new policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcePolicy(ResourcePolicy resourcePolicy);

        /**
         * <p>
         * The new policy.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourcePolicy.Builder} avoiding the need to
         * create one manually via {@link ResourcePolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourcePolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #resourcePolicy(ResourcePolicy)}.
         * 
         * @param resourcePolicy
         *        a consumer that will call methods on {@link ResourcePolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourcePolicy(ResourcePolicy)
         */
        default Builder resourcePolicy(Consumer<ResourcePolicy.Builder> resourcePolicy) {
            return resourcePolicy(ResourcePolicy.builder().applyMutation(resourcePolicy).build());
        }
    }

    static final class BuilderImpl extends CloudWatchLogsResponse.BuilderImpl implements Builder {
        private ResourcePolicy resourcePolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(PutResourcePolicyResponse model) {
            super(model);
            resourcePolicy(model.resourcePolicy);
        }

        public final ResourcePolicy.Builder getResourcePolicy() {
            return resourcePolicy != null ? resourcePolicy.toBuilder() : null;
        }

        @Override
        public final Builder resourcePolicy(ResourcePolicy resourcePolicy) {
            this.resourcePolicy = resourcePolicy;
            return this;
        }

        public final void setResourcePolicy(ResourcePolicy.BuilderImpl resourcePolicy) {
            this.resourcePolicy = resourcePolicy != null ? resourcePolicy.build() : null;
        }

        @Override
        public PutResourcePolicyResponse build() {
            return new PutResourcePolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
