/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutMetricFilterRequest extends CloudWatchLogsRequest implements
        ToCopyableBuilder<PutMetricFilterRequest.Builder, PutMetricFilterRequest> {
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutMetricFilterRequest::logGroupName)).setter(setter(Builder::logGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()).build();

    private static final SdkField<String> FILTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutMetricFilterRequest::filterName)).setter(setter(Builder::filterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterName").build()).build();

    private static final SdkField<String> FILTER_PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutMetricFilterRequest::filterPattern)).setter(setter(Builder::filterPattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterPattern").build()).build();

    private static final SdkField<List<MetricTransformation>> METRIC_TRANSFORMATIONS_FIELD = SdkField
            .<List<MetricTransformation>> builder(MarshallingType.LIST)
            .getter(getter(PutMetricFilterRequest::metricTransformations))
            .setter(setter(Builder::metricTransformations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricTransformations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricTransformation> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricTransformation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_NAME_FIELD,
            FILTER_NAME_FIELD, FILTER_PATTERN_FIELD, METRIC_TRANSFORMATIONS_FIELD));

    private final String logGroupName;

    private final String filterName;

    private final String filterPattern;

    private final List<MetricTransformation> metricTransformations;

    private PutMetricFilterRequest(BuilderImpl builder) {
        super(builder);
        this.logGroupName = builder.logGroupName;
        this.filterName = builder.filterName;
        this.filterPattern = builder.filterPattern;
        this.metricTransformations = builder.metricTransformations;
    }

    /**
     * <p>
     * The name of the log group.
     * </p>
     * 
     * @return The name of the log group.
     */
    public String logGroupName() {
        return logGroupName;
    }

    /**
     * <p>
     * A name for the metric filter.
     * </p>
     * 
     * @return A name for the metric filter.
     */
    public String filterName() {
        return filterName;
    }

    /**
     * <p>
     * A filter pattern for extracting metric data out of ingested log events.
     * </p>
     * 
     * @return A filter pattern for extracting metric data out of ingested log events.
     */
    public String filterPattern() {
        return filterPattern;
    }

    /**
     * Returns true if the MetricTransformations property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasMetricTransformations() {
        return metricTransformations != null && !(metricTransformations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A collection of information that defines how metric data gets emitted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMetricTransformations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A collection of information that defines how metric data gets emitted.
     */
    public List<MetricTransformation> metricTransformations() {
        return metricTransformations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(filterName());
        hashCode = 31 * hashCode + Objects.hashCode(filterPattern());
        hashCode = 31 * hashCode + Objects.hashCode(metricTransformations());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutMetricFilterRequest)) {
            return false;
        }
        PutMetricFilterRequest other = (PutMetricFilterRequest) obj;
        return Objects.equals(logGroupName(), other.logGroupName()) && Objects.equals(filterName(), other.filterName())
                && Objects.equals(filterPattern(), other.filterPattern())
                && Objects.equals(metricTransformations(), other.metricTransformations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutMetricFilterRequest").add("LogGroupName", logGroupName()).add("FilterName", filterName())
                .add("FilterPattern", filterPattern()).add("MetricTransformations", metricTransformations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logGroupName":
            return Optional.ofNullable(clazz.cast(logGroupName()));
        case "filterName":
            return Optional.ofNullable(clazz.cast(filterName()));
        case "filterPattern":
            return Optional.ofNullable(clazz.cast(filterPattern()));
        case "metricTransformations":
            return Optional.ofNullable(clazz.cast(metricTransformations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutMetricFilterRequest, T> g) {
        return obj -> g.apply((PutMetricFilterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutMetricFilterRequest> {
        /**
         * <p>
         * The name of the log group.
         * </p>
         * 
         * @param logGroupName
         *        The name of the log group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);

        /**
         * <p>
         * A name for the metric filter.
         * </p>
         * 
         * @param filterName
         *        A name for the metric filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterName(String filterName);

        /**
         * <p>
         * A filter pattern for extracting metric data out of ingested log events.
         * </p>
         * 
         * @param filterPattern
         *        A filter pattern for extracting metric data out of ingested log events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterPattern(String filterPattern);

        /**
         * <p>
         * A collection of information that defines how metric data gets emitted.
         * </p>
         * 
         * @param metricTransformations
         *        A collection of information that defines how metric data gets emitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricTransformations(Collection<MetricTransformation> metricTransformations);

        /**
         * <p>
         * A collection of information that defines how metric data gets emitted.
         * </p>
         * 
         * @param metricTransformations
         *        A collection of information that defines how metric data gets emitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricTransformations(MetricTransformation... metricTransformations);

        /**
         * <p>
         * A collection of information that defines how metric data gets emitted.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MetricTransformation>.Builder} avoiding the
         * need to create one manually via {@link List<MetricTransformation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MetricTransformation>.Builder#build()} is called immediately
         * and its result is passed to {@link #metricTransformations(List<MetricTransformation>)}.
         * 
         * @param metricTransformations
         *        a consumer that will call methods on {@link List<MetricTransformation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricTransformations(List<MetricTransformation>)
         */
        Builder metricTransformations(Consumer<MetricTransformation.Builder>... metricTransformations);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchLogsRequest.BuilderImpl implements Builder {
        private String logGroupName;

        private String filterName;

        private String filterPattern;

        private List<MetricTransformation> metricTransformations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutMetricFilterRequest model) {
            super(model);
            logGroupName(model.logGroupName);
            filterName(model.filterName);
            filterPattern(model.filterPattern);
            metricTransformations(model.metricTransformations);
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final String getFilterName() {
            return filterName;
        }

        @Override
        public final Builder filterName(String filterName) {
            this.filterName = filterName;
            return this;
        }

        public final void setFilterName(String filterName) {
            this.filterName = filterName;
        }

        public final String getFilterPattern() {
            return filterPattern;
        }

        @Override
        public final Builder filterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
            return this;
        }

        public final void setFilterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
        }

        public final Collection<MetricTransformation.Builder> getMetricTransformations() {
            return metricTransformations != null ? metricTransformations.stream().map(MetricTransformation::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder metricTransformations(Collection<MetricTransformation> metricTransformations) {
            this.metricTransformations = MetricTransformationsCopier.copy(metricTransformations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricTransformations(MetricTransformation... metricTransformations) {
            metricTransformations(Arrays.asList(metricTransformations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricTransformations(Consumer<MetricTransformation.Builder>... metricTransformations) {
            metricTransformations(Stream.of(metricTransformations)
                    .map(c -> MetricTransformation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMetricTransformations(Collection<MetricTransformation.BuilderImpl> metricTransformations) {
            this.metricTransformations = MetricTransformationsCopier.copyFromBuilder(metricTransformations);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutMetricFilterRequest build() {
            return new PutMetricFilterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
