/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeQueryDefinitionsResponse extends CloudWatchLogsResponse implements
        ToCopyableBuilder<DescribeQueryDefinitionsResponse.Builder, DescribeQueryDefinitionsResponse> {
    private static final SdkField<List<QueryDefinition>> QUERY_DEFINITIONS_FIELD = SdkField
            .<List<QueryDefinition>> builder(MarshallingType.LIST)
            .getter(getter(DescribeQueryDefinitionsResponse::queryDefinitions))
            .setter(setter(Builder::queryDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<QueryDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(QueryDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeQueryDefinitionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_DEFINITIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<QueryDefinition> queryDefinitions;

    private final String nextToken;

    private DescribeQueryDefinitionsResponse(BuilderImpl builder) {
        super(builder);
        this.queryDefinitions = builder.queryDefinitions;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the QueryDefinitions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasQueryDefinitions() {
        return queryDefinitions != null && !(queryDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the QueryDefinitions property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasQueryDefinitions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the QueryDefinitions property for this object.
     */
    public List<QueryDefinition> queryDefinitions() {
        return queryDefinitions;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(queryDefinitions());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeQueryDefinitionsResponse)) {
            return false;
        }
        DescribeQueryDefinitionsResponse other = (DescribeQueryDefinitionsResponse) obj;
        return Objects.equals(queryDefinitions(), other.queryDefinitions()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeQueryDefinitionsResponse").add("QueryDefinitions", queryDefinitions())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "queryDefinitions":
            return Optional.ofNullable(clazz.cast(queryDefinitions()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeQueryDefinitionsResponse, T> g) {
        return obj -> g.apply((DescribeQueryDefinitionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeQueryDefinitionsResponse> {
        /**
         * Sets the value of the QueryDefinitions property for this object.
         *
         * @param queryDefinitions
         *        The new value for the QueryDefinitions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryDefinitions(Collection<QueryDefinition> queryDefinitions);

        /**
         * Sets the value of the QueryDefinitions property for this object.
         *
         * @param queryDefinitions
         *        The new value for the QueryDefinitions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryDefinitions(QueryDefinition... queryDefinitions);

        /**
         * Sets the value of the QueryDefinitions property for this object.
         *
         * This is a convenience that creates an instance of the {@link List<QueryDefinition>.Builder} avoiding the need
         * to create one manually via {@link List<QueryDefinition>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<QueryDefinition>.Builder#build()} is called immediately and
         * its result is passed to {@link #queryDefinitions(List<QueryDefinition>)}.
         * 
         * @param queryDefinitions
         *        a consumer that will call methods on {@link List<QueryDefinition>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryDefinitions(List<QueryDefinition>)
         */
        Builder queryDefinitions(Consumer<QueryDefinition.Builder>... queryDefinitions);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudWatchLogsResponse.BuilderImpl implements Builder {
        private List<QueryDefinition> queryDefinitions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeQueryDefinitionsResponse model) {
            super(model);
            queryDefinitions(model.queryDefinitions);
            nextToken(model.nextToken);
        }

        public final Collection<QueryDefinition.Builder> getQueryDefinitions() {
            return queryDefinitions != null ? queryDefinitions.stream().map(QueryDefinition::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder queryDefinitions(Collection<QueryDefinition> queryDefinitions) {
            this.queryDefinitions = QueryDefinitionListCopier.copy(queryDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryDefinitions(QueryDefinition... queryDefinitions) {
            queryDefinitions(Arrays.asList(queryDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryDefinitions(Consumer<QueryDefinition.Builder>... queryDefinitions) {
            queryDefinitions(Stream.of(queryDefinitions).map(c -> QueryDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setQueryDefinitions(Collection<QueryDefinition.BuilderImpl> queryDefinitions) {
            this.queryDefinitions = QueryDefinitionListCopier.copyFromBuilder(queryDefinitions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeQueryDefinitionsResponse build() {
            return new DescribeQueryDefinitionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
