/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutQueryDefinitionRequest extends CloudWatchLogsRequest implements
        ToCopyableBuilder<PutQueryDefinitionRequest.Builder, PutQueryDefinitionRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutQueryDefinitionRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> QUERY_DEFINITION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutQueryDefinitionRequest::queryDefinitionId)).setter(setter(Builder::queryDefinitionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryDefinitionId").build()).build();

    private static final SdkField<List<String>> LOG_GROUP_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(PutQueryDefinitionRequest::logGroupNames))
            .setter(setter(Builder::logGroupNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutQueryDefinitionRequest::queryString)).setter(setter(Builder::queryString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryString").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            QUERY_DEFINITION_ID_FIELD, LOG_GROUP_NAMES_FIELD, QUERY_STRING_FIELD));

    private final String name;

    private final String queryDefinitionId;

    private final List<String> logGroupNames;

    private final String queryString;

    private PutQueryDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.queryDefinitionId = builder.queryDefinitionId;
        this.logGroupNames = builder.logGroupNames;
        this.queryString = builder.queryString;
    }

    /**
     * Returns the value of the Name property for this object.
     * 
     * @return The value of the Name property for this object.
     */
    public String name() {
        return name;
    }

    /**
     * Returns the value of the QueryDefinitionId property for this object.
     * 
     * @return The value of the QueryDefinitionId property for this object.
     */
    public String queryDefinitionId() {
        return queryDefinitionId;
    }

    /**
     * Returns true if the LogGroupNames property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasLogGroupNames() {
        return logGroupNames != null && !(logGroupNames instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the LogGroupNames property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLogGroupNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the LogGroupNames property for this object.
     */
    public List<String> logGroupNames() {
        return logGroupNames;
    }

    /**
     * Returns the value of the QueryString property for this object.
     * 
     * @return The value of the QueryString property for this object.
     */
    public String queryString() {
        return queryString;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(queryDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(logGroupNames());
        hashCode = 31 * hashCode + Objects.hashCode(queryString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutQueryDefinitionRequest)) {
            return false;
        }
        PutQueryDefinitionRequest other = (PutQueryDefinitionRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(queryDefinitionId(), other.queryDefinitionId())
                && Objects.equals(logGroupNames(), other.logGroupNames()) && Objects.equals(queryString(), other.queryString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutQueryDefinitionRequest").add("Name", name()).add("QueryDefinitionId", queryDefinitionId())
                .add("LogGroupNames", logGroupNames()).add("QueryString", queryString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "queryDefinitionId":
            return Optional.ofNullable(clazz.cast(queryDefinitionId()));
        case "logGroupNames":
            return Optional.ofNullable(clazz.cast(logGroupNames()));
        case "queryString":
            return Optional.ofNullable(clazz.cast(queryString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutQueryDefinitionRequest, T> g) {
        return obj -> g.apply((PutQueryDefinitionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutQueryDefinitionRequest> {
        /**
         * Sets the value of the Name property for this object.
         *
         * @param name
         *        The new value for the Name property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the QueryDefinitionId property for this object.
         *
         * @param queryDefinitionId
         *        The new value for the QueryDefinitionId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryDefinitionId(String queryDefinitionId);

        /**
         * Sets the value of the LogGroupNames property for this object.
         *
         * @param logGroupNames
         *        The new value for the LogGroupNames property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupNames(Collection<String> logGroupNames);

        /**
         * Sets the value of the LogGroupNames property for this object.
         *
         * @param logGroupNames
         *        The new value for the LogGroupNames property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupNames(String... logGroupNames);

        /**
         * Sets the value of the QueryString property for this object.
         *
         * @param queryString
         *        The new value for the QueryString property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryString(String queryString);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchLogsRequest.BuilderImpl implements Builder {
        private String name;

        private String queryDefinitionId;

        private List<String> logGroupNames = DefaultSdkAutoConstructList.getInstance();

        private String queryString;

        private BuilderImpl() {
        }

        private BuilderImpl(PutQueryDefinitionRequest model) {
            super(model);
            name(model.name);
            queryDefinitionId(model.queryDefinitionId);
            logGroupNames(model.logGroupNames);
            queryString(model.queryString);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getQueryDefinitionId() {
            return queryDefinitionId;
        }

        @Override
        public final Builder queryDefinitionId(String queryDefinitionId) {
            this.queryDefinitionId = queryDefinitionId;
            return this;
        }

        public final void setQueryDefinitionId(String queryDefinitionId) {
            this.queryDefinitionId = queryDefinitionId;
        }

        public final Collection<String> getLogGroupNames() {
            return logGroupNames;
        }

        @Override
        public final Builder logGroupNames(Collection<String> logGroupNames) {
            this.logGroupNames = LogGroupNamesCopier.copy(logGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logGroupNames(String... logGroupNames) {
            logGroupNames(Arrays.asList(logGroupNames));
            return this;
        }

        public final void setLogGroupNames(Collection<String> logGroupNames) {
            this.logGroupNames = LogGroupNamesCopier.copy(logGroupNames);
        }

        public final String getQueryString() {
            return queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutQueryDefinitionRequest build() {
            return new PutQueryDefinitionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
