/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutQueryDefinitionResponse extends CloudWatchLogsResponse implements
        ToCopyableBuilder<PutQueryDefinitionResponse.Builder, PutQueryDefinitionResponse> {
    private static final SdkField<String> QUERY_DEFINITION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutQueryDefinitionResponse::queryDefinitionId)).setter(setter(Builder::queryDefinitionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryDefinitionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_DEFINITION_ID_FIELD));

    private final String queryDefinitionId;

    private PutQueryDefinitionResponse(BuilderImpl builder) {
        super(builder);
        this.queryDefinitionId = builder.queryDefinitionId;
    }

    /**
     * <p>
     * The ID of the query definition.
     * </p>
     * 
     * @return The ID of the query definition.
     */
    public String queryDefinitionId() {
        return queryDefinitionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(queryDefinitionId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutQueryDefinitionResponse)) {
            return false;
        }
        PutQueryDefinitionResponse other = (PutQueryDefinitionResponse) obj;
        return Objects.equals(queryDefinitionId(), other.queryDefinitionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutQueryDefinitionResponse").add("QueryDefinitionId", queryDefinitionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "queryDefinitionId":
            return Optional.ofNullable(clazz.cast(queryDefinitionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutQueryDefinitionResponse, T> g) {
        return obj -> g.apply((PutQueryDefinitionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, PutQueryDefinitionResponse> {
        /**
         * <p>
         * The ID of the query definition.
         * </p>
         * 
         * @param queryDefinitionId
         *        The ID of the query definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryDefinitionId(String queryDefinitionId);
    }

    static final class BuilderImpl extends CloudWatchLogsResponse.BuilderImpl implements Builder {
        private String queryDefinitionId;

        private BuilderImpl() {
        }

        private BuilderImpl(PutQueryDefinitionResponse model) {
            super(model);
            queryDefinitionId(model.queryDefinitionId);
        }

        public final String getQueryDefinitionId() {
            return queryDefinitionId;
        }

        @Override
        public final Builder queryDefinitionId(String queryDefinitionId) {
            this.queryDefinitionId = queryDefinitionId;
            return this;
        }

        public final void setQueryDefinitionId(String queryDefinitionId) {
            this.queryDefinitionId = queryDefinitionId;
        }

        @Override
        public PutQueryDefinitionResponse build() {
            return new PutQueryDefinitionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
