/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetQueryResultsResponse extends CloudWatchLogsResponse implements
        ToCopyableBuilder<GetQueryResultsResponse.Builder, GetQueryResultsResponse> {
    private static final SdkField<List<List<ResultField>>> RESULTS_FIELD = SdkField
            .<List<List<ResultField>>> builder(MarshallingType.LIST)
            .getter(getter(GetQueryResultsResponse::results))
            .setter(setter(Builder::results))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("results").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<List<ResultField>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<ResultField> builder(MarshallingType.SDK_POJO)
                                                                            .constructor(ResultField::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<QueryStatistics> STATISTICS_FIELD = SdkField
            .<QueryStatistics> builder(MarshallingType.SDK_POJO).getter(getter(GetQueryResultsResponse::statistics))
            .setter(setter(Builder::statistics)).constructor(QueryStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statistics").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetQueryResultsResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULTS_FIELD,
            STATISTICS_FIELD, STATUS_FIELD));

    private final List<List<ResultField>> results;

    private final QueryStatistics statistics;

    private final String status;

    private GetQueryResultsResponse(BuilderImpl builder) {
        super(builder);
        this.results = builder.results;
        this.statistics = builder.statistics;
        this.status = builder.status;
    }

    /**
     * Returns true if the Results property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasResults() {
        return results != null && !(results instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The log events that matched the query criteria during the most recent time it ran.
     * </p>
     * <p>
     * The <code>results</code> value is an array of arrays. Each log event is one object in the top-level array. Each
     * of these log event objects is an array of <code>field</code>/<code>value</code> pairs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResults()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The log events that matched the query criteria during the most recent time it ran.</p>
     *         <p>
     *         The <code>results</code> value is an array of arrays. Each log event is one object in the top-level
     *         array. Each of these log event objects is an array of <code>field</code>/<code>value</code> pairs.
     */
    public List<List<ResultField>> results() {
        return results;
    }

    /**
     * <p>
     * Includes the number of log events scanned by the query, the number of log events that matched the query criteria,
     * and the total number of bytes in the log events that were scanned. These values reflect the full raw results of
     * the query.
     * </p>
     * 
     * @return Includes the number of log events scanned by the query, the number of log events that matched the query
     *         criteria, and the total number of bytes in the log events that were scanned. These values reflect the
     *         full raw results of the query.
     */
    public QueryStatistics statistics() {
        return statistics;
    }

    /**
     * <p>
     * The status of the most recent running of the query. Possible values are <code>Cancelled</code>,
     * <code>Complete</code>, <code>Failed</code>, <code>Running</code>, <code>Scheduled</code>, <code>Timeout</code>,
     * and <code>Unknown</code>.
     * </p>
     * <p>
     * Queries time out after 15 minutes of execution. To avoid having your queries time out, reduce the time range
     * being searched or partition your query into a number of queries.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link QueryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the most recent running of the query. Possible values are <code>Cancelled</code>,
     *         <code>Complete</code>, <code>Failed</code>, <code>Running</code>, <code>Scheduled</code>,
     *         <code>Timeout</code>, and <code>Unknown</code>.</p>
     *         <p>
     *         Queries time out after 15 minutes of execution. To avoid having your queries time out, reduce the time
     *         range being searched or partition your query into a number of queries.
     * @see QueryStatus
     */
    public QueryStatus status() {
        return QueryStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the most recent running of the query. Possible values are <code>Cancelled</code>,
     * <code>Complete</code>, <code>Failed</code>, <code>Running</code>, <code>Scheduled</code>, <code>Timeout</code>,
     * and <code>Unknown</code>.
     * </p>
     * <p>
     * Queries time out after 15 minutes of execution. To avoid having your queries time out, reduce the time range
     * being searched or partition your query into a number of queries.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link QueryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the most recent running of the query. Possible values are <code>Cancelled</code>,
     *         <code>Complete</code>, <code>Failed</code>, <code>Running</code>, <code>Scheduled</code>,
     *         <code>Timeout</code>, and <code>Unknown</code>.</p>
     *         <p>
     *         Queries time out after 15 minutes of execution. To avoid having your queries time out, reduce the time
     *         range being searched or partition your query into a number of queries.
     * @see QueryStatus
     */
    public String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(results());
        hashCode = 31 * hashCode + Objects.hashCode(statistics());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQueryResultsResponse)) {
            return false;
        }
        GetQueryResultsResponse other = (GetQueryResultsResponse) obj;
        return Objects.equals(results(), other.results()) && Objects.equals(statistics(), other.statistics())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetQueryResultsResponse").add("Results", results()).add("Statistics", statistics())
                .add("Status", statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "results":
            return Optional.ofNullable(clazz.cast(results()));
        case "statistics":
            return Optional.ofNullable(clazz.cast(statistics()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetQueryResultsResponse, T> g) {
        return obj -> g.apply((GetQueryResultsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetQueryResultsResponse> {
        /**
         * <p>
         * The log events that matched the query criteria during the most recent time it ran.
         * </p>
         * <p>
         * The <code>results</code> value is an array of arrays. Each log event is one object in the top-level array.
         * Each of these log event objects is an array of <code>field</code>/<code>value</code> pairs.
         * </p>
         * 
         * @param results
         *        The log events that matched the query criteria during the most recent time it ran.</p>
         *        <p>
         *        The <code>results</code> value is an array of arrays. Each log event is one object in the top-level
         *        array. Each of these log event objects is an array of <code>field</code>/<code>value</code> pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(Collection<? extends Collection<ResultField>> results);

        /**
         * <p>
         * The log events that matched the query criteria during the most recent time it ran.
         * </p>
         * <p>
         * The <code>results</code> value is an array of arrays. Each log event is one object in the top-level array.
         * Each of these log event objects is an array of <code>field</code>/<code>value</code> pairs.
         * </p>
         * 
         * @param results
         *        The log events that matched the query criteria during the most recent time it ran.</p>
         *        <p>
         *        The <code>results</code> value is an array of arrays. Each log event is one object in the top-level
         *        array. Each of these log event objects is an array of <code>field</code>/<code>value</code> pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(Collection<ResultField>... results);

        /**
         * <p>
         * Includes the number of log events scanned by the query, the number of log events that matched the query
         * criteria, and the total number of bytes in the log events that were scanned. These values reflect the full
         * raw results of the query.
         * </p>
         * 
         * @param statistics
         *        Includes the number of log events scanned by the query, the number of log events that matched the
         *        query criteria, and the total number of bytes in the log events that were scanned. These values
         *        reflect the full raw results of the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statistics(QueryStatistics statistics);

        /**
         * <p>
         * Includes the number of log events scanned by the query, the number of log events that matched the query
         * criteria, and the total number of bytes in the log events that were scanned. These values reflect the full
         * raw results of the query.
         * </p>
         * This is a convenience that creates an instance of the {@link QueryStatistics.Builder} avoiding the need to
         * create one manually via {@link QueryStatistics#builder()}.
         *
         * When the {@link Consumer} completes, {@link QueryStatistics.Builder#build()} is called immediately and its
         * result is passed to {@link #statistics(QueryStatistics)}.
         * 
         * @param statistics
         *        a consumer that will call methods on {@link QueryStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statistics(QueryStatistics)
         */
        default Builder statistics(Consumer<QueryStatistics.Builder> statistics) {
            return statistics(QueryStatistics.builder().applyMutation(statistics).build());
        }

        /**
         * <p>
         * The status of the most recent running of the query. Possible values are <code>Cancelled</code>,
         * <code>Complete</code>, <code>Failed</code>, <code>Running</code>, <code>Scheduled</code>,
         * <code>Timeout</code>, and <code>Unknown</code>.
         * </p>
         * <p>
         * Queries time out after 15 minutes of execution. To avoid having your queries time out, reduce the time range
         * being searched or partition your query into a number of queries.
         * </p>
         * 
         * @param status
         *        The status of the most recent running of the query. Possible values are <code>Cancelled</code>,
         *        <code>Complete</code>, <code>Failed</code>, <code>Running</code>, <code>Scheduled</code>,
         *        <code>Timeout</code>, and <code>Unknown</code>.</p>
         *        <p>
         *        Queries time out after 15 minutes of execution. To avoid having your queries time out, reduce the time
         *        range being searched or partition your query into a number of queries.
         * @see QueryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the most recent running of the query. Possible values are <code>Cancelled</code>,
         * <code>Complete</code>, <code>Failed</code>, <code>Running</code>, <code>Scheduled</code>,
         * <code>Timeout</code>, and <code>Unknown</code>.
         * </p>
         * <p>
         * Queries time out after 15 minutes of execution. To avoid having your queries time out, reduce the time range
         * being searched or partition your query into a number of queries.
         * </p>
         * 
         * @param status
         *        The status of the most recent running of the query. Possible values are <code>Cancelled</code>,
         *        <code>Complete</code>, <code>Failed</code>, <code>Running</code>, <code>Scheduled</code>,
         *        <code>Timeout</code>, and <code>Unknown</code>.</p>
         *        <p>
         *        Queries time out after 15 minutes of execution. To avoid having your queries time out, reduce the time
         *        range being searched or partition your query into a number of queries.
         * @see QueryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryStatus
         */
        Builder status(QueryStatus status);
    }

    static final class BuilderImpl extends CloudWatchLogsResponse.BuilderImpl implements Builder {
        private List<List<ResultField>> results = DefaultSdkAutoConstructList.getInstance();

        private QueryStatistics statistics;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetQueryResultsResponse model) {
            super(model);
            results(model.results);
            statistics(model.statistics);
            status(model.status);
        }

        public final Collection<? extends Collection<ResultField>> getResults() {
            return results;
        }

        @Override
        public final Builder results(Collection<? extends Collection<ResultField>> results) {
            this.results = QueryResultsCopier.copy(results);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(Collection<ResultField>... results) {
            results(Arrays.asList(results));
            return this;
        }

        public final void setResults(Collection<? extends Collection<ResultField>> results) {
            this.results = QueryResultsCopier.copy(results);
        }

        public final QueryStatistics.Builder getStatistics() {
            return statistics != null ? statistics.toBuilder() : null;
        }

        @Override
        public final Builder statistics(QueryStatistics statistics) {
            this.statistics = statistics;
            return this;
        }

        public final void setStatistics(QueryStatistics.BuilderImpl statistics) {
            this.statistics = statistics != null ? statistics.build() : null;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(QueryStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public GetQueryResultsResponse build() {
            return new GetQueryResultsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
