/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the number of log events scanned by the query, the number of log events that matched the query criteria, and
 * the total number of bytes in the log events that were scanned.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryStatistics implements SdkPojo, Serializable, ToCopyableBuilder<QueryStatistics.Builder, QueryStatistics> {
    private static final SdkField<Double> RECORDS_MATCHED_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("recordsMatched").getter(getter(QueryStatistics::recordsMatched)).setter(setter(Builder::recordsMatched))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordsMatched").build()).build();

    private static final SdkField<Double> RECORDS_SCANNED_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("recordsScanned").getter(getter(QueryStatistics::recordsScanned)).setter(setter(Builder::recordsScanned))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordsScanned").build()).build();

    private static final SdkField<Double> BYTES_SCANNED_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("bytesScanned").getter(getter(QueryStatistics::bytesScanned)).setter(setter(Builder::bytesScanned))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bytesScanned").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORDS_MATCHED_FIELD,
            RECORDS_SCANNED_FIELD, BYTES_SCANNED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double recordsMatched;

    private final Double recordsScanned;

    private final Double bytesScanned;

    private QueryStatistics(BuilderImpl builder) {
        this.recordsMatched = builder.recordsMatched;
        this.recordsScanned = builder.recordsScanned;
        this.bytesScanned = builder.bytesScanned;
    }

    /**
     * <p>
     * The number of log events that matched the query string.
     * </p>
     * 
     * @return The number of log events that matched the query string.
     */
    public Double recordsMatched() {
        return recordsMatched;
    }

    /**
     * <p>
     * The total number of log events scanned during the query.
     * </p>
     * 
     * @return The total number of log events scanned during the query.
     */
    public Double recordsScanned() {
        return recordsScanned;
    }

    /**
     * <p>
     * The total number of bytes in the log events scanned during the query.
     * </p>
     * 
     * @return The total number of bytes in the log events scanned during the query.
     */
    public Double bytesScanned() {
        return bytesScanned;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recordsMatched());
        hashCode = 31 * hashCode + Objects.hashCode(recordsScanned());
        hashCode = 31 * hashCode + Objects.hashCode(bytesScanned());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryStatistics)) {
            return false;
        }
        QueryStatistics other = (QueryStatistics) obj;
        return Objects.equals(recordsMatched(), other.recordsMatched())
                && Objects.equals(recordsScanned(), other.recordsScanned())
                && Objects.equals(bytesScanned(), other.bytesScanned());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("QueryStatistics").add("RecordsMatched", recordsMatched())
                .add("RecordsScanned", recordsScanned()).add("BytesScanned", bytesScanned()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "recordsMatched":
            return Optional.ofNullable(clazz.cast(recordsMatched()));
        case "recordsScanned":
            return Optional.ofNullable(clazz.cast(recordsScanned()));
        case "bytesScanned":
            return Optional.ofNullable(clazz.cast(bytesScanned()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryStatistics, T> g) {
        return obj -> g.apply((QueryStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueryStatistics> {
        /**
         * <p>
         * The number of log events that matched the query string.
         * </p>
         * 
         * @param recordsMatched
         *        The number of log events that matched the query string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordsMatched(Double recordsMatched);

        /**
         * <p>
         * The total number of log events scanned during the query.
         * </p>
         * 
         * @param recordsScanned
         *        The total number of log events scanned during the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordsScanned(Double recordsScanned);

        /**
         * <p>
         * The total number of bytes in the log events scanned during the query.
         * </p>
         * 
         * @param bytesScanned
         *        The total number of bytes in the log events scanned during the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bytesScanned(Double bytesScanned);
    }

    static final class BuilderImpl implements Builder {
        private Double recordsMatched;

        private Double recordsScanned;

        private Double bytesScanned;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryStatistics model) {
            recordsMatched(model.recordsMatched);
            recordsScanned(model.recordsScanned);
            bytesScanned(model.bytesScanned);
        }

        public final Double getRecordsMatched() {
            return recordsMatched;
        }

        @Override
        public final Builder recordsMatched(Double recordsMatched) {
            this.recordsMatched = recordsMatched;
            return this;
        }

        public final void setRecordsMatched(Double recordsMatched) {
            this.recordsMatched = recordsMatched;
        }

        public final Double getRecordsScanned() {
            return recordsScanned;
        }

        @Override
        public final Builder recordsScanned(Double recordsScanned) {
            this.recordsScanned = recordsScanned;
            return this;
        }

        public final void setRecordsScanned(Double recordsScanned) {
            this.recordsScanned = recordsScanned;
        }

        public final Double getBytesScanned() {
            return bytesScanned;
        }

        @Override
        public final Builder bytesScanned(Double bytesScanned) {
            this.bytesScanned = bytesScanned;
            return this;
        }

        public final void setBytesScanned(Double bytesScanned) {
            this.bytesScanned = bytesScanned;
        }

        @Override
        public QueryStatistics build() {
            return new QueryStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
