/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Metric filters express how CloudWatch Logs would extract metric observations from ingested log events and transform
 * them into metric data in a CloudWatch metric.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricFilter implements SdkPojo, Serializable, ToCopyableBuilder<MetricFilter.Builder, MetricFilter> {
    private static final SdkField<String> FILTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filterName").getter(getter(MetricFilter::filterName)).setter(setter(Builder::filterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterName").build()).build();

    private static final SdkField<String> FILTER_PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filterPattern").getter(getter(MetricFilter::filterPattern)).setter(setter(Builder::filterPattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterPattern").build()).build();

    private static final SdkField<List<MetricTransformation>> METRIC_TRANSFORMATIONS_FIELD = SdkField
            .<List<MetricTransformation>> builder(MarshallingType.LIST)
            .memberName("metricTransformations")
            .getter(getter(MetricFilter::metricTransformations))
            .setter(setter(Builder::metricTransformations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricTransformations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricTransformation> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricTransformation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> CREATION_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("creationTime").getter(getter(MetricFilter::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logGroupName").getter(getter(MetricFilter::logGroupName)).setter(setter(Builder::logGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_NAME_FIELD,
            FILTER_PATTERN_FIELD, METRIC_TRANSFORMATIONS_FIELD, CREATION_TIME_FIELD, LOG_GROUP_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String filterName;

    private final String filterPattern;

    private final List<MetricTransformation> metricTransformations;

    private final Long creationTime;

    private final String logGroupName;

    private MetricFilter(BuilderImpl builder) {
        this.filterName = builder.filterName;
        this.filterPattern = builder.filterPattern;
        this.metricTransformations = builder.metricTransformations;
        this.creationTime = builder.creationTime;
        this.logGroupName = builder.logGroupName;
    }

    /**
     * <p>
     * The name of the metric filter.
     * </p>
     * 
     * @return The name of the metric filter.
     */
    public final String filterName() {
        return filterName;
    }

    /**
     * Returns the value of the FilterPattern property for this object.
     * 
     * @return The value of the FilterPattern property for this object.
     */
    public final String filterPattern() {
        return filterPattern;
    }

    /**
     * Returns true if the MetricTransformations property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasMetricTransformations() {
        return metricTransformations != null && !(metricTransformations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metric transformations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMetricTransformations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The metric transformations.
     */
    public final List<MetricTransformation> metricTransformations() {
        return metricTransformations;
    }

    /**
     * <p>
     * The creation time of the metric filter, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC.
     * </p>
     * 
     * @return The creation time of the metric filter, expressed as the number of milliseconds after Jan 1, 1970
     *         00:00:00 UTC.
     */
    public final Long creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The name of the log group.
     * </p>
     * 
     * @return The name of the log group.
     */
    public final String logGroupName() {
        return logGroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filterName());
        hashCode = 31 * hashCode + Objects.hashCode(filterPattern());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricTransformations() ? metricTransformations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(logGroupName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricFilter)) {
            return false;
        }
        MetricFilter other = (MetricFilter) obj;
        return Objects.equals(filterName(), other.filterName()) && Objects.equals(filterPattern(), other.filterPattern())
                && hasMetricTransformations() == other.hasMetricTransformations()
                && Objects.equals(metricTransformations(), other.metricTransformations())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(logGroupName(), other.logGroupName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricFilter").add("FilterName", filterName()).add("FilterPattern", filterPattern())
                .add("MetricTransformations", hasMetricTransformations() ? metricTransformations() : null)
                .add("CreationTime", creationTime()).add("LogGroupName", logGroupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filterName":
            return Optional.ofNullable(clazz.cast(filterName()));
        case "filterPattern":
            return Optional.ofNullable(clazz.cast(filterPattern()));
        case "metricTransformations":
            return Optional.ofNullable(clazz.cast(metricTransformations()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "logGroupName":
            return Optional.ofNullable(clazz.cast(logGroupName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricFilter, T> g) {
        return obj -> g.apply((MetricFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricFilter> {
        /**
         * <p>
         * The name of the metric filter.
         * </p>
         * 
         * @param filterName
         *        The name of the metric filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterName(String filterName);

        /**
         * Sets the value of the FilterPattern property for this object.
         *
         * @param filterPattern
         *        The new value for the FilterPattern property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterPattern(String filterPattern);

        /**
         * <p>
         * The metric transformations.
         * </p>
         * 
         * @param metricTransformations
         *        The metric transformations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricTransformations(Collection<MetricTransformation> metricTransformations);

        /**
         * <p>
         * The metric transformations.
         * </p>
         * 
         * @param metricTransformations
         *        The metric transformations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricTransformations(MetricTransformation... metricTransformations);

        /**
         * <p>
         * The metric transformations.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MetricTransformation>.Builder} avoiding the
         * need to create one manually via {@link List<MetricTransformation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MetricTransformation>.Builder#build()} is called immediately
         * and its result is passed to {@link #metricTransformations(List<MetricTransformation>)}.
         * 
         * @param metricTransformations
         *        a consumer that will call methods on {@link List<MetricTransformation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricTransformations(List<MetricTransformation>)
         */
        Builder metricTransformations(Consumer<MetricTransformation.Builder>... metricTransformations);

        /**
         * <p>
         * The creation time of the metric filter, expressed as the number of milliseconds after Jan 1, 1970 00:00:00
         * UTC.
         * </p>
         * 
         * @param creationTime
         *        The creation time of the metric filter, expressed as the number of milliseconds after Jan 1, 1970
         *        00:00:00 UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Long creationTime);

        /**
         * <p>
         * The name of the log group.
         * </p>
         * 
         * @param logGroupName
         *        The name of the log group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);
    }

    static final class BuilderImpl implements Builder {
        private String filterName;

        private String filterPattern;

        private List<MetricTransformation> metricTransformations = DefaultSdkAutoConstructList.getInstance();

        private Long creationTime;

        private String logGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricFilter model) {
            filterName(model.filterName);
            filterPattern(model.filterPattern);
            metricTransformations(model.metricTransformations);
            creationTime(model.creationTime);
            logGroupName(model.logGroupName);
        }

        public final String getFilterName() {
            return filterName;
        }

        @Override
        public final Builder filterName(String filterName) {
            this.filterName = filterName;
            return this;
        }

        public final void setFilterName(String filterName) {
            this.filterName = filterName;
        }

        public final String getFilterPattern() {
            return filterPattern;
        }

        @Override
        public final Builder filterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
            return this;
        }

        public final void setFilterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
        }

        public final List<MetricTransformation.Builder> getMetricTransformations() {
            List<MetricTransformation.Builder> result = MetricTransformationsCopier.copyToBuilder(this.metricTransformations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder metricTransformations(Collection<MetricTransformation> metricTransformations) {
            this.metricTransformations = MetricTransformationsCopier.copy(metricTransformations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricTransformations(MetricTransformation... metricTransformations) {
            metricTransformations(Arrays.asList(metricTransformations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricTransformations(Consumer<MetricTransformation.Builder>... metricTransformations) {
            metricTransformations(Stream.of(metricTransformations)
                    .map(c -> MetricTransformation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMetricTransformations(Collection<MetricTransformation.BuilderImpl> metricTransformations) {
            this.metricTransformations = MetricTransformationsCopier.copyFromBuilder(metricTransformations);
        }

        public final Long getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Long creationTime) {
            this.creationTime = creationTime;
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        @Override
        public MetricFilter build() {
            return new MetricFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
