/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a matched event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricFilterMatchRecord implements SdkPojo, Serializable,
        ToCopyableBuilder<MetricFilterMatchRecord.Builder, MetricFilterMatchRecord> {
    private static final SdkField<Long> EVENT_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("eventNumber").getter(getter(MetricFilterMatchRecord::eventNumber)).setter(setter(Builder::eventNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventNumber").build()).build();

    private static final SdkField<String> EVENT_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventMessage").getter(getter(MetricFilterMatchRecord::eventMessage))
            .setter(setter(Builder::eventMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventMessage").build()).build();

    private static final SdkField<Map<String, String>> EXTRACTED_VALUES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("extractedValues")
            .getter(getter(MetricFilterMatchRecord::extractedValues))
            .setter(setter(Builder::extractedValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("extractedValues").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_NUMBER_FIELD,
            EVENT_MESSAGE_FIELD, EXTRACTED_VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long eventNumber;

    private final String eventMessage;

    private final Map<String, String> extractedValues;

    private MetricFilterMatchRecord(BuilderImpl builder) {
        this.eventNumber = builder.eventNumber;
        this.eventMessage = builder.eventMessage;
        this.extractedValues = builder.extractedValues;
    }

    /**
     * <p>
     * The event number.
     * </p>
     * 
     * @return The event number.
     */
    public final Long eventNumber() {
        return eventNumber;
    }

    /**
     * <p>
     * The raw event data.
     * </p>
     * 
     * @return The raw event data.
     */
    public final String eventMessage() {
        return eventMessage;
    }

    /**
     * Returns true if the ExtractedValues property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasExtractedValues() {
        return extractedValues != null && !(extractedValues instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The values extracted from the event data by the filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExtractedValues()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The values extracted from the event data by the filter.
     */
    public final Map<String, String> extractedValues() {
        return extractedValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventNumber());
        hashCode = 31 * hashCode + Objects.hashCode(eventMessage());
        hashCode = 31 * hashCode + Objects.hashCode(hasExtractedValues() ? extractedValues() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricFilterMatchRecord)) {
            return false;
        }
        MetricFilterMatchRecord other = (MetricFilterMatchRecord) obj;
        return Objects.equals(eventNumber(), other.eventNumber()) && Objects.equals(eventMessage(), other.eventMessage())
                && hasExtractedValues() == other.hasExtractedValues()
                && Objects.equals(extractedValues(), other.extractedValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricFilterMatchRecord").add("EventNumber", eventNumber()).add("EventMessage", eventMessage())
                .add("ExtractedValues", hasExtractedValues() ? extractedValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventNumber":
            return Optional.ofNullable(clazz.cast(eventNumber()));
        case "eventMessage":
            return Optional.ofNullable(clazz.cast(eventMessage()));
        case "extractedValues":
            return Optional.ofNullable(clazz.cast(extractedValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricFilterMatchRecord, T> g) {
        return obj -> g.apply((MetricFilterMatchRecord) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricFilterMatchRecord> {
        /**
         * <p>
         * The event number.
         * </p>
         * 
         * @param eventNumber
         *        The event number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventNumber(Long eventNumber);

        /**
         * <p>
         * The raw event data.
         * </p>
         * 
         * @param eventMessage
         *        The raw event data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventMessage(String eventMessage);

        /**
         * <p>
         * The values extracted from the event data by the filter.
         * </p>
         * 
         * @param extractedValues
         *        The values extracted from the event data by the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extractedValues(Map<String, String> extractedValues);
    }

    static final class BuilderImpl implements Builder {
        private Long eventNumber;

        private String eventMessage;

        private Map<String, String> extractedValues = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MetricFilterMatchRecord model) {
            eventNumber(model.eventNumber);
            eventMessage(model.eventMessage);
            extractedValues(model.extractedValues);
        }

        public final Long getEventNumber() {
            return eventNumber;
        }

        @Override
        public final Builder eventNumber(Long eventNumber) {
            this.eventNumber = eventNumber;
            return this;
        }

        public final void setEventNumber(Long eventNumber) {
            this.eventNumber = eventNumber;
        }

        public final String getEventMessage() {
            return eventMessage;
        }

        @Override
        public final Builder eventMessage(String eventMessage) {
            this.eventMessage = eventMessage;
            return this;
        }

        public final void setEventMessage(String eventMessage) {
            this.eventMessage = eventMessage;
        }

        public final Map<String, String> getExtractedValues() {
            if (extractedValues instanceof SdkAutoConstructMap) {
                return null;
            }
            return extractedValues;
        }

        @Override
        public final Builder extractedValues(Map<String, String> extractedValues) {
            this.extractedValues = ExtractedValuesCopier.copy(extractedValues);
            return this;
        }

        public final void setExtractedValues(Map<String, String> extractedValues) {
            this.extractedValues = ExtractedValuesCopier.copy(extractedValues);
        }

        @Override
        public MetricFilterMatchRecord build() {
            return new MetricFilterMatchRecord(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
