/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLogGroupFieldsResponse extends CloudWatchLogsResponse implements
        ToCopyableBuilder<GetLogGroupFieldsResponse.Builder, GetLogGroupFieldsResponse> {
    private static final SdkField<List<LogGroupField>> LOG_GROUP_FIELDS_FIELD = SdkField
            .<List<LogGroupField>> builder(MarshallingType.LIST)
            .memberName("logGroupFields")
            .getter(getter(GetLogGroupFieldsResponse::logGroupFields))
            .setter(setter(Builder::logGroupFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupFields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LogGroupField> builder(MarshallingType.SDK_POJO)
                                            .constructor(LogGroupField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_FIELDS_FIELD));

    private final List<LogGroupField> logGroupFields;

    private GetLogGroupFieldsResponse(BuilderImpl builder) {
        super(builder);
        this.logGroupFields = builder.logGroupFields;
    }

    /**
     * Returns true if the LogGroupFields property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasLogGroupFields() {
        return logGroupFields != null && !(logGroupFields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The array of fields found in the query. Each object in the array contains the name of the field, along with the
     * percentage of time it appeared in the log events that were queried.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLogGroupFields()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The array of fields found in the query. Each object in the array contains the name of the field, along
     *         with the percentage of time it appeared in the log events that were queried.
     */
    public final List<LogGroupField> logGroupFields() {
        return logGroupFields;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLogGroupFields() ? logGroupFields() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLogGroupFieldsResponse)) {
            return false;
        }
        GetLogGroupFieldsResponse other = (GetLogGroupFieldsResponse) obj;
        return hasLogGroupFields() == other.hasLogGroupFields() && Objects.equals(logGroupFields(), other.logGroupFields());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLogGroupFieldsResponse").add("LogGroupFields", hasLogGroupFields() ? logGroupFields() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logGroupFields":
            return Optional.ofNullable(clazz.cast(logGroupFields()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLogGroupFieldsResponse, T> g) {
        return obj -> g.apply((GetLogGroupFieldsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetLogGroupFieldsResponse> {
        /**
         * <p>
         * The array of fields found in the query. Each object in the array contains the name of the field, along with
         * the percentage of time it appeared in the log events that were queried.
         * </p>
         * 
         * @param logGroupFields
         *        The array of fields found in the query. Each object in the array contains the name of the field, along
         *        with the percentage of time it appeared in the log events that were queried.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupFields(Collection<LogGroupField> logGroupFields);

        /**
         * <p>
         * The array of fields found in the query. Each object in the array contains the name of the field, along with
         * the percentage of time it appeared in the log events that were queried.
         * </p>
         * 
         * @param logGroupFields
         *        The array of fields found in the query. Each object in the array contains the name of the field, along
         *        with the percentage of time it appeared in the log events that were queried.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupFields(LogGroupField... logGroupFields);

        /**
         * <p>
         * The array of fields found in the query. Each object in the array contains the name of the field, along with
         * the percentage of time it appeared in the log events that were queried.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LogGroupField>.Builder} avoiding the need
         * to create one manually via {@link List<LogGroupField>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LogGroupField>.Builder#build()} is called immediately and
         * its result is passed to {@link #logGroupFields(List<LogGroupField>)}.
         * 
         * @param logGroupFields
         *        a consumer that will call methods on {@link List<LogGroupField>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logGroupFields(List<LogGroupField>)
         */
        Builder logGroupFields(Consumer<LogGroupField.Builder>... logGroupFields);
    }

    static final class BuilderImpl extends CloudWatchLogsResponse.BuilderImpl implements Builder {
        private List<LogGroupField> logGroupFields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetLogGroupFieldsResponse model) {
            super(model);
            logGroupFields(model.logGroupFields);
        }

        public final List<LogGroupField.Builder> getLogGroupFields() {
            List<LogGroupField.Builder> result = LogGroupFieldListCopier.copyToBuilder(this.logGroupFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLogGroupFields(Collection<LogGroupField.BuilderImpl> logGroupFields) {
            this.logGroupFields = LogGroupFieldListCopier.copyFromBuilder(logGroupFields);
        }

        @Override
        @Transient
        public final Builder logGroupFields(Collection<LogGroupField> logGroupFields) {
            this.logGroupFields = LogGroupFieldListCopier.copy(logGroupFields);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder logGroupFields(LogGroupField... logGroupFields) {
            logGroupFields(Arrays.asList(logGroupFields));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder logGroupFields(Consumer<LogGroupField.Builder>... logGroupFields) {
            logGroupFields(Stream.of(logGroupFields).map(c -> LogGroupField.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetLogGroupFieldsResponse build() {
            return new GetLogGroupFieldsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
