/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a log group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LogGroup implements SdkPojo, Serializable, ToCopyableBuilder<LogGroup.Builder, LogGroup> {
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logGroupName").getter(getter(LogGroup::logGroupName)).setter(setter(Builder::logGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()).build();

    private static final SdkField<Long> CREATION_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("creationTime").getter(getter(LogGroup::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Integer> RETENTION_IN_DAYS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("retentionInDays").getter(getter(LogGroup::retentionInDays)).setter(setter(Builder::retentionInDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionInDays").build()).build();

    private static final SdkField<Integer> METRIC_FILTER_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("metricFilterCount").getter(getter(LogGroup::metricFilterCount))
            .setter(setter(Builder::metricFilterCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricFilterCount").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(LogGroup::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Long> STORED_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("storedBytes").getter(getter(LogGroup::storedBytes)).setter(setter(Builder::storedBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storedBytes").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyId").getter(getter(LogGroup::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_NAME_FIELD,
            CREATION_TIME_FIELD, RETENTION_IN_DAYS_FIELD, METRIC_FILTER_COUNT_FIELD, ARN_FIELD, STORED_BYTES_FIELD,
            KMS_KEY_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String logGroupName;

    private final Long creationTime;

    private final Integer retentionInDays;

    private final Integer metricFilterCount;

    private final String arn;

    private final Long storedBytes;

    private final String kmsKeyId;

    private LogGroup(BuilderImpl builder) {
        this.logGroupName = builder.logGroupName;
        this.creationTime = builder.creationTime;
        this.retentionInDays = builder.retentionInDays;
        this.metricFilterCount = builder.metricFilterCount;
        this.arn = builder.arn;
        this.storedBytes = builder.storedBytes;
        this.kmsKeyId = builder.kmsKeyId;
    }

    /**
     * <p>
     * The name of the log group.
     * </p>
     * 
     * @return The name of the log group.
     */
    public final String logGroupName() {
        return logGroupName;
    }

    /**
     * <p>
     * The creation time of the log group, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC.
     * </p>
     * 
     * @return The creation time of the log group, expressed as the number of milliseconds after Jan 1, 1970 00:00:00
     *         UTC.
     */
    public final Long creationTime() {
        return creationTime;
    }

    /**
     * Returns the value of the RetentionInDays property for this object.
     * 
     * @return The value of the RetentionInDays property for this object.
     */
    public final Integer retentionInDays() {
        return retentionInDays;
    }

    /**
     * <p>
     * The number of metric filters.
     * </p>
     * 
     * @return The number of metric filters.
     */
    public final Integer metricFilterCount() {
        return metricFilterCount;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the log group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the log group.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The number of bytes stored.
     * </p>
     * 
     * @return The number of bytes stored.
     */
    public final Long storedBytes() {
        return storedBytes;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the CMK to use when encrypting log data.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the CMK to use when encrypting log data.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(retentionInDays());
        hashCode = 31 * hashCode + Objects.hashCode(metricFilterCount());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(storedBytes());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogGroup)) {
            return false;
        }
        LogGroup other = (LogGroup) obj;
        return Objects.equals(logGroupName(), other.logGroupName()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(retentionInDays(), other.retentionInDays())
                && Objects.equals(metricFilterCount(), other.metricFilterCount()) && Objects.equals(arn(), other.arn())
                && Objects.equals(storedBytes(), other.storedBytes()) && Objects.equals(kmsKeyId(), other.kmsKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LogGroup").add("LogGroupName", logGroupName()).add("CreationTime", creationTime())
                .add("RetentionInDays", retentionInDays()).add("MetricFilterCount", metricFilterCount()).add("Arn", arn())
                .add("StoredBytes", storedBytes()).add("KmsKeyId", kmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logGroupName":
            return Optional.ofNullable(clazz.cast(logGroupName()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "retentionInDays":
            return Optional.ofNullable(clazz.cast(retentionInDays()));
        case "metricFilterCount":
            return Optional.ofNullable(clazz.cast(metricFilterCount()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "storedBytes":
            return Optional.ofNullable(clazz.cast(storedBytes()));
        case "kmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LogGroup, T> g) {
        return obj -> g.apply((LogGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LogGroup> {
        /**
         * <p>
         * The name of the log group.
         * </p>
         * 
         * @param logGroupName
         *        The name of the log group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);

        /**
         * <p>
         * The creation time of the log group, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC.
         * </p>
         * 
         * @param creationTime
         *        The creation time of the log group, expressed as the number of milliseconds after Jan 1, 1970 00:00:00
         *        UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Long creationTime);

        /**
         * Sets the value of the RetentionInDays property for this object.
         *
         * @param retentionInDays
         *        The new value for the RetentionInDays property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionInDays(Integer retentionInDays);

        /**
         * <p>
         * The number of metric filters.
         * </p>
         * 
         * @param metricFilterCount
         *        The number of metric filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricFilterCount(Integer metricFilterCount);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the log group.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the log group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The number of bytes stored.
         * </p>
         * 
         * @param storedBytes
         *        The number of bytes stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storedBytes(Long storedBytes);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the CMK to use when encrypting log data.
         * </p>
         * 
         * @param kmsKeyId
         *        The Amazon Resource Name (ARN) of the CMK to use when encrypting log data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);
    }

    static final class BuilderImpl implements Builder {
        private String logGroupName;

        private Long creationTime;

        private Integer retentionInDays;

        private Integer metricFilterCount;

        private String arn;

        private Long storedBytes;

        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(LogGroup model) {
            logGroupName(model.logGroupName);
            creationTime(model.creationTime);
            retentionInDays(model.retentionInDays);
            metricFilterCount(model.metricFilterCount);
            arn(model.arn);
            storedBytes(model.storedBytes);
            kmsKeyId(model.kmsKeyId);
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        @Override
        @Transient
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final Long getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Long creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Integer getRetentionInDays() {
            return retentionInDays;
        }

        public final void setRetentionInDays(Integer retentionInDays) {
            this.retentionInDays = retentionInDays;
        }

        @Override
        @Transient
        public final Builder retentionInDays(Integer retentionInDays) {
            this.retentionInDays = retentionInDays;
            return this;
        }

        public final Integer getMetricFilterCount() {
            return metricFilterCount;
        }

        public final void setMetricFilterCount(Integer metricFilterCount) {
            this.metricFilterCount = metricFilterCount;
        }

        @Override
        @Transient
        public final Builder metricFilterCount(Integer metricFilterCount) {
            this.metricFilterCount = metricFilterCount;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Long getStoredBytes() {
            return storedBytes;
        }

        public final void setStoredBytes(Long storedBytes) {
            this.storedBytes = storedBytes;
        }

        @Override
        @Transient
        public final Builder storedBytes(Long storedBytes) {
            this.storedBytes = storedBytes;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        @Transient
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        @Override
        public LogGroup build() {
            return new LogGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
