/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class FilterLogEventsRequest extends CloudWatchLogsRequest implements
        ToCopyableBuilder<FilterLogEventsRequest.Builder, FilterLogEventsRequest> {
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logGroupName").getter(getter(FilterLogEventsRequest::logGroupName))
            .setter(setter(Builder::logGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()).build();

    private static final SdkField<List<String>> LOG_STREAM_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("logStreamNames")
            .getter(getter(FilterLogEventsRequest::logStreamNames))
            .setter(setter(Builder::logStreamNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logStreamNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LOG_STREAM_NAME_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logStreamNamePrefix").getter(getter(FilterLogEventsRequest::logStreamNamePrefix))
            .setter(setter(Builder::logStreamNamePrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logStreamNamePrefix").build())
            .build();

    private static final SdkField<Long> START_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("startTime")
            .getter(getter(FilterLogEventsRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<Long> END_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("endTime")
            .getter(getter(FilterLogEventsRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<String> FILTER_PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filterPattern").getter(getter(FilterLogEventsRequest::filterPattern))
            .setter(setter(Builder::filterPattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterPattern").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(FilterLogEventsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("limit")
            .getter(getter(FilterLogEventsRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("limit").build()).build();

    private static final SdkField<Boolean> INTERLEAVED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("interleaved").getter(getter(FilterLogEventsRequest::interleaved)).setter(setter(Builder::interleaved))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interleaved").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_NAME_FIELD,
            LOG_STREAM_NAMES_FIELD, LOG_STREAM_NAME_PREFIX_FIELD, START_TIME_FIELD, END_TIME_FIELD, FILTER_PATTERN_FIELD,
            NEXT_TOKEN_FIELD, LIMIT_FIELD, INTERLEAVED_FIELD));

    private final String logGroupName;

    private final List<String> logStreamNames;

    private final String logStreamNamePrefix;

    private final Long startTime;

    private final Long endTime;

    private final String filterPattern;

    private final String nextToken;

    private final Integer limit;

    private final Boolean interleaved;

    private FilterLogEventsRequest(BuilderImpl builder) {
        super(builder);
        this.logGroupName = builder.logGroupName;
        this.logStreamNames = builder.logStreamNames;
        this.logStreamNamePrefix = builder.logStreamNamePrefix;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.filterPattern = builder.filterPattern;
        this.nextToken = builder.nextToken;
        this.limit = builder.limit;
        this.interleaved = builder.interleaved;
    }

    /**
     * <p>
     * The name of the log group to search.
     * </p>
     * 
     * @return The name of the log group to search.
     */
    public final String logGroupName() {
        return logGroupName;
    }

    /**
     * Returns true if the LogStreamNames property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasLogStreamNames() {
        return logStreamNames != null && !(logStreamNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters the results to only logs from the log streams in this list.
     * </p>
     * <p>
     * If you specify a value for both <code>logStreamNamePrefix</code> and <code>logStreamNames</code>, the action
     * returns an <code>InvalidParameterException</code> error.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLogStreamNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Filters the results to only logs from the log streams in this list.</p>
     *         <p>
     *         If you specify a value for both <code>logStreamNamePrefix</code> and <code>logStreamNames</code>, the
     *         action returns an <code>InvalidParameterException</code> error.
     */
    public final List<String> logStreamNames() {
        return logStreamNames;
    }

    /**
     * <p>
     * Filters the results to include only events from log streams that have names starting with this prefix.
     * </p>
     * <p>
     * If you specify a value for both <code>logStreamNamePrefix</code> and <code>logStreamNames</code>, but the value
     * for <code>logStreamNamePrefix</code> does not match any log stream names specified in <code>logStreamNames</code>
     * , the action returns an <code>InvalidParameterException</code> error.
     * </p>
     * 
     * @return Filters the results to include only events from log streams that have names starting with this
     *         prefix.</p>
     *         <p>
     *         If you specify a value for both <code>logStreamNamePrefix</code> and <code>logStreamNames</code>, but the
     *         value for <code>logStreamNamePrefix</code> does not match any log stream names specified in
     *         <code>logStreamNames</code>, the action returns an <code>InvalidParameterException</code> error.
     */
    public final String logStreamNamePrefix() {
        return logStreamNamePrefix;
    }

    /**
     * <p>
     * The start of the time range, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. Events with
     * a timestamp before this time are not returned.
     * </p>
     * 
     * @return The start of the time range, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC.
     *         Events with a timestamp before this time are not returned.
     */
    public final Long startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end of the time range, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. Events with a
     * timestamp later than this time are not returned.
     * </p>
     * 
     * @return The end of the time range, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. Events
     *         with a timestamp later than this time are not returned.
     */
    public final Long endTime() {
        return endTime;
    }

    /**
     * <p>
     * The filter pattern to use. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html">Filter and Pattern
     * Syntax</a>.
     * </p>
     * <p>
     * If not provided, all the events are matched.
     * </p>
     * 
     * @return The filter pattern to use. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html">Filter and
     *         Pattern Syntax</a>.</p>
     *         <p>
     *         If not provided, all the events are matched.
     */
    public final String filterPattern() {
        return filterPattern;
    }

    /**
     * <p>
     * The token for the next set of events to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return The token for the next set of events to return. (You received this token from a previous call.)
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of events to return. The default is 10,000 events.
     * </p>
     * 
     * @return The maximum number of events to return. The default is 10,000 events.
     */
    public final Integer limit() {
        return limit;
    }

    /**
     * <p>
     * If the value is true, the operation makes a best effort to provide responses that contain events from multiple
     * log streams within the log group, interleaved in a single response. If the value is false, all the matched log
     * events in the first log stream are searched first, then those in the next log stream, and so on. The default is
     * false.
     * </p>
     * <p>
     * <b>Important:</b> Starting on June 17, 2019, this parameter is ignored and the value is assumed to be true. The
     * response from this operation always interleaves events from multiple log streams within a log group.
     * </p>
     * 
     * @return If the value is true, the operation makes a best effort to provide responses that contain events from
     *         multiple log streams within the log group, interleaved in a single response. If the value is false, all
     *         the matched log events in the first log stream are searched first, then those in the next log stream, and
     *         so on. The default is false.</p>
     *         <p>
     *         <b>Important:</b> Starting on June 17, 2019, this parameter is ignored and the value is assumed to be
     *         true. The response from this operation always interleaves events from multiple log streams within a log
     *         group.
     * @deprecated Starting on June 17, 2019, this parameter will be ignored and the value will be assumed to be true.
     *             The response from this operation will always interleave events from multiple log streams within a log
     *             group.
     */
    @Deprecated
    public final Boolean interleaved() {
        return interleaved;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(hasLogStreamNames() ? logStreamNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(logStreamNamePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(filterPattern());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(interleaved());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterLogEventsRequest)) {
            return false;
        }
        FilterLogEventsRequest other = (FilterLogEventsRequest) obj;
        return Objects.equals(logGroupName(), other.logGroupName()) && hasLogStreamNames() == other.hasLogStreamNames()
                && Objects.equals(logStreamNames(), other.logStreamNames())
                && Objects.equals(logStreamNamePrefix(), other.logStreamNamePrefix())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(filterPattern(), other.filterPattern()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(limit(), other.limit()) && Objects.equals(interleaved(), other.interleaved());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FilterLogEventsRequest").add("LogGroupName", logGroupName())
                .add("LogStreamNames", hasLogStreamNames() ? logStreamNames() : null)
                .add("LogStreamNamePrefix", logStreamNamePrefix()).add("StartTime", startTime()).add("EndTime", endTime())
                .add("FilterPattern", filterPattern()).add("NextToken", nextToken()).add("Limit", limit())
                .add("Interleaved", interleaved()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logGroupName":
            return Optional.ofNullable(clazz.cast(logGroupName()));
        case "logStreamNames":
            return Optional.ofNullable(clazz.cast(logStreamNames()));
        case "logStreamNamePrefix":
            return Optional.ofNullable(clazz.cast(logStreamNamePrefix()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "filterPattern":
            return Optional.ofNullable(clazz.cast(filterPattern()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "interleaved":
            return Optional.ofNullable(clazz.cast(interleaved()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FilterLogEventsRequest, T> g) {
        return obj -> g.apply((FilterLogEventsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsRequest.Builder, SdkPojo, CopyableBuilder<Builder, FilterLogEventsRequest> {
        /**
         * <p>
         * The name of the log group to search.
         * </p>
         * 
         * @param logGroupName
         *        The name of the log group to search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);

        /**
         * <p>
         * Filters the results to only logs from the log streams in this list.
         * </p>
         * <p>
         * If you specify a value for both <code>logStreamNamePrefix</code> and <code>logStreamNames</code>, the action
         * returns an <code>InvalidParameterException</code> error.
         * </p>
         * 
         * @param logStreamNames
         *        Filters the results to only logs from the log streams in this list.</p>
         *        <p>
         *        If you specify a value for both <code>logStreamNamePrefix</code> and <code>logStreamNames</code>, the
         *        action returns an <code>InvalidParameterException</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStreamNames(Collection<String> logStreamNames);

        /**
         * <p>
         * Filters the results to only logs from the log streams in this list.
         * </p>
         * <p>
         * If you specify a value for both <code>logStreamNamePrefix</code> and <code>logStreamNames</code>, the action
         * returns an <code>InvalidParameterException</code> error.
         * </p>
         * 
         * @param logStreamNames
         *        Filters the results to only logs from the log streams in this list.</p>
         *        <p>
         *        If you specify a value for both <code>logStreamNamePrefix</code> and <code>logStreamNames</code>, the
         *        action returns an <code>InvalidParameterException</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStreamNames(String... logStreamNames);

        /**
         * <p>
         * Filters the results to include only events from log streams that have names starting with this prefix.
         * </p>
         * <p>
         * If you specify a value for both <code>logStreamNamePrefix</code> and <code>logStreamNames</code>, but the
         * value for <code>logStreamNamePrefix</code> does not match any log stream names specified in
         * <code>logStreamNames</code>, the action returns an <code>InvalidParameterException</code> error.
         * </p>
         * 
         * @param logStreamNamePrefix
         *        Filters the results to include only events from log streams that have names starting with this
         *        prefix.</p>
         *        <p>
         *        If you specify a value for both <code>logStreamNamePrefix</code> and <code>logStreamNames</code>, but
         *        the value for <code>logStreamNamePrefix</code> does not match any log stream names specified in
         *        <code>logStreamNames</code>, the action returns an <code>InvalidParameterException</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStreamNamePrefix(String logStreamNamePrefix);

        /**
         * <p>
         * The start of the time range, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. Events
         * with a timestamp before this time are not returned.
         * </p>
         * 
         * @param startTime
         *        The start of the time range, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC.
         *        Events with a timestamp before this time are not returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Long startTime);

        /**
         * <p>
         * The end of the time range, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. Events
         * with a timestamp later than this time are not returned.
         * </p>
         * 
         * @param endTime
         *        The end of the time range, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC.
         *        Events with a timestamp later than this time are not returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Long endTime);

        /**
         * <p>
         * The filter pattern to use. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html">Filter and
         * Pattern Syntax</a>.
         * </p>
         * <p>
         * If not provided, all the events are matched.
         * </p>
         * 
         * @param filterPattern
         *        The filter pattern to use. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html">Filter and
         *        Pattern Syntax</a>.</p>
         *        <p>
         *        If not provided, all the events are matched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterPattern(String filterPattern);

        /**
         * <p>
         * The token for the next set of events to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of events to return. (You received this token from a previous call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of events to return. The default is 10,000 events.
         * </p>
         * 
         * @param limit
         *        The maximum number of events to return. The default is 10,000 events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * If the value is true, the operation makes a best effort to provide responses that contain events from
         * multiple log streams within the log group, interleaved in a single response. If the value is false, all the
         * matched log events in the first log stream are searched first, then those in the next log stream, and so on.
         * The default is false.
         * </p>
         * <p>
         * <b>Important:</b> Starting on June 17, 2019, this parameter is ignored and the value is assumed to be true.
         * The response from this operation always interleaves events from multiple log streams within a log group.
         * </p>
         * 
         * @param interleaved
         *        If the value is true, the operation makes a best effort to provide responses that contain events from
         *        multiple log streams within the log group, interleaved in a single response. If the value is false,
         *        all the matched log events in the first log stream are searched first, then those in the next log
         *        stream, and so on. The default is false.</p>
         *        <p>
         *        <b>Important:</b> Starting on June 17, 2019, this parameter is ignored and the value is assumed to be
         *        true. The response from this operation always interleaves events from multiple log streams within a
         *        log group.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated Starting on June 17, 2019, this parameter will be ignored and the value will be assumed to be
         *             true. The response from this operation will always interleave events from multiple log streams
         *             within a log group.
         */
        @Deprecated
        Builder interleaved(Boolean interleaved);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchLogsRequest.BuilderImpl implements Builder {
        private String logGroupName;

        private List<String> logStreamNames = DefaultSdkAutoConstructList.getInstance();

        private String logStreamNamePrefix;

        private Long startTime;

        private Long endTime;

        private String filterPattern;

        private String nextToken;

        private Integer limit;

        private Boolean interleaved;

        private BuilderImpl() {
        }

        private BuilderImpl(FilterLogEventsRequest model) {
            super(model);
            logGroupName(model.logGroupName);
            logStreamNames(model.logStreamNames);
            logStreamNamePrefix(model.logStreamNamePrefix);
            startTime(model.startTime);
            endTime(model.endTime);
            filterPattern(model.filterPattern);
            nextToken(model.nextToken);
            limit(model.limit);
            interleaved(model.interleaved);
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        @Override
        @Transient
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final Collection<String> getLogStreamNames() {
            if (logStreamNames instanceof SdkAutoConstructList) {
                return null;
            }
            return logStreamNames;
        }

        public final void setLogStreamNames(Collection<String> logStreamNames) {
            this.logStreamNames = InputLogStreamNamesCopier.copy(logStreamNames);
        }

        @Override
        @Transient
        public final Builder logStreamNames(Collection<String> logStreamNames) {
            this.logStreamNames = InputLogStreamNamesCopier.copy(logStreamNames);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder logStreamNames(String... logStreamNames) {
            logStreamNames(Arrays.asList(logStreamNames));
            return this;
        }

        public final String getLogStreamNamePrefix() {
            return logStreamNamePrefix;
        }

        public final void setLogStreamNamePrefix(String logStreamNamePrefix) {
            this.logStreamNamePrefix = logStreamNamePrefix;
        }

        @Override
        @Transient
        public final Builder logStreamNamePrefix(String logStreamNamePrefix) {
            this.logStreamNamePrefix = logStreamNamePrefix;
            return this;
        }

        public final Long getStartTime() {
            return startTime;
        }

        public final void setStartTime(Long startTime) {
            this.startTime = startTime;
        }

        @Override
        @Transient
        public final Builder startTime(Long startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Long getEndTime() {
            return endTime;
        }

        public final void setEndTime(Long endTime) {
            this.endTime = endTime;
        }

        @Override
        @Transient
        public final Builder endTime(Long endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getFilterPattern() {
            return filterPattern;
        }

        public final void setFilterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
        }

        @Override
        @Transient
        public final Builder filterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        @Transient
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        @Deprecated
        public final Boolean getInterleaved() {
            return interleaved;
        }

        @Deprecated
        public final void setInterleaved(Boolean interleaved) {
            this.interleaved = interleaved;
        }

        @Override
        @Transient
        @Deprecated
        public final Builder interleaved(Boolean interleaved) {
            this.interleaved = interleaved;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public FilterLogEventsRequest build() {
            return new FilterLogEventsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
