/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Reserved.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryCompileError implements SdkPojo, Serializable,
        ToCopyableBuilder<QueryCompileError.Builder, QueryCompileError> {
    private static final SdkField<QueryCompileErrorLocation> LOCATION_FIELD = SdkField
            .<QueryCompileErrorLocation> builder(MarshallingType.SDK_POJO).memberName("location")
            .getter(getter(QueryCompileError::location)).setter(setter(Builder::location))
            .constructor(QueryCompileErrorLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(QueryCompileError::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(LOCATION_FIELD, MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final QueryCompileErrorLocation location;

    private final String message;

    private QueryCompileError(BuilderImpl builder) {
        this.location = builder.location;
        this.message = builder.message;
    }

    /**
     * <p>
     * Reserved.
     * </p>
     * 
     * @return Reserved.
     */
    public final QueryCompileErrorLocation location() {
        return location;
    }

    /**
     * <p>
     * Reserved.
     * </p>
     * 
     * @return Reserved.
     */
    public final String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryCompileError)) {
            return false;
        }
        QueryCompileError other = (QueryCompileError) obj;
        return Objects.equals(location(), other.location()) && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QueryCompileError").add("Location", location()).add("Message", message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "location":
            return Optional.ofNullable(clazz.cast(location()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryCompileError, T> g) {
        return obj -> g.apply((QueryCompileError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueryCompileError> {
        /**
         * <p>
         * Reserved.
         * </p>
         * 
         * @param location
         *        Reserved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(QueryCompileErrorLocation location);

        /**
         * <p>
         * Reserved.
         * </p>
         * This is a convenience method that creates an instance of the {@link QueryCompileErrorLocation.Builder}
         * avoiding the need to create one manually via {@link QueryCompileErrorLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link QueryCompileErrorLocation.Builder#build()} is called immediately
         * and its result is passed to {@link #location(QueryCompileErrorLocation)}.
         * 
         * @param location
         *        a consumer that will call methods on {@link QueryCompileErrorLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #location(QueryCompileErrorLocation)
         */
        default Builder location(Consumer<QueryCompileErrorLocation.Builder> location) {
            return location(QueryCompileErrorLocation.builder().applyMutation(location).build());
        }

        /**
         * <p>
         * Reserved.
         * </p>
         * 
         * @param message
         *        Reserved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private QueryCompileErrorLocation location;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryCompileError model) {
            location(model.location);
            message(model.message);
        }

        public final QueryCompileErrorLocation.Builder getLocation() {
            return location != null ? location.toBuilder() : null;
        }

        public final void setLocation(QueryCompileErrorLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        @Override
        @Transient
        public final Builder location(QueryCompileErrorLocation location) {
            this.location = location;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        @Transient
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public QueryCompileError build() {
            return new QueryCompileError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
