/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutSubscriptionFilterRequest extends CloudWatchLogsRequest implements
        ToCopyableBuilder<PutSubscriptionFilterRequest.Builder, PutSubscriptionFilterRequest> {
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logGroupName").getter(getter(PutSubscriptionFilterRequest::logGroupName))
            .setter(setter(Builder::logGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()).build();

    private static final SdkField<String> FILTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filterName").getter(getter(PutSubscriptionFilterRequest::filterName))
            .setter(setter(Builder::filterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterName").build()).build();

    private static final SdkField<String> FILTER_PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filterPattern").getter(getter(PutSubscriptionFilterRequest::filterPattern))
            .setter(setter(Builder::filterPattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterPattern").build()).build();

    private static final SdkField<String> DESTINATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destinationArn").getter(getter(PutSubscriptionFilterRequest::destinationArn))
            .setter(setter(Builder::destinationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationArn").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(PutSubscriptionFilterRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> DISTRIBUTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("distribution").getter(getter(PutSubscriptionFilterRequest::distributionAsString))
            .setter(setter(Builder::distribution))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distribution").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_NAME_FIELD,
            FILTER_NAME_FIELD, FILTER_PATTERN_FIELD, DESTINATION_ARN_FIELD, ROLE_ARN_FIELD, DISTRIBUTION_FIELD));

    private final String logGroupName;

    private final String filterName;

    private final String filterPattern;

    private final String destinationArn;

    private final String roleArn;

    private final String distribution;

    private PutSubscriptionFilterRequest(BuilderImpl builder) {
        super(builder);
        this.logGroupName = builder.logGroupName;
        this.filterName = builder.filterName;
        this.filterPattern = builder.filterPattern;
        this.destinationArn = builder.destinationArn;
        this.roleArn = builder.roleArn;
        this.distribution = builder.distribution;
    }

    /**
     * <p>
     * The name of the log group.
     * </p>
     * 
     * @return The name of the log group.
     */
    public final String logGroupName() {
        return logGroupName;
    }

    /**
     * <p>
     * A name for the subscription filter. If you are updating an existing filter, you must specify the correct name in
     * <code>filterName</code>. To find the name of the filter currently associated with a log group, use <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeSubscriptionFilters.html"
     * >DescribeSubscriptionFilters</a>.
     * </p>
     * 
     * @return A name for the subscription filter. If you are updating an existing filter, you must specify the correct
     *         name in <code>filterName</code>. To find the name of the filter currently associated with a log group,
     *         use <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeSubscriptionFilters.html"
     *         >DescribeSubscriptionFilters</a>.
     */
    public final String filterName() {
        return filterName;
    }

    /**
     * <p>
     * A filter pattern for subscribing to a filtered stream of log events.
     * </p>
     * 
     * @return A filter pattern for subscribing to a filtered stream of log events.
     */
    public final String filterPattern() {
        return filterPattern;
    }

    /**
     * <p>
     * The ARN of the destination to deliver matching log events to. Currently, the supported destinations are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * An Amazon Kinesis stream belonging to the same account as the subscription filter, for same-account delivery.
     * </p>
     * </li>
     * <li>
     * <p>
     * A logical destination (specified using an ARN) belonging to a different account, for cross-account delivery.
     * </p>
     * <p>
     * If you are setting up a cross-account subscription, the destination must have an IAM policy associated with it
     * that allows the sender to send logs to the destination. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDestinationPolicy.html"
     * >PutDestinationPolicy</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * An Amazon Kinesis Firehose delivery stream belonging to the same account as the subscription filter, for
     * same-account delivery.
     * </p>
     * </li>
     * <li>
     * <p>
     * An AWS Lambda function belonging to the same account as the subscription filter, for same-account delivery.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The ARN of the destination to deliver matching log events to. Currently, the supported destinations
     *         are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         An Amazon Kinesis stream belonging to the same account as the subscription filter, for same-account
     *         delivery.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A logical destination (specified using an ARN) belonging to a different account, for cross-account
     *         delivery.
     *         </p>
     *         <p>
     *         If you are setting up a cross-account subscription, the destination must have an IAM policy associated
     *         with it that allows the sender to send logs to the destination. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDestinationPolicy.html"
     *         >PutDestinationPolicy</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         An Amazon Kinesis Firehose delivery stream belonging to the same account as the subscription filter, for
     *         same-account delivery.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         An AWS Lambda function belonging to the same account as the subscription filter, for same-account
     *         delivery.
     *         </p>
     *         </li>
     */
    public final String destinationArn() {
        return destinationArn;
    }

    /**
     * <p>
     * The ARN of an IAM role that grants CloudWatch Logs permissions to deliver ingested log events to the destination
     * stream. You don't need to provide the ARN when you are working with a logical destination for cross-account
     * delivery.
     * </p>
     * 
     * @return The ARN of an IAM role that grants CloudWatch Logs permissions to deliver ingested log events to the
     *         destination stream. You don't need to provide the ARN when you are working with a logical destination for
     *         cross-account delivery.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The method used to distribute log data to the destination. By default, log data is grouped by log stream, but the
     * grouping can be set to random for a more even distribution. This property is only applicable when the destination
     * is an Amazon Kinesis stream.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #distribution} will
     * return {@link Distribution#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #distributionAsString}.
     * </p>
     * 
     * @return The method used to distribute log data to the destination. By default, log data is grouped by log stream,
     *         but the grouping can be set to random for a more even distribution. This property is only applicable when
     *         the destination is an Amazon Kinesis stream.
     * @see Distribution
     */
    public final Distribution distribution() {
        return Distribution.fromValue(distribution);
    }

    /**
     * <p>
     * The method used to distribute log data to the destination. By default, log data is grouped by log stream, but the
     * grouping can be set to random for a more even distribution. This property is only applicable when the destination
     * is an Amazon Kinesis stream.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #distribution} will
     * return {@link Distribution#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #distributionAsString}.
     * </p>
     * 
     * @return The method used to distribute log data to the destination. By default, log data is grouped by log stream,
     *         but the grouping can be set to random for a more even distribution. This property is only applicable when
     *         the destination is an Amazon Kinesis stream.
     * @see Distribution
     */
    public final String distributionAsString() {
        return distribution;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(filterName());
        hashCode = 31 * hashCode + Objects.hashCode(filterPattern());
        hashCode = 31 * hashCode + Objects.hashCode(destinationArn());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(distributionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSubscriptionFilterRequest)) {
            return false;
        }
        PutSubscriptionFilterRequest other = (PutSubscriptionFilterRequest) obj;
        return Objects.equals(logGroupName(), other.logGroupName()) && Objects.equals(filterName(), other.filterName())
                && Objects.equals(filterPattern(), other.filterPattern())
                && Objects.equals(destinationArn(), other.destinationArn()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(distributionAsString(), other.distributionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutSubscriptionFilterRequest").add("LogGroupName", logGroupName())
                .add("FilterName", filterName()).add("FilterPattern", filterPattern()).add("DestinationArn", destinationArn())
                .add("RoleArn", roleArn()).add("Distribution", distributionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logGroupName":
            return Optional.ofNullable(clazz.cast(logGroupName()));
        case "filterName":
            return Optional.ofNullable(clazz.cast(filterName()));
        case "filterPattern":
            return Optional.ofNullable(clazz.cast(filterPattern()));
        case "destinationArn":
            return Optional.ofNullable(clazz.cast(destinationArn()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "distribution":
            return Optional.ofNullable(clazz.cast(distributionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutSubscriptionFilterRequest, T> g) {
        return obj -> g.apply((PutSubscriptionFilterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutSubscriptionFilterRequest> {
        /**
         * <p>
         * The name of the log group.
         * </p>
         * 
         * @param logGroupName
         *        The name of the log group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);

        /**
         * <p>
         * A name for the subscription filter. If you are updating an existing filter, you must specify the correct name
         * in <code>filterName</code>. To find the name of the filter currently associated with a log group, use <a
         * href=
         * "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeSubscriptionFilters.html"
         * >DescribeSubscriptionFilters</a>.
         * </p>
         * 
         * @param filterName
         *        A name for the subscription filter. If you are updating an existing filter, you must specify the
         *        correct name in <code>filterName</code>. To find the name of the filter currently associated with a
         *        log group, use <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeSubscriptionFilters.html"
         *        >DescribeSubscriptionFilters</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterName(String filterName);

        /**
         * <p>
         * A filter pattern for subscribing to a filtered stream of log events.
         * </p>
         * 
         * @param filterPattern
         *        A filter pattern for subscribing to a filtered stream of log events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterPattern(String filterPattern);

        /**
         * <p>
         * The ARN of the destination to deliver matching log events to. Currently, the supported destinations are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * An Amazon Kinesis stream belonging to the same account as the subscription filter, for same-account delivery.
         * </p>
         * </li>
         * <li>
         * <p>
         * A logical destination (specified using an ARN) belonging to a different account, for cross-account delivery.
         * </p>
         * <p>
         * If you are setting up a cross-account subscription, the destination must have an IAM policy associated with
         * it that allows the sender to send logs to the destination. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDestinationPolicy.html"
         * >PutDestinationPolicy</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * An Amazon Kinesis Firehose delivery stream belonging to the same account as the subscription filter, for
         * same-account delivery.
         * </p>
         * </li>
         * <li>
         * <p>
         * An AWS Lambda function belonging to the same account as the subscription filter, for same-account delivery.
         * </p>
         * </li>
         * </ul>
         * 
         * @param destinationArn
         *        The ARN of the destination to deliver matching log events to. Currently, the supported destinations
         *        are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        An Amazon Kinesis stream belonging to the same account as the subscription filter, for same-account
         *        delivery.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A logical destination (specified using an ARN) belonging to a different account, for cross-account
         *        delivery.
         *        </p>
         *        <p>
         *        If you are setting up a cross-account subscription, the destination must have an IAM policy associated
         *        with it that allows the sender to send logs to the destination. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDestinationPolicy.html"
         *        >PutDestinationPolicy</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        An Amazon Kinesis Firehose delivery stream belonging to the same account as the subscription filter,
         *        for same-account delivery.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        An AWS Lambda function belonging to the same account as the subscription filter, for same-account
         *        delivery.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationArn(String destinationArn);

        /**
         * <p>
         * The ARN of an IAM role that grants CloudWatch Logs permissions to deliver ingested log events to the
         * destination stream. You don't need to provide the ARN when you are working with a logical destination for
         * cross-account delivery.
         * </p>
         * 
         * @param roleArn
         *        The ARN of an IAM role that grants CloudWatch Logs permissions to deliver ingested log events to the
         *        destination stream. You don't need to provide the ARN when you are working with a logical destination
         *        for cross-account delivery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The method used to distribute log data to the destination. By default, log data is grouped by log stream, but
         * the grouping can be set to random for a more even distribution. This property is only applicable when the
         * destination is an Amazon Kinesis stream.
         * </p>
         * 
         * @param distribution
         *        The method used to distribute log data to the destination. By default, log data is grouped by log
         *        stream, but the grouping can be set to random for a more even distribution. This property is only
         *        applicable when the destination is an Amazon Kinesis stream.
         * @see Distribution
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Distribution
         */
        Builder distribution(String distribution);

        /**
         * <p>
         * The method used to distribute log data to the destination. By default, log data is grouped by log stream, but
         * the grouping can be set to random for a more even distribution. This property is only applicable when the
         * destination is an Amazon Kinesis stream.
         * </p>
         * 
         * @param distribution
         *        The method used to distribute log data to the destination. By default, log data is grouped by log
         *        stream, but the grouping can be set to random for a more even distribution. This property is only
         *        applicable when the destination is an Amazon Kinesis stream.
         * @see Distribution
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Distribution
         */
        Builder distribution(Distribution distribution);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchLogsRequest.BuilderImpl implements Builder {
        private String logGroupName;

        private String filterName;

        private String filterPattern;

        private String destinationArn;

        private String roleArn;

        private String distribution;

        private BuilderImpl() {
        }

        private BuilderImpl(PutSubscriptionFilterRequest model) {
            super(model);
            logGroupName(model.logGroupName);
            filterName(model.filterName);
            filterPattern(model.filterPattern);
            destinationArn(model.destinationArn);
            roleArn(model.roleArn);
            distribution(model.distribution);
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        @Override
        @Transient
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final String getFilterName() {
            return filterName;
        }

        public final void setFilterName(String filterName) {
            this.filterName = filterName;
        }

        @Override
        @Transient
        public final Builder filterName(String filterName) {
            this.filterName = filterName;
            return this;
        }

        public final String getFilterPattern() {
            return filterPattern;
        }

        public final void setFilterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
        }

        @Override
        @Transient
        public final Builder filterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
            return this;
        }

        public final String getDestinationArn() {
            return destinationArn;
        }

        public final void setDestinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
        }

        @Override
        @Transient
        public final Builder destinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getDistribution() {
            return distribution;
        }

        public final void setDistribution(String distribution) {
            this.distribution = distribution;
        }

        @Override
        @Transient
        public final Builder distribution(String distribution) {
            this.distribution = distribution;
            return this;
        }

        @Override
        @Transient
        public final Builder distribution(Distribution distribution) {
            this.distribution(distribution == null ? null : distribution.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutSubscriptionFilterRequest build() {
            return new PutSubscriptionFilterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
