/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeResourcePoliciesResponse extends CloudWatchLogsResponse implements
        ToCopyableBuilder<DescribeResourcePoliciesResponse.Builder, DescribeResourcePoliciesResponse> {
    private static final SdkField<List<ResourcePolicy>> RESOURCE_POLICIES_FIELD = SdkField
            .<List<ResourcePolicy>> builder(MarshallingType.LIST)
            .memberName("resourcePolicies")
            .getter(getter(DescribeResourcePoliciesResponse::resourcePolicies))
            .setter(setter(Builder::resourcePolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourcePolicies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourcePolicy> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourcePolicy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeResourcePoliciesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_POLICIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ResourcePolicy> resourcePolicies;

    private final String nextToken;

    private DescribeResourcePoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.resourcePolicies = builder.resourcePolicies;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourcePolicies property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourcePolicies() {
        return resourcePolicies != null && !(resourcePolicies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The resource policies that exist in this account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourcePolicies} method.
     * </p>
     * 
     * @return The resource policies that exist in this account.
     */
    public final List<ResourcePolicy> resourcePolicies() {
        return resourcePolicies;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasResourcePolicies() ? resourcePolicies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeResourcePoliciesResponse)) {
            return false;
        }
        DescribeResourcePoliciesResponse other = (DescribeResourcePoliciesResponse) obj;
        return hasResourcePolicies() == other.hasResourcePolicies()
                && Objects.equals(resourcePolicies(), other.resourcePolicies()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeResourcePoliciesResponse")
                .add("ResourcePolicies", hasResourcePolicies() ? resourcePolicies() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourcePolicies":
            return Optional.ofNullable(clazz.cast(resourcePolicies()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeResourcePoliciesResponse, T> g) {
        return obj -> g.apply((DescribeResourcePoliciesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeResourcePoliciesResponse> {
        /**
         * <p>
         * The resource policies that exist in this account.
         * </p>
         * 
         * @param resourcePolicies
         *        The resource policies that exist in this account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcePolicies(Collection<ResourcePolicy> resourcePolicies);

        /**
         * <p>
         * The resource policies that exist in this account.
         * </p>
         * 
         * @param resourcePolicies
         *        The resource policies that exist in this account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcePolicies(ResourcePolicy... resourcePolicies);

        /**
         * <p>
         * The resource policies that exist in this account.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ResourcePolicy>.Builder} avoiding
         * the need to create one manually via {@link List<ResourcePolicy>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourcePolicy>.Builder#build()} is called immediately and
         * its result is passed to {@link #resourcePolicies(List<ResourcePolicy>)}.
         * 
         * @param resourcePolicies
         *        a consumer that will call methods on {@link List<ResourcePolicy>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourcePolicies(List<ResourcePolicy>)
         */
        Builder resourcePolicies(Consumer<ResourcePolicy.Builder>... resourcePolicies);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudWatchLogsResponse.BuilderImpl implements Builder {
        private List<ResourcePolicy> resourcePolicies = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeResourcePoliciesResponse model) {
            super(model);
            resourcePolicies(model.resourcePolicies);
            nextToken(model.nextToken);
        }

        public final List<ResourcePolicy.Builder> getResourcePolicies() {
            List<ResourcePolicy.Builder> result = ResourcePoliciesCopier.copyToBuilder(this.resourcePolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourcePolicies(Collection<ResourcePolicy.BuilderImpl> resourcePolicies) {
            this.resourcePolicies = ResourcePoliciesCopier.copyFromBuilder(resourcePolicies);
        }

        @Override
        public final Builder resourcePolicies(Collection<ResourcePolicy> resourcePolicies) {
            this.resourcePolicies = ResourcePoliciesCopier.copy(resourcePolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourcePolicies(ResourcePolicy... resourcePolicies) {
            resourcePolicies(Arrays.asList(resourcePolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourcePolicies(Consumer<ResourcePolicy.Builder>... resourcePolicies) {
            resourcePolicies(Stream.of(resourcePolicies).map(c -> ResourcePolicy.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeResourcePoliciesResponse build() {
            return new DescribeResourcePoliciesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
