/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLogRecordRequest extends CloudWatchLogsRequest implements
        ToCopyableBuilder<GetLogRecordRequest.Builder, GetLogRecordRequest> {
    private static final SdkField<String> LOG_RECORD_POINTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logRecordPointer").getter(getter(GetLogRecordRequest::logRecordPointer))
            .setter(setter(Builder::logRecordPointer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logRecordPointer").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_RECORD_POINTER_FIELD));

    private final String logRecordPointer;

    private GetLogRecordRequest(BuilderImpl builder) {
        super(builder);
        this.logRecordPointer = builder.logRecordPointer;
    }

    /**
     * <p>
     * The pointer corresponding to the log event record you want to retrieve. You get this from the response of a
     * <code>GetQueryResults</code> operation. In that response, the value of the <code>@ptr</code> field for a log
     * event is the value to use as <code>logRecordPointer</code> to retrieve that complete log event record.
     * </p>
     * 
     * @return The pointer corresponding to the log event record you want to retrieve. You get this from the response of
     *         a <code>GetQueryResults</code> operation. In that response, the value of the <code>@ptr</code> field for
     *         a log event is the value to use as <code>logRecordPointer</code> to retrieve that complete log event
     *         record.
     */
    public final String logRecordPointer() {
        return logRecordPointer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(logRecordPointer());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLogRecordRequest)) {
            return false;
        }
        GetLogRecordRequest other = (GetLogRecordRequest) obj;
        return Objects.equals(logRecordPointer(), other.logRecordPointer());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLogRecordRequest").add("LogRecordPointer", logRecordPointer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logRecordPointer":
            return Optional.ofNullable(clazz.cast(logRecordPointer()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLogRecordRequest, T> g) {
        return obj -> g.apply((GetLogRecordRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetLogRecordRequest> {
        /**
         * <p>
         * The pointer corresponding to the log event record you want to retrieve. You get this from the response of a
         * <code>GetQueryResults</code> operation. In that response, the value of the <code>@ptr</code> field for a log
         * event is the value to use as <code>logRecordPointer</code> to retrieve that complete log event record.
         * </p>
         * 
         * @param logRecordPointer
         *        The pointer corresponding to the log event record you want to retrieve. You get this from the response
         *        of a <code>GetQueryResults</code> operation. In that response, the value of the <code>@ptr</code>
         *        field for a log event is the value to use as <code>logRecordPointer</code> to retrieve that complete
         *        log event record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logRecordPointer(String logRecordPointer);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchLogsRequest.BuilderImpl implements Builder {
        private String logRecordPointer;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLogRecordRequest model) {
            super(model);
            logRecordPointer(model.logRecordPointer);
        }

        public final String getLogRecordPointer() {
            return logRecordPointer;
        }

        public final void setLogRecordPointer(String logRecordPointer) {
            this.logRecordPointer = logRecordPointer;
        }

        @Override
        @Transient
        public final Builder logRecordPointer(String logRecordPointer) {
            this.logRecordPointer = logRecordPointer;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetLogRecordRequest build() {
            return new GetLogRecordRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
