/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLogEventsRequest extends CloudWatchLogsRequest implements
        ToCopyableBuilder<GetLogEventsRequest.Builder, GetLogEventsRequest> {
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logGroupName").getter(getter(GetLogEventsRequest::logGroupName)).setter(setter(Builder::logGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()).build();

    private static final SdkField<String> LOG_STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logStreamName").getter(getter(GetLogEventsRequest::logStreamName))
            .setter(setter(Builder::logStreamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logStreamName").build()).build();

    private static final SdkField<Long> START_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("startTime")
            .getter(getter(GetLogEventsRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<Long> END_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("endTime")
            .getter(getter(GetLogEventsRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetLogEventsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("limit")
            .getter(getter(GetLogEventsRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("limit").build()).build();

    private static final SdkField<Boolean> START_FROM_HEAD_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("startFromHead").getter(getter(GetLogEventsRequest::startFromHead))
            .setter(setter(Builder::startFromHead))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startFromHead").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_NAME_FIELD,
            LOG_STREAM_NAME_FIELD, START_TIME_FIELD, END_TIME_FIELD, NEXT_TOKEN_FIELD, LIMIT_FIELD, START_FROM_HEAD_FIELD));

    private final String logGroupName;

    private final String logStreamName;

    private final Long startTime;

    private final Long endTime;

    private final String nextToken;

    private final Integer limit;

    private final Boolean startFromHead;

    private GetLogEventsRequest(BuilderImpl builder) {
        super(builder);
        this.logGroupName = builder.logGroupName;
        this.logStreamName = builder.logStreamName;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.nextToken = builder.nextToken;
        this.limit = builder.limit;
        this.startFromHead = builder.startFromHead;
    }

    /**
     * <p>
     * The name of the log group.
     * </p>
     * 
     * @return The name of the log group.
     */
    public final String logGroupName() {
        return logGroupName;
    }

    /**
     * <p>
     * The name of the log stream.
     * </p>
     * 
     * @return The name of the log stream.
     */
    public final String logStreamName() {
        return logStreamName;
    }

    /**
     * <p>
     * The start of the time range, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. Events with
     * a timestamp equal to this time or later than this time are included. Events with a timestamp earlier than this
     * time are not included.
     * </p>
     * 
     * @return The start of the time range, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC.
     *         Events with a timestamp equal to this time or later than this time are included. Events with a timestamp
     *         earlier than this time are not included.
     */
    public final Long startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end of the time range, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. Events with a
     * timestamp equal to or later than this time are not included.
     * </p>
     * 
     * @return The end of the time range, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. Events
     *         with a timestamp equal to or later than this time are not included.
     */
    public final Long endTime() {
        return endTime;
    }

    /**
     * <p>
     * The token for the next set of items to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return The token for the next set of items to return. (You received this token from a previous call.)
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of log events returned. If you don't specify a value, the maximum is as many log events as can
     * fit in a response size of 1 MB, up to 10,000 log events.
     * </p>
     * 
     * @return The maximum number of log events returned. If you don't specify a value, the maximum is as many log
     *         events as can fit in a response size of 1 MB, up to 10,000 log events.
     */
    public final Integer limit() {
        return limit;
    }

    /**
     * <p>
     * If the value is true, the earliest log events are returned first. If the value is false, the latest log events
     * are returned first. The default value is false.
     * </p>
     * <p>
     * If you are using a previous <code>nextForwardToken</code> value as the <code>nextToken</code> in this operation,
     * you must specify <code>true</code> for <code>startFromHead</code>.
     * </p>
     * 
     * @return If the value is true, the earliest log events are returned first. If the value is false, the latest log
     *         events are returned first. The default value is false.</p>
     *         <p>
     *         If you are using a previous <code>nextForwardToken</code> value as the <code>nextToken</code> in this
     *         operation, you must specify <code>true</code> for <code>startFromHead</code>.
     */
    public final Boolean startFromHead() {
        return startFromHead;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(logStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(startFromHead());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLogEventsRequest)) {
            return false;
        }
        GetLogEventsRequest other = (GetLogEventsRequest) obj;
        return Objects.equals(logGroupName(), other.logGroupName()) && Objects.equals(logStreamName(), other.logStreamName())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(limit(), other.limit())
                && Objects.equals(startFromHead(), other.startFromHead());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLogEventsRequest").add("LogGroupName", logGroupName()).add("LogStreamName", logStreamName())
                .add("StartTime", startTime()).add("EndTime", endTime()).add("NextToken", nextToken()).add("Limit", limit())
                .add("StartFromHead", startFromHead()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logGroupName":
            return Optional.ofNullable(clazz.cast(logGroupName()));
        case "logStreamName":
            return Optional.ofNullable(clazz.cast(logStreamName()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "startFromHead":
            return Optional.ofNullable(clazz.cast(startFromHead()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLogEventsRequest, T> g) {
        return obj -> g.apply((GetLogEventsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetLogEventsRequest> {
        /**
         * <p>
         * The name of the log group.
         * </p>
         * 
         * @param logGroupName
         *        The name of the log group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);

        /**
         * <p>
         * The name of the log stream.
         * </p>
         * 
         * @param logStreamName
         *        The name of the log stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStreamName(String logStreamName);

        /**
         * <p>
         * The start of the time range, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. Events
         * with a timestamp equal to this time or later than this time are included. Events with a timestamp earlier
         * than this time are not included.
         * </p>
         * 
         * @param startTime
         *        The start of the time range, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC.
         *        Events with a timestamp equal to this time or later than this time are included. Events with a
         *        timestamp earlier than this time are not included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Long startTime);

        /**
         * <p>
         * The end of the time range, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. Events
         * with a timestamp equal to or later than this time are not included.
         * </p>
         * 
         * @param endTime
         *        The end of the time range, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC.
         *        Events with a timestamp equal to or later than this time are not included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Long endTime);

        /**
         * <p>
         * The token for the next set of items to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. (You received this token from a previous call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of log events returned. If you don't specify a value, the maximum is as many log events as
         * can fit in a response size of 1 MB, up to 10,000 log events.
         * </p>
         * 
         * @param limit
         *        The maximum number of log events returned. If you don't specify a value, the maximum is as many log
         *        events as can fit in a response size of 1 MB, up to 10,000 log events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * If the value is true, the earliest log events are returned first. If the value is false, the latest log
         * events are returned first. The default value is false.
         * </p>
         * <p>
         * If you are using a previous <code>nextForwardToken</code> value as the <code>nextToken</code> in this
         * operation, you must specify <code>true</code> for <code>startFromHead</code>.
         * </p>
         * 
         * @param startFromHead
         *        If the value is true, the earliest log events are returned first. If the value is false, the latest
         *        log events are returned first. The default value is false.</p>
         *        <p>
         *        If you are using a previous <code>nextForwardToken</code> value as the <code>nextToken</code> in this
         *        operation, you must specify <code>true</code> for <code>startFromHead</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startFromHead(Boolean startFromHead);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchLogsRequest.BuilderImpl implements Builder {
        private String logGroupName;

        private String logStreamName;

        private Long startTime;

        private Long endTime;

        private String nextToken;

        private Integer limit;

        private Boolean startFromHead;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLogEventsRequest model) {
            super(model);
            logGroupName(model.logGroupName);
            logStreamName(model.logStreamName);
            startTime(model.startTime);
            endTime(model.endTime);
            nextToken(model.nextToken);
            limit(model.limit);
            startFromHead(model.startFromHead);
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final String getLogStreamName() {
            return logStreamName;
        }

        public final void setLogStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
        }

        @Override
        public final Builder logStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
            return this;
        }

        public final Long getStartTime() {
            return startTime;
        }

        public final void setStartTime(Long startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Long startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Long getEndTime() {
            return endTime;
        }

        public final void setEndTime(Long endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Long endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final Boolean getStartFromHead() {
            return startFromHead;
        }

        public final void setStartFromHead(Boolean startFromHead) {
            this.startFromHead = startFromHead;
        }

        @Override
        public final Builder startFromHead(Boolean startFromHead) {
            this.startFromHead = startFromHead;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetLogEventsRequest build() {
            return new GetLogEventsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
